/***************************************************************************
                          kwifi_ifaceimpl.cpp  -  description
                             -------------------
    begin                : Sun Jan 22 17:44:20 CEST 2001
    copyright            : (C) 2006 by Stefan Winter
    email                : swinter@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <QPixmap>
#include <QBitmap>
#include <QPainter>
#include <QString>
#include <QFont>
#include <QTimer>
#include <kdebug.h>
#include <ksystemtrayicon.h>
#include <kprocess.h>
#include "kwifi_ifaceimpl.h"
#include "kwifi_settings.h"
#include "asusled.h"
#include "statistics.h"
#include "kwifimanager.h"
#include "networkscanning.h"
#include "interface_wireless_wirelessextensions.h"

void
KWiFi_Iface::updateTrayIcon ( int newQual, int newSig, int newNoise )
{
  int newStrength = KWiFiSettings::self (  )->alternateStrength (  ) ? newSig - newNoise : newQual;
  QPixmap temp ( 30, 30 );
  QPainter bla ( &temp );
  bla.fillRect ( 0, 0, 30, 30, palette().brush(QPalette::Window) );
  QPixmap *ICON;
  QLabel strengthNumber ( "" );

  int qualityClass = newStrength / 5 + 2;
  if ( qualityClass > 5 )
    qualityClass = 5;
  if (qualityClass < 0 )
    qualityClass = 0;
  switch ( device->getDeviceState (  ) )
    {
    case AP_CONNECT:
      ICON = KWiFiManagerApp::STRENGTHPIC[qualityClass];
      strengthNumber.setText ( QString ( "%1" ).arg ( newStrength ) );
      if ( led->state == false )
	led->On (  );
      break;
    case NO_CONNECTION:
      ICON = KWiFiManagerApp::STRENGTHPIC[1];
      strengthNumber.setText ( "0" );
      if ( led->state == true )
	led->Off (  );
      break;
    default:
      ICON = KWiFiManagerApp::STRENGTHPIC[0];
      strengthNumber.setText ( i18n ( "N/A" ) );
      if ( led->state == true )
	led->Off (  );
    };

  bla.drawPixmap ( 1, 4, *ICON );

  static QFont labelfont ( "Helvetica", 10 );

  if ( KWiFiSettings::self()->showStrengthNumberInTray() )
    {
      labelfont.setStyleHint ( QFont::SansSerif, QFont::NoAntialias );
      labelfont.setStretch ( QFont::Condensed );
      strengthNumber.setFont ( labelfont );
      strengthNumber.setFixedSize ( strengthNumber.sizeHint (  ) );
      QPixmap labeltemp = QPixmap::grabWidget ( &strengthNumber );
      labeltemp.setMask ( labeltemp.createHeuristicMask (  ) );
      bla.drawPixmap ( 2, 2, labeltemp );
    }

  // done with painting
  bla.end();

  temp.setMask ( temp.createHeuristicMask (  ) );
  trayicon->setIcon ( temp );
  trayicon->setToolTip ( "SSID: " + device->get_essid (  ) );
  this->setWindowIcon ( temp );
}

KWiFi_Iface::KWiFi_Iface ( KWiFiManagerApp* parent )
{

  device = new Interface_wireless_wirelessextensions ( );

  led = new Led (  );

  trayicon = new KSystemTrayIcon ( parent );
  trayicon->show (  );

  zentrallayout = new QGridLayout ( this );

  iface_container = new QWidget ( this );
  iface_ui.setupUi ( iface_container );

  statsContainer = new QWidget ( this );
  stats_ui.setupUi ( statsContainer );

  statistik = new Statistics ( device, stats_ui.groupBox );
  statistik->setFixedSize ( 480, 200 );
  statistik->setObjectName ( QString::fromUtf8 ( "statsPlaceholder" ) );
  stats_ui.statsPlaceholder = statistik;
  stats_ui.gridLayout1->addWidget ( statistik, 0, 1, 3, 3 );
  statsContainer->hide (  );

  zentrallayout->addWidget ( iface_container, 0, 0 );

  connect ( device, SIGNAL ( notifyInterfaceChanged()), this, SLOT ( slotChangeInterfaceChangeNotification ()));

  connect ( device, SIGNAL ( statsUpdated (  ) ), statistik, SLOT ( update (  ) ) );
  connect ( device, SIGNAL ( statsUpdated (  ) ), this, SLOT ( updateStatsSurroundings (  ) ) );

  connect ( device, SIGNAL ( strengthChanged ( int, int, int ) ), this, SLOT ( updateTrayIcon ( int, int, int ) ) );
  connect ( device, SIGNAL ( strengthChanged ( int, int, int ) ), this, SLOT ( updateStrengthBar ( int, int, int ) ) );
  connect ( device, SIGNAL ( statusChanged (  ) ), this, SLOT ( updateStatus (  ) ) );
  connect ( device, SIGNAL ( speedChanged ( signed long ) ), this, SLOT ( updateSpeed ( signed long ) ) );
  connect ( device, SIGNAL ( modeChanged ( CARDSTATES ) ), this, SLOT ( updateCardState ( CARDSTATES ) ) );
  connect ( device, SIGNAL ( essidChanged ( QString ) ), parent, SLOT ( slotLogESSID ( QString ) ) );
  connect ( device, SIGNAL ( txPowerChanged (  ) ), this, SLOT ( slotTXPowerChanged (  ) ) );
  connect ( iface_ui.networkScan, SIGNAL ( clicked (  ) ), this, SLOT ( slotNetworkScan (  ) ) );
  connect ( iface_ui.statsButton, SIGNAL ( clicked (  ) ), this, SLOT ( toggleStats (  ) ) );

  highestExperiencedSpeed = 0;

  dataUpdateTrigger = new QTimer ( this );
  connect ( dataUpdateTrigger, SIGNAL ( timeout (  ) ), device, SLOT ( poll_device_info (  ) ) );
  dataUpdateTrigger->start ( KWiFiSettings::self (  )->refreshRate (  ) );

  tricorderTrigger = new QTimer (  );
  connect ( tricorderTrigger, SIGNAL ( timeout (  ) ), this, SLOT ( tricorderBeep (  ) ) );

  device->poll_device_info();
}

void
KWiFi_Iface::slotChangeInterfaceChangeNotification ()

{
	kDebug() << "slotChangeInterfaceChangeNotification ()" << endl;
	emit interfaceChanged( this );
}

void
KWiFi_Iface::slotTXPowerChanged (  )
{
	  iface_ui.disableRadio->setChecked ( device->get_txpower_disabled (  ) );
}

void
KWiFi_Iface::updateStatsSurroundings (  )
{
  int top = statistik->determineTop (  );
  int bot = statistik->determineBottom (  );

  if ( top < 0 && bot < 0 )
    {
      stats_ui.maxLevelLabel->setText ( i18n ( "%1 dBm", top ) );
      stats_ui.minLevelLabel->setText ( i18n ( "%1 dBm", bot ) );
    }
  else
    {
      stats_ui.maxLevelLabel->setText ( ( ( QString ) "%1" ).arg ( top ) );
      stats_ui.minLevelLabel->setText ( ( ( QString ) "%1" ).arg ( bot ) );
    }

  stats_ui.historyTime->setText ( i18n ( "-%1 s", KWiFiSettings::self (  )->refreshRate (  ) * 240 / 1000 ) );

}

void
KWiFi_Iface::updateSpeed ( signed long newSpeed )
{
  // the following is on record only for cards that can't report the maxBitrate
  if ( newSpeed > highestExperiencedSpeed )
    highestExperiencedSpeed = newSpeed;
  signed long max;
  if ( device->getMaxBitrate (  ) < 0 )
    max = highestExperiencedSpeed;
  else
    max = device->getMaxBitrate (  );
  iface_ui.maxSpeed->setText ( i18n ( "%1 MBit/s", max / 1000000 ) );
  iface_ui.speedIndicator->setMinimum ( 0 );
  iface_ui.speedIndicator->setMaximum ( max );
  iface_ui.speedIndicator->setValue ( newSpeed );
}

void
KWiFi_Iface::updateStatus (  )
{
  switch ( device->getDeviceState (  ) )
    {
    case::AP_CONNECT:
      iface_ui.connLabel->setText ( i18n ( "Connected to network:" ) );
      break;
    case::NO_CONNECTION:
      iface_ui.connLabel->setText ( i18n ( "Searching for network:" ) );
      break;
    case::AD_HOC:
      iface_ui.connLabel->setText ( i18n ( "Ad-hoc connection to:" ) );
      break;
    default:
      iface_ui.connLabel->setText ( i18n ( "SSID:" ) );
    };

  iface_ui.networkName->setText ( device->get_essid (  ) );
  QString mac, ip;
  device->get_AP_info ( mac, ip );
  if ( mac == "44:44:44:44:44:44" || mac == "00:00:00:00:00:00" )
    mac = i18n ( "- no access point -" );
  iface_ui.accessPoint->setText ( mac + '\n' + whois ( ( const char * ) mac.toLatin1 (  ), KWiFiManagerApp::APs ) );
  QString IPs = device->get_IP_info (  ).join ( "\n" );
  iface_ui.ipList->setText ( IPs );
  long freq;
  bool has_freq = device->get_device_freq ( freq );
  if ( !has_freq )
    iface_ui.frequency->setText ( i18n ( "no information" ) );
  else
    {
      if ( freq <= 1000 )	// then the card reported its channels
	iface_ui.frequency->setText ( QString ( "%1 [%2]" ).arg ( device->toggleFreqChannel ( freq ) ).arg ( freq ) );
      else
	iface_ui.frequency->setText ( QString ( "%1 [%2]" ).arg ( freq ).arg ( device->toggleFreqChannel ( freq ) ) );
    }

  QString key;
  int size = 0, flags = 0;
  if ( device->get_key ( key, size, flags ) )
    if ( size == 0 )
      iface_ui.encryption->setText ( i18n ( "off" ) );
    else
      iface_ui.encryption->setText ( i18n ( "active, %1 Bit", size * 8 ) );
}

void
KWiFi_Iface::updateCardState ( CARDSTATES state )
{
  switch ( state )
    {
    case::NO_CARD:
      iface_ui.connTypePic->setPixmap ( *KWiFiManagerApp::NO_CARD );
      break;
    case::NO_CONNECTION:
      iface_ui.connTypePic->setPixmap ( *KWiFiManagerApp::ALL_ALONE );
      break;
    case::AP_CONNECT:
      iface_ui.connTypePic->setPixmap ( *KWiFiManagerApp::AP_CONNECT );
      break;
    case::AD_HOC:
      iface_ui.connTypePic->setPixmap ( *KWiFiManagerApp::AD_HOC );
      break;
    }
}

void
KWiFi_Iface::updateStrengthBar ( int newQual, int newSig, int newNoise )
{
  int newStrength = KWiFiSettings::self (  )->alternateStrength (  ) ? newSig - newNoise : newQual;
  int qualityClass = newStrength / 5 + 2;
  if ( qualityClass > 5 )
    qualityClass = 5;
  if ( qualityClass < 0 )
    qualityClass = 0;
  switch ( device->getDeviceState (  ) )
    {
    case::AP_CONNECT:
      iface_ui.strengthPic->setPixmap ( *( KWiFiManagerApp::STRENGTHPIC[qualityClass] ) );
      iface_ui.strengthNumber->setText ( QString ( "%1" ).arg ( newStrength ) );
      iface_ui.category->setText ( KWiFiManagerApp::strengthClassName[qualityClass] );
      break;
    case::NO_CONNECTION:
      iface_ui.strengthPic->setPixmap ( *( KWiFiManagerApp::STRENGTHPIC[1] ) );
      iface_ui.strengthNumber->setText ( "0" );
      iface_ui.category->setText ( KWiFiManagerApp::strengthClassName[1] );
      break;
    default:
      iface_ui.strengthPic->setPixmap ( *( KWiFiManagerApp::STRENGTHPIC[0] ) );
      iface_ui.strengthNumber->setText ( i18n ( "N/A" ) );
      iface_ui.category->setText ( KWiFiManagerApp::strengthClassName[2] );
    };
}

void
KWiFi_Iface::slotNetworkScan (  )
{
  iface_ui.networkScan->setText ( i18n ( "Scan in progress..." ) );
  iface_ui.networkScan->setEnabled ( false );
  scanwidget = new NetworkScanning ( device );
  iface_ui.networkScan->setText ( i18n ( "Scan for &Networks..." ) );
  iface_ui.networkScan->setEnabled ( true );
}

void
KWiFi_Iface::toggleStats (  )
{
  if ( statsContainer->isVisible (  ) )
    {
      statsContainer->hide (  );
      zentrallayout->removeWidget ( statsContainer );
      statsContainer->setParent ( 0 );
    }
  else
    {
      statsContainer->setParent ( this );
      zentrallayout->addWidget ( statsContainer, 1, 0 );
      statsContainer->show (  );
    }
  resize ( minimumSizeHint (  ) );
}

void
KWiFi_Iface::slotDisableRadio (  )
{
  iface_ui.disableRadio->setChecked ( device->get_txpower_disabled (  ) );

  if ( disablePower != 0 && disablePower->isRunning (  ) )
    {
      return;
    }
  QString interface = device->get_interface_name (  );

  if ( interface.isEmpty (  ) )
    {
      return;
    }

  QString onOrOff;
  if ( iface_ui.disableRadio->isChecked (  ) )
    {
      onOrOff = "on";
    }
  else
    {
      onOrOff = "off";
    }

  disablePower = new KProcess;

  *disablePower << "kdesu" << "iwconfig" << interface << "txpower" << onOrOff;
  connect ( disablePower, SIGNAL ( processExited ( KProcess * ) ), this, SLOT ( slotDisablePowerProcessExited (  ) ) );
  disablePower->start ( KProcess::NotifyOnExit );
}

void
KWiFi_Iface::slotDisablePowerProcessExited (  )
{
  if ( !disablePower->normalExit (  ) || disablePower->exitStatus (  ) != 0 )
    {
      delete disablePower;
      disablePower = 0;
      return;
    }

  if ( iface_ui.disableRadio->isChecked (  ) )
    {
      iface_ui.disableRadio->setChecked ( false );
    }
  else
    {
      iface_ui.disableRadio->setChecked ( true );
    }

  delete disablePower;
  disablePower = 0;

  iface_ui.disableRadio->setChecked ( device->get_txpower_disabled (  ) );
}

void
KWiFi_Iface::slotToggleTric (  )
{
  if ( iface_ui.tricorder->isChecked (  ) )
    {
      tricorderTrigger->start ( 250 );
    }
  else
    {
      tricorderTrigger->stop (  );
    }
}

void
KWiFi_Iface::tricorderBeep (  )
{
	  int sig, noi, qual;
	    device->get_current_quality ( sig, noi, qual );
#ifndef WITHOUT_ARTS
	      sine_wave ( 150.0 + qual * 20 );
#endif
	        if ( qual == 0 )
			    {
				          tricorderTrigger->start ( 2000 );
					      }
		  else if ( qual < 10 )
			      {
				            tricorderTrigger->start ( 1000 );
					        }
		    else
			        {
					      tricorderTrigger->start ( 500 );
					          }
}

#include "kwifi_ifaceimpl.moc"
