/*
  $ Author: Mirko Boehm $
  $ License: This code is licensed under the LGPL $
  $ Copyright: (C) 1996-2003, Mirko Boehm $
  $ Contact: Mirko Boehm <mirko@kde.org>
         http://www.kde.org
         http://www.hackerbuero.org $
*/

#ifndef KWIRELESS_PROPERTYTABLE_H
#define KWIRELESS_PROPERTYTABLE_H

#include <kdialog.h>
#include <q3ptrlist.h>
#include "ui_propertytablebase.h"

class DeviceInfo;
class QTimer;

class PropertyTableBase : public QWidget, public Ui::PropertyTableBase
{
public:
  PropertyTableBase( QWidget *parent ) : QWidget( parent ) {
    setupUi( this );
  }
};


class PropertyTable : public PropertyTableBase
{
    Q_OBJECT
public:
    PropertyTable(QWidget *parent = 0);
    ~PropertyTable();
};


class PropertiesDialog : public KDialog
{
    Q_OBJECT
public:
    PropertiesDialog(QWidget *parent = 0, const char *name = 0);
protected:
    PropertyTable *table;
    Q3PtrList<DeviceInfo> *info;
    bool wait;
    QTimer *timer;
public slots:
    void update(Q3PtrList<DeviceInfo> *);
    void timeout();
    void selected(int);
};

#endif // KWIRELESS_PROPERTYTABLE_H
