/***************************************************************************
                          statistics.cpp  -  description
                             -------------------
    begin                : Mon Aug 19 2002
    copyright            : (C) 2002 by Stefan Winter
    email                : mail@stefan-winter.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <QWidget>
#include <QPainter>
#include <QPolygon>
#include <QPaintEvent>
#include <klocale.h>
#include "statistics.h"
#include "interface_wireless.h"
#include "kwifi_settings.h"

Statistics::Statistics ( Interface_wireless * device, QWidget * parent ):QWidget ( parent )
{
  this->device = device;
}

int
Statistics::determineTop (  )
{
  return ( device->sigLevelMax > device->noiseLevelMax ) ? device->sigLevelMax : device->noiseLevelMax;
}

int
Statistics::determineBottom (  )
{
  return ( device->sigLevelMin > device->noiseLevelMin ) ? device->noiseLevelMin : device->sigLevelMin;
}

void
Statistics::paintEvent ( QPaintEvent * )
{
  statpainter = new QPainter ( this );
  QColor farbe ( 255, 255, 255 );
  statpainter->fillRect ( 0, 0, 480, 201, farbe );
  QPolygon signal ( 240 );
  QPolygon noise ( 240 );

  int datarange = determineTop (  ) - determineBottom (  );

  // if values are all below 0, this indicates proper dBm values

  double scaleRatio;
  if ( datarange != 0 )
    scaleRatio = 200. / datarange;
  else
    scaleRatio = 1.;

  int i = 0;
  bool atLeastOneValid = false;
  for ( int j = device->current; j < device->current + MAX_HISTORY; j++ )
    {
      if ( device->valid[j % MAX_HISTORY] )
	{
	  atLeastOneValid = true;
	  signal.setPoint ( i, ( i * 2 ),
			    200 -
			    ( int ) ( ( ( device->sigLevel[j % MAX_HISTORY] +
					  device->sigLevel[( j - 1 ) % MAX_HISTORY] ) / 2 -
					determineBottom (  ) ) * scaleRatio ) );
	  noise.setPoint ( i, ( i * 2 ),
			   200 -
			   ( int ) ( ( ( device->noiseLevel[j % MAX_HISTORY] +
					 device->noiseLevel[( j - 1 ) % MAX_HISTORY] ) / 2 -
				       determineBottom (  ) ) * scaleRatio ) );
	}
      else
	{
	  signal.setPoint ( i, ( i * 2 ), 200 );
	  noise.setPoint ( i, ( i * 2 ), 200 );
	}
      i++;
    };
  // the above point array is only useful if at least one entry has its
  // valid flag set. This fact is determined in the iteration before.
  // Only paint the point array if there is one valid entry
  if ( atLeastOneValid )
    {
      if ( KWiFiSettings::self()->showNoiseInStats() )
	{
	  statpainter->setPen ( Qt::red );
	  statpainter->drawPolyline ( noise );
	}
      statpainter->setPen ( Qt::blue );
      statpainter->drawPolyline ( signal );
    }
  delete statpainter;
}
