# - Try to find the SVN library
# Once done this will define
#
#  SVN_FOUND - system has the svn library
#  SVN_CFLAGS - the svn cflags
#  SVN_LIBRARIES - The libraries needed to use svn

# Copyright (c) 2006, Laurent Montel, <montel@kde.org>
#
# Redistribution and use is allowed according to the terms of the BSD license.
# For details see the accompanying COPYING-CMAKE-SCRIPTS file.


FIND_PROGRAM(SVNCONFIG_EXECUTABLE NAMES svn-config PATHS
   /usr/bin
   /usr/local/bin
   /usr/local/apr/bin
)

IF(SVNCONFIG_EXECUTABLE)

  EXEC_PROGRAM(${SVNCONFIG_EXECUTABLE} ARGS --libs   RETURN_VALUE _return_VALUE OUTPUT_VARIABLE _LIBRARIES)

  set(SVN_LIBRARIES svn_client-1 svn_subr-1 svn_ra-1)
  if (${_LIBRARIES} MATCHES "-lapr-1")
	LIST(APPEND SVN_LIBRARIES apr-1)
  endif(${_LIBRARIES} MATCHES "-lapr-1")

  if (${_LIBRARIES} MATCHES "-lapr-0")
        LIST(APPEND SVN_LIBRARIES apr-0)
  endif(${_LIBRARIES} MATCHES "-lapr-0")

  EXEC_PROGRAM(${SVNCONFIG_EXECUTABLE} ARGS --cppflags RETURN_VALUE _return_VALUE OUTPUT_VARIABLE SVN_CFLAGS)

  EXEC_PROGRAM(${SVNCONFIG_EXECUTABLE} ARGS --includes RETURN_VALUE _return_VALUE OUTPUT_VARIABLE SVN_INCLUDES)

  IF(SVN_LIBRARIES AND SVN_CFLAGS)
    SET(SVN_FOUND TRUE)
    message(STATUS "Found svn lib: ${SVN_LIBRARIES}")
  ENDIF(SVN_LIBRARIES AND SVN_CFLAGS)

  MARK_AS_ADVANCED(SVN_CFLAGS SVN_LIBRARIES)
  #MESSAGE(STATUS "svn config : SVN_LIBRARIES= <${SVN_LIBRARIES}>
  #SVN_CFLAGS= ${SVN_CFLAGS} : SVN_INCLUDES= <${SVN_INCLUDES}>")
else(SVNCONFIG_EXECUTABLE)
#Into subversion-1.4 svn-config was removed
   SET(SUBVERSION14 TRUE)

   FIND_PATH(SVN_INCLUDES subversion-1/svn_version.h
   /usr/include
   /usr/local/include
   )
   FIND_PATH(_INCLUDES apr_pools.h
   /usr/include/apr-1/
   /usr/include
   /usr/local/include
   )
   if(_INCLUDES)
       set(SVN_INCLUDES ${SVN_INCLUDES} ${_INCLUDES})
   endif(_INCLUDES)
   FIND_LIBRARY(SVN_LIBRARIES NAMES svn_client-1
       PATHS
       /usr/lib
       /usr/local/lib
   ) 
   if(SVN_LIBRARIES)
       FIND_LIBRARY(_LIBRARIES NAMES svn_subr-1
       PATHS
       /usr/lib
       /usr/local/lib
       )
       if(_LIBRARIES)
          set(SVN_LIBRARIES ${SVN_LIBRARIES} ${_LIBRARIES})
       endif(_LIBRARIES)

       FIND_LIBRARY(_LIBRARIERA NAMES svn_ra-1
       PATHS
       /usr/lib
       /usr/local/lib
       )
       if(_LIBRARIERA)
          set(SVN_LIBRARIES ${SVN_LIBRARIES} ${_LIBRARIERA})
       endif(_LIBRARIERA)

       FIND_LIBRARY(_LIBRARIEAPR1 NAMES apr-1
       PATHS
       /usr/lib
       /usr/local/lib
       )
       if(_LIBRARIEAPR1)
          set(SVN_LIBRARIES ${SVN_LIBRARIES} ${_LIBRARIEAPR1})
       endif(_LIBRARIEAPR1)

       FIND_LIBRARY(_LIBRARIEAPR0 NAMES apr-0
       PATHS
       /usr/lib
       /usr/local/lib
       )
       if(_LIBRARIEAPR0)
          set(SVN_LIBRARIES ${SVN_LIBRARIES} ${_LIBRARIEAPR0})
       endif(_LIBRARIEAPR0)

       SET(SVN_FOUND TRUE)
       message(STATUS "Found svn lib: ${SVN_LIBRARIES}")
       MARK_AS_ADVANCED(SVN_LIBRARIES)
       #MESSAGE(STATUS "svn config : SVN_LIBRARIES= <${SVN_LIBRARIES}> SVN_INCLUDES= <${SVN_INCLUDES}>")

   else(SVN_LIBRARIES)
       message( STATUS "svn lib not found")
   endif(SVN_LIBRARIES)
ENDIF(SVNCONFIG_EXECUTABLE)

