#!/bin/sh

# install krazy

#TODO: command line arg (or compute the value) for QT4_TOP

#change TOP to whatever you like for your top-level installation directory
if ( test `hostname | egrep -c englishbreakfast` -gt 0 ) then
  EBN=1
  TOP=/usr/local/www/data-ebn/krazy
  QT4_TOP=/usr/local/src/qt-copy
else
  EBN=0
  TOP=/usr/local/Krazy
  QT4_TOP=/data/kde/trunk/qt-copy
fi

#or pass TOP in as the first command line option
if ( test $# -gt 0 ) then
  TOP=$1
fi

if ( test ! -d "$TOP" ) then
  echo "Installation dir \"$TOP\" does not exist. Creating..."
  mkdir -p $TOP || exit 1
fi

#install user-interface scripts
perl Makefile.PL PREFIX=$TOP && \
make && \
make install && \
make realclean

#build and install non-binary plugins
cd plugins && \
make install PREFIX=$TOP && \
make realclean
cd ..

#build and install binary plugins
cd src && \
$QT4_TOP/bin/qmake && \
make && \
make install INSTALL_ROOT=$TOP && \
make distclean
cd ..

#permissions
if ( test $EBN -eq 1 ) then
  chmod ug+w $TOP/bin/*
  chmod ug+w $TOP/libexec/krazy-plugins/*
fi
