/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 2004  by Stanislav Visnovsky
			    <visnovsky@kde.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

  In addition, as a special exception, the copyright holders give
  permission to link the code of this program with any edition of
  the Qt library by Trolltech AS, Norway (or with modified versions
  of Qt that use the same license as Qt), and distribute linked
  combinations including the two.  You must obey the GNU General
  Public License in all respects for all of the code used other than
  Qt. If you modify this file, you may extend this exception to
  your version of the file, but you are not obligated to do so.  If
  you do not wish to do so, delete this exception statement from
  your version.

**************************************************************************** */

#include "charselectview.h"

#include <qlayout.h>
#include <qlabel.h>
#include <qspinbox.h>
#include <q3scrollview.h>

#include <QVBoxLayout>

#include <kconfig.h>
#include <kcursor.h>
#include <kdialog.h>
#include <klocale.h>
#include <kcharselect.h>
#include <kvbox.h>
#include <kconfiggroup.h>

#include "kbcatalog.h"

using namespace KBabel;

CharacterSelectorView::CharacterSelectorView(KBCatalog* catalog,QWidget *parent, Project::Ptr project)
    : KBCatalogView(catalog,parent,project)
{
    QVBoxLayout* layout = new QVBoxLayout( this );
    layout->setSizeConstraint( QLayout::SetMinimumSize );

    layout->setSpacing( KDialog::spacingHint() );
    
    KHBox* bar = new KHBox(this);
    bar->setSpacing( KDialog::spacingHint() );
    layout->addWidget (bar);
    
    QLabel *lTable = new QLabel( i18n( "Table:" ), bar );
    _tableNum = new QSpinBox( bar );
    _tableNum->setRange( 0, 255 );
    _tableNum->setSingleStep( 1 );
    lTable->setBuddy( _tableNum );
    bar->setStretchFactor( _tableNum, 1 );
    
    Q3ScrollView* scroll = new Q3ScrollView( this );    
    // ### TODO: we should use the default font of KDE, not "helvetica"
    _table = new KCharSelectTable(scroll,"helvetica",' ',0);
#ifdef __GNUC__
# warning "How to set the KCharSelectTable to 16x16 format"
#elif 0
    _table->setNumCols(16);
    _table->setNumRows(16);
#endif
    
    scroll->addChild(_table);
    layout->addWidget (scroll);
    
    connect( _table, SIGNAL( doubleClicked() ), this, SLOT( emitChar() ) );
    connect( _tableNum, SIGNAL( valueChanged(int) ), this, SLOT( setTab(int) ));
    
    connect( _catalog, SIGNAL( signalFileOpened(bool) ), this, SLOT (setDisabled (bool)));
    connect( _catalog, SIGNAL( signalFileOpened(bool) ), _table, SLOT (setDisabled (bool)));

    setWhatsThis(
       i18n("<qt><p><b>Character Selector</b></p>"
         "<p>This tool allows to insert special characters using "
         "double click.</p></qt>"));
}

void CharacterSelectorView::emitChar()
{
    emit characterDoubleClicked( _table->chr() );
}

void CharacterSelectorView::setTab(int value)
{
    _table->setTableNum( value );
}

void CharacterSelectorView::saveSettings(KConfig* config)
{
    KConfigGroup group(config, "KBCharSelector" );
	
    group.writeEntry( "TableNum", _tableNum->value() );
    group.writeEntry( "SelectedChar", QString(_table->chr()) );
}

void CharacterSelectorView::restoreSettings(KConfig* config)
{
    KConfigGroup group(config, "KBCharSelector" );
    
    _tableNum->setValue( group.readEntry("TableNum", 0 ));
    _table->setChar( group.readEntry("SelectedChar"," ").at(0));
}

#include "charselectview.moc"
