/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 1999-2001 by Matthias Kiefer <matthias.kiefer@gmx.de>
		2002-2005 by Stanislav Visnovsky <visnovsky@kde.org>
  Copyright (C) 2006 by Nicolas GOUTTE <goutte@kde.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

  In addition, as a special exception, the copyright holders give
  permission to link the code of this program with any edition of
  the Qt library by Trolltech AS, Norway (or with modified versions
  of Qt that use the same license as Qt), and distribute linked
  combinations including the two.  You must obey the GNU General
  Public License in all respects for all of the code used other than
  Qt. If you modify this file, you may extend this exception to
  your version of the file, but you are not obligated to do so.  If
  you do not wish to do so, delete this exception statement from
  your version.

**************************************************************************** */
#include "kbabel.h"
#include "kbabelinterface.h"
#include "kbabeladaptor.h"
#include "catalog.h"
#include "kbabelsplash.h"
#include "findoptions.h"
#include "kbprojectmanager.h"

#include "version.h"

#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <kcursor.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kuniqueapplication.h>

#include <kwin.h>
#include <QtDBus/QtDBus>

#include <qfile.h>
#include <qfileinfo.h>
#include <qtimer.h>


class KBabelApp : public KUniqueApplication
{
public:
    KBabelApp();
    virtual ~KBabelApp();

    virtual int newInstance();

private:
    KBabelInterface *kbInterface;
};

KBabelApp::KBabelApp()
    : KUniqueApplication()
{
    kbInterface = new KBabelInterface;
    new KbabelAdaptor(kbInterface);
    QDBusConnection::sessionBus().registerObject(QLatin1String("/KBabel"), kbInterface);
}

KBabelApp::~KBabelApp()
{
    delete kbInterface;
}

int KBabelApp::newInstance()
{
    const bool first = KBabelMW::memberList().isEmpty();

    // see if we are starting with session management
    if (!restoringSession())
    {
        // TODO: There's no replacement for suspend in QtDBus
	// kDebug () << "Suspending DCOP" << endl;
	// kapp->dcopClient()->suspend();

        KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

        QTimer timer;
        QWidget *splash=0;
        bool showSplash=args->isSet("splash");

        if( showSplash && first )
        {
            setOverrideCursor(KCursor::waitCursor());
            splash = new KBabelSplash();
	    splash->show();
            timer.setSingleShot( true );
            timer.start( 4000 );
        }

        QString projectFile=args->getOption("project");
	if( !projectFile.isEmpty() )
	{
	    QFileInfo fi(projectFile);
	    projectFile = fi.absoluteFilePath();
	} else
	{
	    projectFile = KBabel::ProjectManager::defaultProjectName();
	}

	kDebug() << "Project: " << projectFile << endl;
	QByteArray msgid=args->getOption("gotomsgid");
        if(!msgid.isEmpty() && args->count() > 0)
        {
            kDebug(KBABEL) << "gotomsgid" << endl;
            QString m = QString::fromLocal8Bit(msgid);

            // TODO: There's no replacement for suspend or resume in QtDBus
	    // kDebug () << "Resuming DCOP" << endl;
	    // kapp->dcopClient()->resume();
            kbInterface->gotoFileEntry( args->url(0).url().toLocal8Bit(), m.toUtf8() );
        }
        else
        {
            // no session.. just start up normally
    	    KBabelMW *widget=0;
            if(args->count() > 0)
            {
                KUrl u = args->url(0);
                widget=KBabelMW::winForURL(u,projectFile);
            }

            if(!widget)
                widget=KBabelMW::emptyWin(projectFile);

            if(!widget)
                widget=new KBabelMW(projectFile);

            while(timer.isActive()) // let the user admire the splash screen ;-)
                processEvents();

            widget->show();
            for (int i=0; i < args->count(); i++)
            {
               widget->open( args->url(i) , QString::null, i != 0 );
            }

            // TODO: There's no replacement for suspend or resume in QtDBus
	    // kDebug () << "Resuming DCOP" << endl;
	    // kapp->dcopClient()->resume();
        }


        args->clear();

        if(splash)
        {
	    delete KBabelSplash::instance;
        }
        if(showSplash)
        {
            KApplication::restoreOverrideCursor();
            /*
            KMessageBox::information(0,
                    "This is a development version of KBabel!\n"
                    "Please double check the files you edit "
                    "and save with this version for correctness.\n"
                    "Please report any bug you find to kiefer@kde.org.\n"
                    "Thanks.", "Warning");
            */
        }
    }

    return 0;
}

static KCmdLineOptions options[] =
{
   {"gotomsgid <msgid>",I18N_NOOP("Go to entry with msgid <msgid>"),0},
   {"nosplash",I18N_NOOP("Disable splashscreen at startup"),0},
   {"project <configfile>",I18N_NOOP("File to load configuration from"),0},
   {"+[file]",I18N_NOOP("Files to open"),0},
   KCmdLineLastOption
};


int main(int argc, char **argv)
{
    KAboutData about("kbabel",I18N_NOOP("KBabel"),KBABEL_VERSION,
       I18N_NOOP("An advanced PO file editor"),KAboutData::License_GPL,
       I18N_NOOP("(c) 1999,2000,2001,2002,2003,2004,2005,2006 The KBabel developers"),0,"http://kbabel.kde.org");

    about.addAuthor("Matthias Kiefer",I18N_NOOP("Original author"),"kiefer@kde.org");
    about.addAuthor("Wolfram Diestel"
         ,I18N_NOOP("Wrote diff algorithm, fixed K3Spell and gave a lot "
         "of useful hints."),"wolfram@steloj.de");
    about.addAuthor("Andrea Rizzi",I18N_NOOP("Wrote the dictionary plugin "
		"for searching in a database and some other code.")
            ,"rizzi@kde.org");
    about.addAuthor("Stanislav Visnovsky",I18N_NOOP("Current maintainer, porting to KDE3/Qt3.")
	,"visnovsky@kde.org");
    about.addAuthor("Marco Wegner",I18N_NOOP("Bug fixes, KFilePlugin for PO files, CVS support, mailing files")
         ,"dubbleu@web.de");
    about.addAuthor("Asgeir Frimannsson",I18N_NOOP("Translation List View")
         ,"asgeirf@redhat.com");
    about.addAuthor("Nicolas Goutte", I18N_NOOP("Filter improvements"), "goutte@kde.org");

    about.addCredit("Claudiu Costin",I18N_NOOP("Wrote documentation and sent "
		"many bug reports and suggestions for improvements.")
         ,"claudiuc@geocities.com");
    about.addCredit("Thomas Diehl",I18N_NOOP("Gave many suggestions for the GUI "
         "and the behavior of KBabel. He also contributed the beautiful splash screen.")
            ,"thd@kde.org");
    about.addCredit("Stephan Kulow",I18N_NOOP("Helped keep KBabel up to date "
		"with the KDE API and gave a lot of other help."),"coolo@kde.org");
    about.addCredit("Stefan Asserhall",I18N_NOOP("Implemented XML validation/highlighting "
	 "plus other small fixes.") ,"stefan.asserhall@telia.com");
    about.addCredit("Dwayne Bailey",I18N_NOOP("Various validation plugins.")
	 ,"dwayne@translate.org.za");
	about.addCredit("SuSE GmbH"
					,I18N_NOOP("Sponsored development of KBabel for a while.")
					,"suse@suse.de","http://www.suse.de");
    about.addCredit("Trolltech", I18N_NOOP("KBabel contains code from Qt"), 0, "http://www.trolltech.com");

    about.addCredit("Eva Brucherseifer", I18N_NOOP("String distance algorithm implementation"), "eva@kde.org");

    about.addCredit("Albert Cervera Areny", I18N_NOOP("Error list for current entry, regexp data tool"), "albertca@hotpop.com");

    about.addCredit("Nick Shaforostoff", I18N_NOOP("Word-by-word string difference algorithm implementation"), "shafff@ukr.net");

    // Initialize command line args
    KCmdLineArgs::init(argc, argv, &about);

    // Tell which options are supported
    KCmdLineArgs::addCmdLineOptions( options );

    // Add options from other components
    KUniqueApplication::addCmdLineOptions();


    if(!KUniqueApplication::start())
    {
        return 0;
    }

    KBabelApp app;

    if( app.isSessionRestored() )
    {
	RESTORE(KBabelMW)
    }

    return app.exec();
}
