// $Id: msginputdialog.cpp 695936 2007-08-03 11:07:32Z mlaurent $
// (c) 2001, Cornelius Schumacher

#include <ktextedit.h>
#include <qlayout.h>
#include <QHBoxLayout>
#include <QVBoxLayout>
#include <kstandardguiitem.h>
#include <klocale.h>
#include <kdebug.h>
#include <qcombobox.h>
#include <qsplitter.h>
#include <qlabel.h>
#include <k3listbox.h>

#include "messageeditor.h"
#include "kbbprefs.h"
#include "bugsystem.h"
#include "bugcommand.h"

#include "msginputdialog.h"
#include "msginputdialog.moc"

MsgInputDialog::MsgInputDialog(MsgInputDialog::MessageType type, const Bug &bug,
                               const Package &package, const QString &quotedMsg,
                               QWidget *parent)
  : KDialog(parent),
    mBug( bug ),
    mPackage( package ),
    mType( type )
{
    setButtons( User1|User2|Ok|Cancel );
    setDefaultButton( Ok );
    setModal( true );
    setButtonGuiItem( User2, KStandardGuiItem::clear() );
    setButtonGuiItem( User1, KGuiItem(i18n( "&Edit Presets..." )) );
  switch ( mType ) {
    case Close:
      setCaption( i18n("Close Bug %1", mBug.number() ) );
      break;
    case Reply:
      setCaption( i18n("Reply to Bug") );
      break;
    case ReplyPrivate:
      setCaption( i18n("Reply Privately to Bug") );
      break;
    default:
      break;
  }

  QFrame *topFrame = new QFrame(this);
  setMainWidget( topFrame );
  ( new QHBoxLayout( topFrame ) )->setAutoAdd( true );

  mSplitter = new QSplitter( Qt::Horizontal, topFrame );

  QWidget *w = new QWidget( mSplitter );
  QVBoxLayout *vb = new QVBoxLayout( w );
  vb->setSpacing( spacingHint() );
  vb->setAutoAdd( true );

  if ( mType == Reply ) {
    QWidget *r = new QWidget( w );
    QHBoxLayout* rlayout = new QHBoxLayout( r );

    QLabel *rlabel = new QLabel( i18n("&Recipient:"), r );
    QFont f = r->font();
    f.setBold( true );
    r->setFont( f );
    rlayout->add( rlabel );

    mRecipient = new QComboBox( r );
    mRecipient->insertItem( BugCommand::Normal, i18n("Normal (bugs.kde.org & Maintainer & kde-bugs-dist)") );
    mRecipient->insertItem( BugCommand::Maintonly, i18n("Maintonly (bugs.kde.org & Maintainer)") );
    mRecipient->insertItem( BugCommand::Quiet, i18n("Quiet (bugs.kde.org only)") );
    rlabel->setBuddy( mRecipient );
    rlayout->add( mRecipient );

    QSpacerItem *rspacer= new QSpacerItem( 1,1,QSizePolicy::Expanding );
    rlayout->addItem( rspacer );

    // Reply currently only replies to the bug tracking system
    r->hide();
  }


  QLabel *l = new QLabel( i18n( "&Message" ), w );
  QFont f = l->font();
  f.setBold( true );
  l->setFont( f );

  mMessageEdit = new KTextEdit( w );
  mMessageEdit->setMinimumWidth( mMessageEdit->fontMetrics().width('x') * 72 );
  //mMessageEdit->setWordWrap( Q3TextEdit::FixedColumnWidth );
  //mMessageEdit->setWrapColumnOrWidth( 72 );
  l->setBuddy( mMessageEdit );

  w = new QWidget( mSplitter );
  vb = new QVBoxLayout( w );
  vb->setSpacing( spacingHint() );
  vb->setAutoAdd( true );
  l = new QLabel( i18n( "&Preset Messages" ), w );
  l->setFont( f );

  mPresets = new K3ListBox( w );
  updatePresets();
  l->setBuddy( mPresets );

  connect( mPresets, SIGNAL( executed( Q3ListBoxItem* ) ),
           SLOT( slotPresetSelected( Q3ListBoxItem * ) ) );
  connect( this, SIGNAL( user1Clicked() ), SLOT( editPresets() ) );
  connect( this, SIGNAL( user2Clicked() ), SLOT( clearMessage() ) );
  connect(this,SIGNAL(okClicked()),SLOT(slotOk()));
  connect(this,SIGNAL(cancelClicked()),SLOT(slotCancel()));
  mMessageEdit->setFocus();

  if ( !quotedMsg.isEmpty() )
    insertQuotedMessage( quotedMsg );

  readConfig();
}

MsgInputDialog::~MsgInputDialog()
{
  kDebug() << "MsgInputDialog::~MsgInputDialog()";
  writeConfig();
}

void MsgInputDialog::readConfig()
{
  resize( KBBPrefs::instance()->mMsgDlgWidth,
          KBBPrefs::instance()->mMsgDlgHeight );
  QList<int> sizes = KBBPrefs::instance()->mMsgDlgSplitter;
  if (!sizes.isEmpty())
    mSplitter->setSizes( sizes );
}

void MsgInputDialog::writeConfig()
{
  KBBPrefs::instance()->mMsgDlgWidth = width();
  KBBPrefs::instance()->mMsgDlgHeight = height();
  KBBPrefs::instance()->mMsgDlgSplitter = mSplitter->sizes();
}

void MsgInputDialog::updatePresets()
{
  mPresets->clear();

  QMap<QString,QString> messageButtons = KBBPrefs::instance()->mMessageButtons;

  int id = 0;
  QMap<QString,QString>::ConstIterator it;
  for( it = messageButtons.begin(); it != messageButtons.end(); ++it )
    mPresets->insertItem( it.key(), id );
}

QString MsgInputDialog::message() const
{
  return mMessageEdit->text();
}

void MsgInputDialog::editPresets()
{
  MessageEditor *dlg = new MessageEditor(this);
  dlg->exec();
  delete dlg;

  updatePresets();
}

void MsgInputDialog::slotPresetSelected( Q3ListBoxItem *lbi )
{
  mMessageEdit->setText( KBBPrefs::instance()->mMessageButtons[ lbi->text() ] );
}

void MsgInputDialog::clearMessage()
{
  mMessageEdit->setText("");
}

void MsgInputDialog::queueCommand()
{
  switch ( mType ) {
    case Close:
      BugSystem::self()->queueCommand(
          new BugCommandClose( mBug, message(), mPackage ) );
      break;
    case Reply:
      BugSystem::self()->queueCommand( new BugCommandReply( mBug, message(), mRecipient->currentIndex() ) );
      break;
    case ReplyPrivate:
      BugSystem::self()->queueCommand(
          new BugCommandReplyPrivate( mBug, mBug.submitter().email,
	                              message() ) );
      break;
    default:
      break;
  }
}

void MsgInputDialog::slotOk()
{
  queueCommand();
  accept();
}

void MsgInputDialog::slotCancel()
{
    reject();
}



void MsgInputDialog::insertQuotedMessage( const QString &msg )
{
#ifdef __GNUC__
#warning "kde4: comment before to port it";
#endif	
#if 0
	Q_ASSERT( mMessageEdit->wordWrap() == Q3TextEdit::FixedColumnWidth );

	const QString quotationMarker = "> ";
	const int wrapColumn = mMessageEdit->wrapColumnOrWidth();

	// ### Needs something more sophisticated than simplified to
	// handle quoting multiple paragraphs properly.
	QString line = msg.simplified();

	QString quotedMsg;
	while ( line.length() + quotationMarker.length() + 1 > wrapColumn ) {
		int pos = wrapColumn - quotationMarker.length() - 1;
		while ( pos > 0 && !line[ pos ].isSpace() )
			--pos;
		if ( pos == 0 )
			pos = wrapColumn;
		quotedMsg += quotationMarker + line.left( pos ) + '\n';
		line = line.mid( pos + 1 );
	}
	quotedMsg += quotationMarker + line + "\n\n";

	mMessageEdit->setText( quotedMsg );

	const int lastPara = mMessageEdit->paragraphs() - 1;
	const int lastParaLen = mMessageEdit->paragraphLength( lastPara ) - 1;
	mMessageEdit->setCursorPosition( lastPara, lastParaLen );
#endif
}
