/*
 * Copyright (C) 2004 Dirk Ziegelmeier <dziegel@gmx.de>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 */

#include <kdebug.h>
#include <klocale.h>
#include <klibloader.h>
#include <kconfig.h>
#include <kdialogbase.h>

#include <qspinbox.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qtimer.h>
#include <qapplication.h>
#include <qcombobox.h>

#include "kdetvwidget.h"
#include "kdetv.h"
#include "viewmanager.h"
#include "sourcemanager.h"

#include "screensaver.h"
#include "screensaver.moc"

// libkscreensaver interface
extern "C"
{
    const char *kss_applicationName = "kdetvsaver.kss";
    const char *kss_description = I18N_NOOP( "A screensaver that displays a TV screen" );
    const char *kss_version = "0.1";

    KScreenSaver *kss_create( WId id )
    {
        KLibLoader::self()->globalLibrary("libkdetv.so");
        return new KdetvSaver( id );
    }

    QDialog *kss_setup()
    {
        KdetvSaverSetup* s = new KdetvSaverSetup(0L, "SaverSetup");
        return s->_dlg;
    }
}

KdetvSaver::KdetvSaver( WId id )
    : KScreenSaver( id )
{
    _screen = new KdetvWidget((QWidget*)0L);
    embed(_screen);
    _screen->show();

    QTimer::singleShot(0, this, SLOT( applySettings() ));
}

KdetvSaver::~KdetvSaver()
{
    delete _screen;
}

void KdetvSaver::applySettings()
{
    KConfig* cfg = KGlobal::config();

    // The functions called here change the settings file group...

    cfg->setGroup("SaverSettings");
    _screen->driver()->playDevice(cfg->readEntry("Device",
                                                 _screen->driver()->sourceManager()->deviceList().first()));

    cfg->setGroup("SaverSettings");
    _screen->driver()->setChannel(cfg->readNumEntry("Channel", 2));

    cfg->setGroup("SaverSettings");
    _screen->driver()->setVolume(cfg->readNumEntry("Volume", 50));
}

//----------------------------------------------

SaverConfigWidgetImpl::SaverConfigWidgetImpl(QWidget* parent, KConfig* h, Kdetv* ktv)
    : SaverConfigWidget(parent),
      SettingsDialogPage(i18n("Screensaver"),
                         i18n("Configure Screensaver Options"),
                         "kcmkwm"),
      _h(h),
      _ktv(ktv)
{
}

SaverConfigWidgetImpl::~SaverConfigWidgetImpl()
{
}

void SaverConfigWidgetImpl::setup()
{
    _h->setGroup("SaverSettings");
    _channel->setValue(_h->readNumEntry("Channel", 2));
    _volume->setValue(_h->readNumEntry("Volume", 50));

    _videoDev->insertStringList(_ktv->sourceManager()->deviceList());
    _videoDev->setCurrentText(_h->readEntry("Device", _ktv->sourceManager()->deviceList().first()));
}

void SaverConfigWidgetImpl::defaults()
{
    _channel->setValue(2);
    _volume->setValue(20);
}

void SaverConfigWidgetImpl::apply()
{
    _h->setGroup("SaverSettings");
    _h->writeEntry("Channel", _channel->value());
    _h->writeEntry("Volume", _volume->value());
    _h->writeEntry("Device", _videoDev->currentText());
    _h->sync();
}

//----------------------------------------------

KdetvSaverSetup::KdetvSaverSetup( QObject *parent, const char *name )
	: QObject( parent, name )
{
    _screen = new KdetvWidget((QWidget*)0L);

    _screen->driver()->views()->registerPageFactory(static_cast<SettingsDialogPageFactory*>(this));
    _dlg = _screen->driver()->views()->createSettings(0L);

    connect(_dlg, SIGNAL( finished() ),
            _screen, SLOT( deleteLater() ));
    connect(_dlg, SIGNAL( finished() ),
            this, SLOT( deleteLater() ));
}

KdetvSaverSetup::~KdetvSaverSetup()
{
}

QPtrList<SettingsDialogPage>* KdetvSaverSetup::getPages()
{
    QPtrList<SettingsDialogPage>* p = new QPtrList<SettingsDialogPage>;

    p->append(static_cast<SettingsDialogPage*>(new SaverConfigWidgetImpl(0L, KGlobal::config(), _screen->driver())));
    return p;
}
