// -*- c++ -*-

/*
 *
 * Copyright (C) 2002 Richard Moore <rich@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef CHANNELIOKWINTV2_H
#define CHANNELIOKWINTV2_H

#include "kdetvchannelplugin.h"

/**
 * Implements the channel format from the KDE 2 KWinTV.
 */
class ChannelIOFormatKWinTV2 : public KdetvChannelPlugin
{
public:
    ChannelIOFormatKWinTV2(Kdetv *ktv, QObject *parent = 0, const char* name = 0);

    bool readKConfigFormat(ChannelStore *store, QIODevice *file);
    virtual bool load( ChannelStore *store, ChannelFileMetaInfo *info,
                       QIODevice *file, const QString& fmt );
    virtual bool save( ChannelStore *store, ChannelFileMetaInfo *info,
                       QIODevice *file, const QString& fmt );

    bool readHeader();
    Channel *readChannel();
    QString readField( const QString &line, const QString &field );

private:
    ChannelStore *store;
    Channel *chan;
    QTextStream *ts;
};

#endif // CHANNELIOKWINTV2_H



