/***************************************************************************
                           greedy2frame.cpp
                           ----------------
    begin                : Fri Jun 18 2004
    copyright            : (C) 2004 by Dirk Ziegelmeier
    email                : dziegel@gmx.de
***************************************************************************/

/*
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 */

#include <qspinbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qpushbutton.h>

#include <kdebug.h>
#include <klocale.h>
#include <kconfig.h>

#include "greedy2frame.h"
#include "dscalerfiltergreedy2frame.h"

Greedy2FramePlugin::Greedy2FramePlugin(Kdetv *ktv, const QString& cfgkey, QObject *parent, const char* name)
    : KdetvFilterPlugin(ktv, cfgkey, parent, name)
{
    DScalerFilterGreedy2Frame* f = new DScalerFilterGreedy2Frame();
    _filter = f;

    f->_chromaThreshold = _cfg->readNumEntry("ChromaThreshold", CHROMATHRESHOLD_DEFAULT);
    f->_lumaThreshold   = _cfg->readNumEntry("LumaThreshold",   LUMATHRESHOLD_DEFAULT);
}

Greedy2FramePlugin::~Greedy2FramePlugin()
{
    delete _filter;
}

QWidget* Greedy2FramePlugin::configWidget(QWidget* parent, const char* name)
{
    DScalerFilterGreedy2Frame* f = static_cast<DScalerFilterGreedy2Frame*>(_filter);

    QFrame *w = new QFrame(parent, name);
    w->setMargin(4);
    QGridLayout *g = new QGridLayout(w, 3, 2);

    g->addWidget(new QLabel(i18n("Chroma threshold:"), w), 0, 0);
    _spChroma = new QSpinBox(1, 100, 1, w, "ChromaSpin");
    _spChroma->setValue(f->_chromaThreshold);
    g->addWidget(_spChroma, 0, 1);

    g->addWidget(new QLabel(i18n("Luma threshold:"), w), 1, 0);
    _spLuma = new QSpinBox(1, 100, 1, w, "LumaSpin");
    _spLuma->setValue(f->_lumaThreshold);
    g->addWidget(_spLuma, 1, 1);

    QButton* b = new QPushButton(i18n("Defaults"), w, "Defaults");
    connect(b, SIGNAL( clicked() ),
            this, SLOT( defaults() ));
    g->addWidget(b, 2, 1);

    return w;
}

void Greedy2FramePlugin::defaults()
{
    DScalerFilterGreedy2Frame* f = static_cast<DScalerFilterGreedy2Frame*>(_filter);

    f->_chromaThreshold = CHROMATHRESHOLD_DEFAULT;
    f->_lumaThreshold   = LUMATHRESHOLD_DEFAULT;

    _spChroma->setValue(f->_chromaThreshold);
    _spLuma->setValue(f->_lumaThreshold);
}

void Greedy2FramePlugin::saveConfig()
{
    DScalerFilterGreedy2Frame* f = static_cast<DScalerFilterGreedy2Frame*>(_filter);

    f->_chromaThreshold = _spChroma->value();
    f->_lumaThreshold   = _spLuma->value();

    _cfg->writeEntry("ChromaThreshold", f->_chromaThreshold);
    _cfg->writeEntry("LumaThreshold",   f->_lumaThreshold);
    _cfg->sync();
}

extern "C" {
    Greedy2FramePlugin* create_greedy2frame(Kdetv* ktv)
    {
        return new Greedy2FramePlugin(ktv, "deinterlace-greedy2frame", 0, "Greedy2Frame deinterlacefilter");
    }
}

#include "greedy2frame.moc"
