/*****************************************************************

   Copyright (c) 2006 Stephan Binner <binner@kde.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.

******************************************************************/

#include <qlayout.h>
#include <qtabwidget.h>
#include <dcopclient.h>
#include <kapplication.h>
#include <kdebug.h>
#include <kdialog.h>
#include <klocale.h>
#include <kprocess.h>

#include "kerry.h"
#include "search.h"
#include "indexing.h"
#include "backends.h"
#include "status.h"

KCMKerry::KCMKerry(QWidget *parent, const char *name)
    : KCModule( parent, "kcmkerry" ) 
{
  setButtons(Default+Apply);
 
  QVBoxLayout *layout = new QVBoxLayout(this);
  m_tab = new QTabWidget(this);
  layout->addWidget(m_tab);
  m_search = new KCMKerrySearch( m_tab, name );
  m_search->layout()->setMargin( KDialog::marginHint() );

  m_indexing = new KCMBeagleIndexing( m_tab, name );
  m_indexing->layout()->setMargin( KDialog::marginHint() );

  m_backends = new KCMBeagleBackends( m_tab, name );
  m_backends->layout()->setMargin( KDialog::marginHint() );

  m_status = new KCMBeagleStatus( m_tab, name );
  m_status->layout()->setMargin( KDialog::marginHint() );

  m_tab->addTab(m_search, i18n("&Search"));
  m_tab->addTab(m_indexing, i18n("&Indexing"));
  m_tab->addTab(m_backends, i18n("&Backends"));
  m_tab->addTab(m_status, i18n("&Daemon Status"));

  connect(m_search, SIGNAL(changed(bool)), SIGNAL(changed(bool)));
  connect(m_indexing, SIGNAL(changed(bool)), SIGNAL(changed(bool)));
  connect(m_backends, SIGNAL(changed(bool)), SIGNAL(changed(bool)));
  connect(m_status, SIGNAL(changed(bool)), SIGNAL(changed(bool)));
  connect(m_tab, SIGNAL(currentChanged(QWidget *)), SIGNAL(quickHelpChanged()));
}

void KCMKerry::load()
{
  m_search->load();
  m_indexing->load();
  m_backends->load();
  m_status->load();
}

void KCMKerry::defaults()
{
  m_search->defaults();
  m_indexing->defaults();
  m_backends->defaults();
  m_status->defaults();
}

void KCMKerry::save()
{
  m_search->save();
  m_indexing->save();
  m_backends->save();
  m_status->save();

  DCOPClient *client = kapp->dcopClient();
  client->send("kerry", "default", "configChanged()", "");

  KProcess *proc = new KProcess;
  *proc << "beagle-config";
  *proc << "--beagled-reload-config";
  if (!proc->start())
    kdError("Could not make Beagle reload its config.");
}

QString KCMKerry::quickHelp() const
{
  QWidget *w = m_tab->currentPage();
  if (w->inherits("KCModule"))
  {
     KCModule *m = static_cast<KCModule *>(w);
     return m->quickHelp();
  }
  return QString::null;
}

#include "kerry.moc"
