#ifndef __MISC_H__
#define __MISC_H__

/* We found here
 *  - myDebug : Debug class 
 *  - getAnimationFromFile : read a png with multiple animated images inside
 *  - setWall : put wall
 */

#include <qobject.h>
#include <qstring.h>
#include <qdialog.h>
#include <qvariant.h>


class QVBoxLayout; 
class QHBoxLayout; 
class QGridLayout; 
class QLabel;
class QListBox;
class QListBoxItem;

class QCanvasPixmapArray;
class QCanvas;

class myDebug : public QDialog
{
    Q_OBJECT
public:
    myDebug( QWidget* =0,const char* =0, bool =FALSE, WFlags =0 );
    ~myDebug();
    
    void add(QString text);
    
    QLabel* TextLabel1;
    QListBox* debugListBox;

public slots:
    void dlgDelete();

protected:
    QVBoxLayout* Layout3;
};


bool getAnimationFromFile( QCanvasPixmapArray **images_array ,QString file, 
                           int w, int h, int n_of_animations, 
                           Qt::Orientation orient, int nw, int nh);

bool setWall( QString file, QCanvas *canvas );

bool getKFishAnimation( QCanvasPixmapArray &images_array ,QString file, 
            int nw, int nh);

#endif
