#ifndef PHOTOLISTVIEWTOOLTIP_H
#define PHOTOLISTVIEWTOOLTIP_H

#include <qtooltip.h>
#include <qheader.h>

#include "photolistview.h"

class PhotoListViewToolTip : public QToolTip
{
public:
    PhotoListViewToolTip(PhotoListView* parent);

protected:
    void maybeTip(const QPoint& p);

private:
    PhotoListView* listView;
};

inline PhotoListViewToolTip::PhotoListViewToolTip(PhotoListView* parent)
    : QToolTip(parent->viewport())
    , listView(parent)
{
}

inline void PhotoListViewToolTip::maybeTip(const QPoint& p)
{
    if ( !listView )
        return;

    const PhotoListViewItem* item = dynamic_cast<PhotoListViewItem*>(listView->itemAt(p));
    if ( !item )
        return;

    const QRect itemRect(listView->itemRect(item));
    if ( !itemRect.isValid() )
        return;

    const int col(listView->header()->sectionAt(p.x()));
    if( col == -1 )
        return;

    const QRect headerRect(listView->header()->sectionRect(col));
    if ( !headerRect.isValid() )
        return;

    const QRect cellRect(headerRect.left(), itemRect.top(), headerRect.width(), itemRect.height());

    QString tipStr(item->photo().title());

    tip( cellRect, tipStr );
}

#endif // PHOTOLISTVIEWTOOLTIP_H
