/***********************************************************************
**
**   waypoint.cpp
**
**   This file is part of KFLog2.
**
************************************************************************
**
**   Copyright (c):  2003 by Heiner Lamprecht
**
**   This file is distributed under the terms of the General Public
**   Licence. See the file COPYING for more information.
**
**   $Id: waypoint.cpp,v 1.4 2003/05/20 09:56:19 helmut Exp $
**
***********************************************************************/

#include "waypoint.h"
#include "wp.h"
#include "flight.h"

Waypoint::Waypoint(QString nam, WGSPoint oP, int typ, QString _icao, QString _comment,
  int surf, int runw, int leng, int elev, double freq, bool isLand, QPoint pP,
  time_t s1, time_t s2, unsigned int sFAI,
  double ang, double dist, QString desc, unsigned int import, time_t GPSFixTime)
{
  name = nam;
  origP = oP;
  projP = pP;
  sector1 = s1;
  sector2 = s2;
  sectorFAI = sFAI;
  angle = ang;
  type = typ;
  distance = dist;
  description = desc;
  icao = _icao;
  comment = _comment;
  surface = surf;
  runway = runw;
  length = leng;
  elevation = elev;
  frequency = freq;
  isLandable = isLand;
  importance = import;
  fixTime = GPSFixTime;
}

Waypoint::~Waypoint()
{
}

Waypoint::Waypoint(Waypoint *p)
{
  *this = *p;
}

Waypoint::Waypoint(Waypoint &p)
{
  *this = p;
}

/////////////////////////////////////////////////////
// Implementation of a Logger Fix
flightPoint::flightPoint(void)
{
  //  QPoint projP; // ??
  height = 0;
  gpsHeight = 0;
  engineNoise  = -1; // indicates not measured
  surfaceHeight = 0;
  time  = 0;
  dH = 0;
  dT = 0;
  dS = 0;
  bearing = .0;
  f_state = Flight::Straight;
}
