/***************************************************************************
                          kfvlog.cpp  -  description
                             -------------------
    begin                : Fri Aug 31 2001
    copyright            : (C) 2001 by Jeffrey Yu
    email                : wehjin@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kfvlog.h"

#include <qlayout.h>
#include <qmultilineedit.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qframe.h>
#include <qlineedit.h>
#include "kfocuslogentry.h"
#include "kdatedialog.h"

KFVLog::KFVLog(QWidget *parent, const char *name ) : QGroupBox(parent,name) {
	log_ = NULL;
	
	createWidgets();
}

KFVLog::~KFVLog(){
}


///////////////////////////////////////////////////////////////
// Private methods

void KFVLog::createDateWidgets(QLayout* l){
	QHBoxLayout* hbl = new QHBoxLayout(l);
		QLabel* label = new QLabel("Date ", this);
			hbl->addWidget(label);
			
		leDate_ = new QLineEdit(this);
			leDate_->setReadOnly(true);
			hbl->addWidget(leDate_);
			
		hbl->addWidget(new QWidget(this));
		
		pbChange_ = new QPushButton("&Change", this);
			hbl->addWidget(pbChange_);
}

void KFVLog::createBodyWidgets(QLayout* l){
	QVBoxLayout* vbl = new QVBoxLayout(l);
		QLabel* label = new QLabel("Body", this);
			vbl->addWidget(label);
			
		mleBody_ = new QMultiLineEdit(this);
			mleBody_->setWordWrap(QMultiLineEdit::WidgetWidth);
			vbl->addWidget(mleBody_);			
}
	
void KFVLog::createActionWidgets(QLayout* l){
	QHBoxLayout* hbl = new QHBoxLayout(l);
		hbl->addWidget(new QWidget(this));
		
		pbApply_ = new QPushButton("Apply", this);
			pbApply_->setEnabled(false);
			hbl->addWidget(pbApply_);
			
		pbReset_ = new QPushButton("Reset", this);
			pbReset_->setEnabled(false);
			hbl->addWidget(pbReset_);
}
	
void KFVLog::createWidgets(){
	setTitle("Log Information");
	setEnabled(false);
	
	QVBoxLayout* vbl = new QVBoxLayout(this);
		vbl->setSpacing(5);
		vbl->setMargin(17);

		createDateWidgets(vbl);		
		createBodyWidgets(vbl);
/*		
		QFrame* frame = new QFrame(this);
			frame->setFrameShape(QFrame::HLine);
			frame->setFrameShadow(QFrame::Raised);
			vbl->addWidget(frame);
		
		createActionWidgets(vbl);
*/
}


/** Slot to receive textChanged signal from the body mle */
void KFVLog::onMleBodyTextChanged(){
	if (log_ != NULL) {
		log_->body(mleBody_->text());
	}
}


/** Slot to receive clicked signal from the change(date) pushbutton */
void KFVLog::onPbChangeClicked(){
	KDateDialog dlg;
	
	dlg.date(log_->date());
	
	if (dlg.exec()) {
		log_->date(dlg.date());
				
		/* Check log_ for NULL before setting it because
			changing the date emits signals that may affect the value
			of log_ */
		if (log_ != NULL) {
			leDate_->setText(log_->dateString());
		}
	}
}


///////////////////////////////////////////////////////////////
// Public methods

void KFVLog::log(KFMLog* log){
	if (log != log_) {
		if (log_ != NULL) {
			// Do stuff to clear the current log
			setEnabled(false);
			
			disconnect(mleBody_, 0, this, 0);
			mleBody_->setText("");
			
			disconnect(pbChange_, 0, this, 0);
			leDate_->setText("");
		}
		
		log_ = log;
		if (log_ != NULL) {
			// Do stuff to restore the current entry
			leDate_->setText(log_->dateString());
			connect(pbChange_, SIGNAL( clicked() ), this,
				SLOT( onPbChangeClicked() ));
			
			mleBody_->setText(log_->body());
			connect(mleBody_, SIGNAL( textChanged() ), this,
				SLOT( onMleBodyTextChanged() ));
		
			mleBody_->setFocus();
			setEnabled(true);
		}
	}
}
