/*
 * This file is part of the KFTPGrabber project
 *
 * Copyright (C) 2003-2005 by the KFTPGrabber developers
 * Copyright (C) 2003-2005 Jernej Kos <kostko@jweb-network.net>
 * Copyright (C) 2001-2003 by Joseph Wenninger <jowenn@kde.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * is provided AS IS, WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, and
 * NON-INFRINGEMENT.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Steet, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations
 * including the two.
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * file(s) with this exception, you may extend this exception to your
 * version of the file(s), but you are not obligated to do so.  If you
 * do not wish to do so, delete this exception statement from your
 * version.  If you delete this exception statement from all source
 * files in the program, then also delete it here.
 */

#ifndef KFTPWIDGETSMULTITABBAR_P_H
#define KFTPWIDGETSMULTITABBAR_P_H

#include <qscrollview.h>

#include "multitabbar.h"

namespace KFTPWidgets {

class MultiTabBarInternal : public QScrollView
{
Q_OBJECT
friend class MultiTabBar;
public:
    MultiTabBarInternal(QWidget *parent,MultiTabBar::MultiTabBarMode bm);
    int appendTab(const QPixmap &,int=-1,const QString& =QString::null);
    MultiTabBarTab *tab(int) const;
    void removeTab(int);
    void setPosition(enum MultiTabBar::MultiTabBarPosition pos);
    void setStyle(enum MultiTabBar::MultiTabBarStyle style);
    void showActiveTabTexts(bool show);
    QPtrList<MultiTabBarTab>* tabs() { return &m_tabs; }
private:
    QWidget *box;
    QBoxLayout *mainLayout;
    QPtrList<MultiTabBarTab> m_tabs;
    enum MultiTabBar::MultiTabBarPosition m_position;
    bool m_showActiveTabTexts;
    enum  MultiTabBar::MultiTabBarStyle m_style;
    int m_expandedTabSize;
    int m_lines;
    MultiTabBar::MultiTabBarMode m_barMode;
protected:
    virtual bool eventFilter(QObject *,QEvent*);
    virtual void drawContents ( QPainter *, int, int, int, int);

    /**
    * [contentsM|m]ousePressEvent are reimplemented from QScrollView
    * in order to ignore all mouseEvents on the viewport, so that the
    * parent can handle them.
    */
    virtual void contentsMousePressEvent(QMouseEvent *);
    virtual void mousePressEvent(QMouseEvent *);
    virtual void resizeEvent(QResizeEvent *);
};

}

#endif
