/***************************************************************************
 *   Copyright (C) 2004 by Emil Stoyanov                                   *
 *   emosto@users.sourceforge.net                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kiaxcontact.h"

int KiaxContact::nextContact;

KiaxContact::KiaxContact(QString cname="User", QString cnumber="12345678", QString caccountId="1") {
  id = QString::number(QDateTime::currentDateTime().toTime_t()) + QString::number(KiaxContact::nextContact);
  KiaxContact::nextContact++;
  name = cname;
  number=cnumber;
  accountId=caccountId;
  iconName = "contact.png";
}

KiaxContact::~KiaxContact() {
}

QSettings * KiaxContact::getSettings() {
  
  QSettings* settings = new QSettings();
  settings->setPath("kiax.org","kiax", QSettings::User);// userspace
  QString contactPrefix = "/kiax/contacts/"+id+"/";
  nameKey = contactPrefix+"name";
  numberKey = contactPrefix+"number";
  accountIdKey = contactPrefix+"accountId";

  return settings;
}

void KiaxContact::load() {
  load(getId());
}

void KiaxContact::load(QString lid) {
  id = lid;
  QSettings*  settings = getSettings();
  name = settings->readEntry(nameKey, "user");
  number = settings->readEntry(numberKey, "12345678");
  accountId = settings->readEntry(accountIdKey, "1");
  
  delete settings;
}

bool KiaxContact::save() {
  
  bool result = false;  
  
  QSettings*  settings = getSettings();
  
  result &= settings->writeEntry(nameKey, name);
  result &= settings->writeEntry(numberKey, number);
  result &= settings->writeEntry(accountIdKey, accountId);
  
  delete settings;
  
  return result;
  
}

void KiaxContact::remove() {
  QSettings*  settings = getSettings();
  settings->removeEntry(nameKey);
  settings->removeEntry(numberKey);
  settings->removeEntry(accountIdKey);
  delete settings;
}

void KiaxContact::setId(QString nid)
{
    id=nid;
}

void KiaxContact::setName(QString nname)
{
    name=nname;
}

void KiaxContact::setNumber(QString nnumber)
{
    number=nnumber;
}

void KiaxContact::setAccountId(QString aid)
{
    accountId=aid;
}

QString KiaxContact::getId()
{
    return id;
}

QString KiaxContact::getName()
{
    return name;
}

QString KiaxContact::getIconName()
{
    return iconName;
}

void KiaxContact::setIconName(QString name)
{
   iconName = name;
}

QString KiaxContact::getNumber()
{
    return number;
}

QString KiaxContact::getAccountId()
{
    return accountId;
}
