/***************************************************************************
 *   Copyright (C) 2004 by Emil Stoyanov                                   *
 *   emosto@users.sourceforge.net                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kiaxiconfactory.h"

KiaxIconFactory::KiaxIconFactory()
{
}

KiaxIconFactory::~KiaxIconFactory()
{
	if (singleton!=NULL) delete singleton;
	KiaxIconFactory::singleton = NULL;
}

KiaxIconFactory * KiaxIconFactory::instance() {
	if (singleton==NULL)
		singleton = new KiaxIconFactory;
	return KiaxIconFactory::singleton;
}

KiaxIconFactory * KiaxIconFactory::createInstance(QString pathName) {
	if (singleton==NULL)
		singleton = new KiaxIconFactory;
	singleton->iconsPath = pathName;
	return singleton;
}

QPixmap KiaxIconFactory::createIcon(KiaxIconType iconType, KiaxAccount* account) {
	switch (iconType) {
		case ACCOUNT_ICON : {
		        QPixmap pm ( iconsPath + account->accIcon);
			return pm;
			break;
		}
		case GROUP_ICON : {
		        QPixmap pm ( iconsPath + account->accIcon);
			return pm;
			break;
		}
		case REGISTRATION_CONNECTING : {
		        QPixmap pm ( iconsPath + account->accIcon);
			arrowIcon(pm);
			return pm;
			break;
		}
		case REGISTRATION_ACCEPTED : {
		        QPixmap pm ( iconsPath + account->accIcon);
			return pm;
			break;
		}
		case REGISTRATION_REJECTED : {
		        QPixmap pm ( iconsPath + account->accIcon);
			crossIcon(pm);
			return pm;
			break;
		}
		case REGISTRATION_TIMEOUT : {
		        QPixmap pm ( iconsPath + account->accIcon);
			timeIcon(pm);
			return pm;
			break;
		}
		case REGISTRATION_INACTIVE : {
		        QPixmap pm ( iconsPath + account->accIcon);
			dimIcon(pm);
			return pm;
			break;
		}
		default: {
			QPixmap defaultIcon (iconsPath + "account.png");
			return defaultIcon;
		}
	}
}

QPixmap KiaxIconFactory::createIcon(KiaxIconType iconType, KiaxContact* contact) {
	switch (iconType) {
		case CONTACT_ICON : {
		        QPixmap pm ( iconsPath + contact->getIconName());
			return pm;
			break;
		}
		default: {
			QPixmap defaultIcon (iconsPath + "contact.png");
			return defaultIcon;
		}
	}
}

void KiaxIconFactory::dimIcon(QPixmap& pixmap) {
	return;
}

void KiaxIconFactory::crossIcon(QPixmap& pixmap) {
	return;
}

void KiaxIconFactory::arrowIcon(QPixmap& pixmap) {
	return;
}

void KiaxIconFactory::timeIcon(QPixmap& pixmap) {
	return;
}
