/* $Id: timers.c,v 1.14 2005/11/30 13:10:21 ekalin Exp $ */

/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <kcconfig.h>
#endif

#include <libintl.h>
#include <locale.h>
#include <gtk/gtk.h>
#include <glade/glade.h>

#include "kildclient.h"
#include "perlscript.h"
#include "ansi.h"


/*************************
 * File global variables *
 *************************/


/***********************
 * Function prototypes *
 ***********************/



gboolean
run_timer(gpointer data)
{
  Timer *timer = (Timer *) data;
  World *world = timer->for_world;

  if (world->disable_timers) {
    return TRUE;
  }

  world_for_perl = world;
  parse_commands(world, timer->action, strlen(timer->action));
  we_timer_update_timer(world, timer);
  world_for_perl = currentWorld;

  if (timer->count != -1 && --timer->count <= 0) {
    if (timer->temporary) {
      we_timer_delete_timer(world, timer);
      world->timers = g_slist_remove(world->timers,
                                     timer);
      if (!timer->owner_plugin) {
        --world->timer_pos;
      }
      free_timer(timer, NULL);
    } else {
      timer->enabled = FALSE;
    }

    return FALSE;
  }

  return TRUE;
}


void
start_timers(World *world)
{
  GSList *timerptr = world->timers;
  Timer  *timer;

  while (timerptr) {
    timer = (Timer *) timerptr->data;

    /* Timers of plugins loaded from the script file have already
       been started. */
    if (timer->enabled && !timer->function_id) {
      timer->function_id = g_timeout_add(timer->interval * 1000,
                                         run_timer,
                                         timer);
    }

    timerptr = timerptr->next;
  }
}


void
remove_timer(World *world, GSList *timeritem)
{
  Timer *timer = (Timer *) timeritem->data;

  we_timer_delete_timer(world, timer);

  world->timers = g_slist_remove_link(world->timers, timeritem);
  if (!timer->owner_plugin) {
    --world->timer_pos;
  }
  free_timer(timer, NULL);
  g_slist_free(timeritem);
}


gboolean
move_timer(World *world, gint old_pos, gint new_pos)
{
  GSList   *timeritem;
  gpointer  timer;

  timeritem = g_slist_nth(world->timers, old_pos);
  if (!timeritem) {
    return FALSE;
  }
  timer = timeritem->data;

  world->timers = g_slist_delete_link(world->timers, timeritem);
  world->timers = g_slist_insert(world->timers, timer, new_pos);

  we_timer_delete_timer(world, timer);
  we_timer_insert_timer(world, timer, new_pos);

  return TRUE;
}


void
free_timer(Timer *timer, gpointer data)
{
  if (timer->enabled) {
    g_source_remove(timer->function_id);
  }
  g_free(timer->action);

  g_free(timer);
}


void
list_timers(World *world, Plugin *plugin)
{
  int     i;
  guint   total_width;
  guint   field_width;
  GSList *timerptr;
  Timer  *timer;

  /* The rows argument is not used. */
  ansitextview_get_size(world->gui, &field_width, &total_width);

  /* If the screen is really narrow, we can do nothing. */
  if (total_width < 29) {
    total_width = 29;
  }
  field_width = total_width - 23;

  ansitextview_append_string_nl(world->gui,_("Num Int Count Ena Temp Action"));
  ansitextview_append_string(world->gui, "--- --- ----- --- ---- ");
  for (i = 0; i < field_width; ++i) {
    ansitextview_append_string(world->gui, "-");
  }
  ansitextview_append_string(world->gui, "\n");

  i = 0;
  timerptr = world->timers;
  while (timerptr) {
    timer = (Timer *) timerptr->data;

    if (timer->owner_plugin == plugin) {
      ansitextview_append_stringf(world->gui,"%3d %3d %5d %3.3s %4.4s %-*.*s\n",
                                  i,
                                  timer->interval,
                                  timer->count,
                                  timer->enabled ? _("y") : _("n"),
                                  timer->temporary ? _("y") : _("n"),
                                  field_width, field_width, timer->action);
    }

    ++i;
    timerptr = timerptr->next;
  }
}


void
save_timer(FILE *fp, Timer *timer)
{
  fprintf(fp, "    <timer ");
  if (timer->name) {
    fprintf(fp, "name=\"%s\" ", timer->name);
  }
  fprintf(fp,
          "interval=\"%d\" count=\"%d\" enabled=\"%d\" temporary=\"%d\">",
          timer->interval,
          timer->count,
          timer->enabled,
          timer->temporary);
  fprintf_escaped(fp, "%s</timer>\n", timer->action);
}
