# /* Makefile for the term processor */
# /* 2 input .k-files plus yacc and lex usage. */
IT = example
KFILES = file1.k file2.k
YOURFILES = ${KFILES} ${IT}y.y ${IT}l.l ${IT}main.c
ALLOBJS = k.o rk.o csgiok.o unpk.o\
	${KFILES:k=o} ${IT}y.o ${IT}l.o ${IT}main.o
GENERATED_BY_KC = k.c rk.c csgiok.c unpk.c ${KFILES:k=c}\
	k.h rk.h csgiok.h unpk.h ${KFILES:k=h}
YFLAGS = -d

${IT}:				${ALLOBJS}
	${CC} ${CFLAGS} ${ALLOBJS} -ll -o $@

${GENERATED_BY_KC}:		kctimestamp

kctimestamp:			${KFILES}
	kc ${KFILES}; touch kctimestamp

${ALLOBJS}:			k.h
${IT}main.o ${IT}l.o: 		x.tab.h
${IT}main.o ${KFILES:k=o}: 	${KFILES:k=h}
${IT}main.o rk.o: 		rk.h
${IT}main.o csgiok.o: 		csgiok.h
${IT}main.o unpk.o: 		unpk.h

# /* making copies to prevent unnecessary recompilation after yacc run */
x.tab.h:			y.tab.h
	-cmp -s x.tab.h y.tab.h || cp y.tab.h x.tab.h

# /* if you clean up, don't forget to remove the file kctimestamp */
