/***************************************************************************
 *   Copyright (C) 2005 by Debajyoti Bera                                  *
 *   dbera.web@gmail.com                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "beaglesearch.h"
#include <kmessagebox.h>
#include <kdebug.h>

BeagleSearch::BeagleSearch(QObject *parent, const char *name)
    : QObject(parent, name)
{
}


BeagleSearch::~BeagleSearch()
{
}

BeagleSearch *BeagleSearch::current_instance = NULL;

/*!
    \fn BeagleSearch::search(QString& searchstr)
 */
void BeagleSearch::search(QString& searchstr)
{
		BeagleClient   *client;
		BeagleQuery    *query;
		GMainLoop      *main_loop;
		
		kdDebug() << "----------- query string:" << searchstr << endl;
		
		if (searchstr == QString::null || searchstr == "") {
			emit oops_error ("beagle doesnt like finding nothing :-X");
			return;
		}

		QStringList beagle_query_list = QStringList::split (' ', searchstr);
		if (beagle_query_list.empty()) {
			emit oops_error ("beagle doesnt like finding nothing :-X");
			return;
		}
		
		g_type_init ();
		
		client = beagle_client_new (NULL);
		if (client == NULL) {
			emit oops_error ("beagled not running :-(");
			//kdDebug() << "------------ beagled not running" << endl;
			return;
		}
		
		main_loop = g_main_loop_new (NULL, FALSE);
		
		query = beagle_query_new ();

	    for ( QStringList::Iterator it = beagle_query_list.begin();
			  it != beagle_query_list.end();
			  ++it ) {
			QString q = *it;
			const char *_q = q.ascii();
        	beagle_query_add_text (query, _q);
			kdDebug() << "------------ adding query:[" << _q << "]" << endl;
		}
		
		GError *err = NULL;
		current_instance = this; // store for callbacks
		
		g_signal_connect (query, "hits-added",
			  G_CALLBACK (BeagleSearch::hits_added_cb),
			  client);

		g_signal_connect (query, "finished",
			  G_CALLBACK (BeagleSearch::finished_cb),
			  main_loop);
	
		beagle_client_send_request_async (client, BEAGLE_REQUEST (query),
					  &err);
		if (err) {
			emit oops_error(QString(err->message));
			kdDebug() << "-------- err:" << err->message << endl;
			g_error_free (err);
			return;
		}
		
		beagle_query_list.clear();
		g_main_loop_run (main_loop);
		g_object_unref (query);
		g_object_unref (client);
		g_main_loop_unref (main_loop);    
}

QString *BeagleSearch::get_uri_from_file_hit(BeagleHit *hit)
{
	return new QString (beagle_hit_get_uri (hit));
}

QString *BeagleSearch::get_uri_from_feed_hit(BeagleHit *hit)
{
	return new QString (beagle_hit_get_property (hit, "fixme:itemuri"));
}

void BeagleSearch::hits_added_cb (BeagleQuery *query, BeagleHitsAddedResponse *response) 
{
	GSList *hits, *l;
	gint    i;
	gint    nr_hits;
	BeagleResultList results;
	
	hits = beagle_hits_added_response_get_hits (response);
	nr_hits = g_slist_length (hits);
	kdDebug() << "---------- hits added:" << nr_hits << endl;
	for (l = hits, i = 1; l; l = l->next, ++i) {
		//print_hit (BEAGLE_HIT (l->data));
		beagle_result_struct *result = new beagle_result_struct;
		
		const char *_title = beagle_hit_get_property (BEAGLE_HIT (l->data), "dc:title");
		const char *title = (_title == NULL ? "-" : _title);
		result->title = new QString(title);
		
		const char *_mime_type = beagle_hit_get_mime_type(BEAGLE_HIT (l->data));
		const char *mime_type = (_mime_type == NULL ? "-" : _mime_type);
		result->mime_type = new QString(mime_type);
		
		BeagleTimestamp *timestamp = beagle_hit_get_timestamp (BEAGLE_HIT (l->data));
		time_t	index_time;
		if (beagle_timestamp_to_unix_time (timestamp, &index_time))
			result->last_index_time = index_time;
		else
			result->last_index_time = 0;
		
		if (strcmp (beagle_hit_get_type (BEAGLE_HIT (l->data)), "FeedItem") == 0) {
                result->uri = get_uri_from_feed_hit (BEAGLE_HIT (l->data));
				result->type = Link;
        } else if (strcmp (beagle_hit_get_type (BEAGLE_HIT (l->data)), "File") == 0) {
               	result->uri = get_uri_from_file_hit (BEAGLE_HIT (l->data));
				result->type = File;
        } else if (strcmp (beagle_hit_get_type (BEAGLE_HIT (l->data)), "MailMessage") == 0) {
               	result->uri = get_uri_from_file_hit (BEAGLE_HIT (l->data));
				result->type = File;
        } else
			continue;		
		;
		results.append (result);
	}
	
	g_object_unref (response);
	if (current_instance != NULL)
		current_instance->gotOutput(results);
}

void BeagleSearch::finished_cb (BeagleQuery            *query,
	     BeagleFinishedResponse *response, 
	     GMainLoop              *main_loop)
{
	g_main_loop_quit (main_loop);
	if (current_instance != NULL)
		current_instance->finishedSearch();
}

void BeagleSearch::finishedSearch()
{
   kdDebug() << "Locater::finished" << endl;

   emit finished();
}
                             
void BeagleSearch::gotOutput(BeagleResultList &items)
{	
	kdDebug() << "-------- gotOutput has " << items.count() << " results" << endl;
	emit found(items);
}

#include "beaglesearch.moc"
