/***************************************************************************
 *   Copyright (C) 2005 by Debajyoti Bera                                  *
 *   dbera.web@gmail.com                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef BEAGLESEARCH_H
#define BEAGLESEARCH_H

#include <qobject.h>
#include <qstringlist.h>

extern "C" {
#include <glib.h>
#include <beagle/beagle.h>
#include <beagle/beagle-query-part-property.h>
}

enum HitType {
	File,
	Link,
	Mail,
	Launcher,
	Alien_type
};

typedef struct beagle_result_struct {
	QString		*uri;
	QString		*title;
	HitType		type;
	QString		*mime_type;
	time_t		last_index_time;
} beagle_result_struct;
typedef QPtrList<beagle_result_struct> BeagleResultList;

/**
Interface to beagle-query

@author Debajyoti Bera
*/
class BeagleSearch : public QObject {
Q_OBJECT
public:
    BeagleSearch(QObject *parent = 0, const char *name = 0);

    ~BeagleSearch();
    void search(QString& searchstr);
	
signals:
    void found(BeagleResultList &results);
    void finished();
	void oops_error(const QString& msg);
	
private slots:
    void gotOutput(BeagleResultList& items);
    void finishedSearch();

private:
	static void hits_added_cb (BeagleQuery *, BeagleHitsAddedResponse *);
	static void finished_cb (BeagleQuery *, BeagleFinishedResponse *, GMainLoop *);
	static BeagleSearch *current_instance;
	static QString *get_uri_from_feed_hit (BeagleHit *);
	static QString *get_uri_from_file_hit (BeagleHit *);
};

#endif
