/**
 * Manipulates playlists
 * @copyright Copyright 2004 Shaun Jackman
 * @author Shaun Jackman <sjackman@debian.org>
 */
static const char* rcsid __attribute__((unused)) =
"$Id: playlist.cpp,v 1.6 2004/04/06 21:19:19 tsirc Exp $";


/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


// kionjb
#include "njb.h"
#include "playlist.h"

// KDE
#include <kdebug.h>
#include <klocale.h>
#include <kmessagebox.h>
using namespace KIO;

// POSIX
#include <stdlib.h>



Playlist::Playlist( kio_njbProtocol* kionjb)
{
	m_playlist = playlist_new();
	if( !m_playlist)
		kdDebug( 7182) << "putPlaylist: playlist_new failed\n";
	m_kionjb = kionjb;
}


Playlist::~Playlist( void)
{
	playlist_destroy( m_playlist);
}


int
Playlist::load( const QString& fileName)
{
	QString playlistName = fileName;
	if( fileName.right( 4) == ".m3u")
		playlistName.truncate( playlistName.length() - 4);

	char** result;
	int nrow, ncolumn;
	char* errmsg;
	sqlite_get_table_printf( m_kionjb->m_db,
			"SELECT id FROM playlists WHERE name='%q'",
			&result, &nrow, &ncolumn, &errmsg,
			playlistName.latin1());
	if( errmsg) {
		m_kionjb->warning( errmsg);
		free( errmsg);
		return ERR_COULD_NOT_READ;
	}

	if( nrow) {
		m_playlist->_state = NJB_PL_CHTRACKS;
		m_playlist->plid = atoi( result[ 1]);
	} else {
		m_playlist->_state = NJB_PL_NEW;
		m_playlist->plid = 0;
	}

	if( playlist_set_name( m_playlist, playlistName) == -1) {
		kdDebug( 7182) << "putPlaylist: playlist_set_name failed\n";
		return ERR_COULD_NOT_WRITE;
	}
	return 0;
}


int
Playlist::add( const QString& fileName)
{
	Track track;
	if( !m_kionjb->trackByFilename( track, fileName)) {
		// couldn't find this track, skip it
		kdDebug( 7182) << "putPlaylist: couldn't find " << fileName << endl;
		int result = m_kionjb->messageBox( SlaveBase::WarningContinueCancel,
				i18n( "Could not find track in library\n%1").arg( fileName),
				i18n( "Uploading Playlist"),
				i18n( "C&ontinue"));
		if( result == KMessageBox::Cancel)
			return ERR_COULD_NOT_WRITE;
		return 0;
	}
	playlist_track_t* pl_track = playlist_track_new( track.id);
	if( !pl_track) {
		kdDebug( 7182) << "putPlaylist: playlist_track_new failed\n";
		return ERR_COULD_NOT_WRITE;
	}
	playlist_addtrack( m_playlist, pl_track, NJB_PL_END);
	return 0;
}


int
Playlist::update( void)
{
	kdDebug( 7182) << "putPlaylist: state = " << m_playlist->_state << endl;
	kdDebug( 7182) << "putPlaylist: id = " << m_playlist->plid << endl;
	kdDebug( 7182) << "putPlaylist: sending...\n";
	playlist_dump( m_playlist, stderr);
	int status = NJB_Update_Playlist( m_kionjb->m_njb, m_playlist);
	if( status == -1) {
		kdDebug( 7182) << "putPlaylist: NJB_Update_Playlist failed\n";
		njb_error_dump( stderr);
		return ERR_COULD_NOT_WRITE;
	}
	return 0;
}
