#ifndef KP_CALENDAR_VIEW_H_
#define KP_CALENDAR_VIEW_H_

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>

#include "../kputil.h"
#include "kpviewmodel.h"

#define KP_TYPE_CALENDAR_VIEW (kp_calendar_view_get_type())
#define KP_CALENDAR_VIEW(object) (G_TYPE_CHECK_INSTANCE_CAST ((object), KP_TYPE_CALENDAR_VIEW, KPCalendarView))
#define KP_CALENDAR_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KP_TYPE_CALENDAR_VIEW, KPCalendarViewClass))
#define KP_IS_CALENDAR_VIEW(object) (G_TYPE_CHECK_INSTANCE_TYPE ((object), KP_TYPE_CALENDAR_VIEW))
#define KP_IS_CALENDAR_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KP_TYPE_CALENDAR_VIEW))
#define KP_CALENDAR_VIEW_GET_CLASS(object) (G_TYPE_INSTANCE_GET_CLASS ((object), KP_TYPE_CALENDAR_VIEW, KPCalendarViewClass))

enum
{
  MONTH_PREV,
  MONTH_CURRENT,
  MONTH_NEXT
};

typedef struct KPCalendarView_
{
  GtkWidget       parent;

  GDate          *date;         /* not */

  gpointer        private_data;
} KPCalendarView;

typedef struct KPCalendarViewClass_
{
  GtkWidgetClass  parent;

  void            (*day_selected) (KPCalendarView *, KPDate *);
} KPCalendarViewClass;

GtkWidget    *kp_calendar_view_new               (KPViewModelType type,
                                                  guint d, guint m, guint y);

GType         kp_calendar_view_get_type          (void);

void          kp_calendar_view_set               (KPCalendarView *cv,
                                                  KPViewModelType type);


void          kp_calendar_view_set_date          (KPCalendarView *cv,
                                                  guint d, guint m, guint y);

void          kp_calendar_view_get_date          (KPCalendarView *cv,
                                                  guint *d, guint *m, guint *y);

GDate        *kp_calendar_view_get_start_date    (KPCalendarView *cv);
GDate        *kp_calendar_view_get_end_date      (KPCalendarView *cv);

void          kp_calendar_view_attach_popup_menu (KPCalendarView *cv,
                                                  GtkMenu *menu);

void          kp_calendar_view_open_to_window    (KPViewModelType type,
                                                  guint d, guint m, guint y);

void          kp_calendar_view_clear_marks       (KPCalendarView *cv);

void          kp_calendar_view_add_mark          (KPCalendarView *cv,
                                                  guint d, guint m, guint y,
                                                  guint h, guint min,
                                                  const gchar *str);
G_CONST_RETURN 
       gchar* kp_calendar_view_get_current_mark  (KPCalendarView *cv);

void          kp_calendar_view_remove_current_mark (KPCalendarView *cv);
void          kp_calendar_view_remove_mark       (KPCalendarView *cv,
                                                  guint d, guint m, guint y,
                                                  const gchar *mark);

void          kp_calendar_view_set_active        (KPCalendarView *cv,
                                                  gboolean activate);
gboolean      kp_calendar_view_get_active        (KPCalendarView *cv);

#endif
