#ifndef KP_SETTINGS_H_
#define KP_SETTINGS_H_

#include <libxml/tree.h>
#include <glib.h>

gboolean     kp_settings_init              (const gchar *filename);
void         kp_settings_deinit            (void);
void         kp_settings_save              (void);
void         kp_settings_remove_setting    (const gchar *setting);

gint         kp_settings_get_int           (const gchar *setting);
gchar       *kp_settings_get_str           (const gchar *setting);
gboolean     kp_settings_get_bool          (const gchar *setting);
GSList      *kp_settings_get_list          (const gchar *setting);

void         kp_settings_set_str           (const gchar *setting,
                                            const gchar *val,
                                            gboolean replace);
void         kp_settings_set_int           (const gchar *setting,
                                            gint value);
void         kp_settings_set_bool          (const gchar *setting,
                                            gboolean value);
void         kp_settings_add_to_list       (const gchar *setting,
                                            const gchar *value);
void         kp_settings_remove_from_list  (const gchar *setting,
                                            const gchar *value);

void         kp_settings_list_free         (GSList *list);

#endif
