/*
 *  Klavier : Virtual keyboard for K Destop Environement
 *
 *  This program (klavier) is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 *  This program (klavier) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public
 * License along with this program (klavier); if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307 USA. 
 *
 * Author : Sebastien HUSS <sebastien.huss@laposte.net>
 *
 */
#include "configdialog.h"

#include <klocale.h>
#include <kapplication.h>
#include <qcheckbox.h>
#include <qlayout.h>

ConfigDialog::ConfigDialog(QWidget *parent)
	: KDialogBase(Plain, I18N_NOOP( "Configure" ), Ok|Cancel|Apply, Ok, parent)
{
	this->clavierTab	= this->plainPage();

	QBoxLayout* layout = new QVBoxLayout( this->clavierTab);
	layout->setSpacing( KDialog::spacingHint() );
	this->useMajLimit = new QCheckBox( I18N_NOOP("&Use the top/down Hack"), this->clavierTab );
	layout->addWidget(this->useMajLimit);


	connect( this, SIGNAL(applyClicked()), this, SLOT(apply()) );
	connect( this, SIGNAL(okClicked()), this, SLOT(apply()) );
}


ConfigDialog::~ConfigDialog()
{
}

void ConfigDialog::apply()
{
	// disabling buttons => users sees that we are working
	this->enableButtonOK(false);
	this->enableButtonCancel(false);
	this->enableButtonApply(false);
	kapp->processEvents();
	emit applied( this );
	// re-enable (in case of "Apply")
	this->enableButtonOK(true);
	this->enableButtonCancel(true);
	this->enableButtonApply(true);
}

#include "configdialog.moc"
