/*
 *  Klavier : Virtual keyboard for K Destop Environement
 *
 *  This program (klavier) is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 *  This program (klavier) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public
 * License along with this program (klavier); if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307 USA. 
 *
 * Author : Sebastien HUSS <sebastien.huss@laposte.net>
 *
 */
#ifndef KEYBOARDWIDGET_H
#define KEYBOARDWIDGET_H

#include "keyboardmodifier.h"
#include "keyboardkeys.h"
#include <qwidget.h>

#define NUM_KEY_ROWS     6
#define NUM_KEY_COLS    21
#define NUM_MODIFIER	 8

/**
	@author Sebastien HUSS <sebastien.huss@laposte.net>
 */
class KeyboardWidget : public QWidget
{
	Q_OBJECT

	public:

		KeyboardWidget(sendKey * wire, QWidget * parent = 0, const char * name = 0);

    /**
		 * Default Destructor
     */
		virtual			~KeyboardWidget();
		void			releaseModifiers();
		void			sendModifiersDown();
		void			setUseMajLimit(bool);
		bool			useMajLimit() {return this->cfgUseMajLimit;}
		void			majDown();
		bool			mustUseMajLimit(KeyCode kc);
	private:
		static KeyCode		keycodes[NUM_KEY_ROWS][NUM_KEY_COLS];
		PushKey*		buttons[NUM_KEY_ROWS][NUM_KEY_COLS];
		KeyboardModifier*	modifiers[NUM_MODIFIER];
		KeyboardModifier*	majModifier;
		sendKey*		wire;

		void			resizeEvent(QResizeEvent* re);
		bool			isModifier(KeyCode kc);
		
		bool			cfgUseMajLimit;
};


#endif
