/*
 *  Klavier : Virtual keyboard for K Destop Environement
 *
 *  This program (klavier) is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 *  This program (klavier) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public
 * License along with this program (klavier); if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307 USA. 
 *
 * Author : Sebastien HUSS <sebastien.huss@laposte.net>
 *
 */


#ifndef _KLAVIER_H_
#define _KLAVIER_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kmainwindow.h>
class KlavierWidget;
class TrayIcon;
class sendKey;
class ConfigDialog;
/**
 * @short Application Main Window
 * @author Sebastien HUSS <sebastien.huss@laposte.net>
 * @version 0.3
 */
class klavier : public KMainWindow
{
	Q_OBJECT
	public:
		klavier();
		virtual ~klavier();

		void	toggleVisibility();

	public slots:
		void	quit();
		void	showConfig();

	protected slots:
		void	applyPrefs(ConfigDialog*);
		void	loadConfig();
		void	saveConfig();
	protected:
		bool	queryClose();

	private:
		KlavierWidget*	kw;
		sendKey*	wire;
		TrayIcon*	tray;
		ConfigDialog*	configDlg;
		
		bool	cfgUseMajLimit;
};

#endif // _KLAVIER_H_
