/*
 *  Klavier : Virtual keyboard for K Destop Environement
 *
 *  This program (klavier) is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 *  This program (klavier) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public
 * License along with this program (klavier); if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307 USA. 
 *
 * Author : Sebastien HUSS <sebastien.huss@laposte.net>
 *
 */
#include "stroke.h"
#include <qpoint.h>
#include <math.h>

#define min(a,b) (((a)<(b))?(a):(b))
#define max(a,b) (((a)>(b))?(a):(b))

#include <iostream>
using namespace std;

StrokeBitmap::StrokeBitmap()
{
	this->data	= new uint[sizeof(uint)*8];
	for(int i=0;i<(int)sizeof(uint)*8;i++)
		this->data[i] = 0;
}

StrokeBitmap::~StrokeBitmap()
{
	delete this->data;
}

void StrokeBitmap::set(int x, int y)
{
	if(y<sizeof(uint)*8 && x < sizeof(uint)*8 && y>=0 && x>=0)
		this->data[y] = this->data[y] | 1 << x;
}
uint StrokeBitmap::getLine(int y)
{
	return	this->data[y];
}

int StrokeBitmap::matchingScore(StrokeBitmap *to)
{
	int retLine;
	int ret = 0;
	
	for(int i=0;i<(int)sizeof(uint)*8;i++)
	{
		retLine	= ~ (this->data[i] ^ to->getLine(i));
		for(int j=0;j<(int)sizeof(uint)*8;j++)
			ret += 1 & (retLine>>j);
		cout << hex << this->data[i] << " ^ " << to->getLine(i) << " ret=" << dec << ret << endl;
	}
	cout << "----------------------------------------" << endl;
	return ret;
}


/*****************************************/

Stroke::Stroke(QObject *parent, const char *name)
 : QObject(parent, name)
{
	this->segs	= new QPtrList<Segment>();
	this->segs->setAutoDelete(TRUE);
}

Stroke::~Stroke()
{
}

void	Stroke::addPoint( QPoint *p)
{
	if	(this->segs->isEmpty())
		this->nextSegment();
	this->segs->current()->append(p);
}

void	Stroke::nextSegment()
{
	this->segs->append(new Segment());
	this->segs->current()->setAutoDelete(TRUE);
}

StrokeBitmap *Stroke::toBitmap()
{
	StrokeBitmap	*ret	= new StrokeBitmap();
	QPoint		*min	= this->minPoint();
	QPoint		*max	= this->maxPoint();
	int		w	= max->x() - min->x();
	int		h	= max->y() - min->y();
	int		d	= sizeof(int)*8;
	int		x;
	int		y;

	for(uint i=0;i<this->segs->count();i++)
	{
		if (this->segs->at(i) != (Segment*)0)
		{
			for(uint j=1;j<this->segs->at(i)->count();j++)
			{
				// get the scaled coord of this part of the segment
				int x1 = (d*(this->segs->at(i)->at(j-1)->x() - min->x()))/w;
				int y1 = (d*(this->segs->at(i)->at(j-1)->y() - min->y()))/h;
				int x2 = (d*(this->segs->at(i)->at(j)->x() - min->x()))/w;
				int y2 = (d*(this->segs->at(i)->at(j)->y() - min->y()))/h;
				if (x1>x2)
				{
					int	tmp=x1;x1=x2;x2=tmp;
					tmp=y1;y1=y2;y2=tmp;
				}

				// draw virtually this segment
				if (x1<x2)
				{
					for (x=x1;x<=x2;x++)
						ret->set(x,y);
				}
				else //x1=x2
				{
					if (y1>y2)
					{
						int	tmp=x1;x1=x2;x2=tmp;
						tmp=y1;y1=y2;y2=tmp;
					}
					if (y1<y2)
					{
						for (y=y1;y<=y2;y++)
							ret->set(x1,y);
					}
					else //y1=y2
						ret->set(x1, y1);
				}
			}
		}
	}
	return	ret;
}

QPoint	*Stroke::minPoint()
{
	int	mx = 50000;
	int	my = 50000;
	int	x = 0;
	int	y = 0;

	for(uint i=0;i<this->segs->count();i++)
	{
		if (this->segs->at(i) != (Segment*)0)
		{
			for(uint j=0;j<this->segs->at(i)->count();j++)
			{
				x = this->segs->at(i)->at(j)->x();
				y = this->segs->at(i)->at(j)->y();
				mx = min(mx,x);
				my = min(my,y);
			}
		}
	}
	return new QPoint(mx, my);
}

QPoint	*Stroke::maxPoint()
{
	int	mx = 0;
	int	my = 0;
	int	x = 0;
	int	y = 0;

	for(uint i=0;i<this->segs->count();i++)
	{
		if (this->segs->at(i) != (Segment*)0)
		{
			for(uint j=0;j<this->segs->at(i)->count();j++)
			{
				x = this->segs->at(i)->at(j)->x();
				y = this->segs->at(i)->at(j)->y();
				mx = max(mx,x);
				my = max(my,y);
			}
		}
	}
	return new QPoint(mx, my);
}

#include "stroke.moc"
