/*
 * This file is a part of KleanSweep.
 *
 * Copyright (C) 2005 Pawel Stolowski <pawel.stolowski@wp.pl>
 *
 * KleanSweep is free software; you can redestribute it and/or modify it
 * under terms of GNU General Public License by Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY. See GPL for more details.
 */

#ifndef __DIRLISTWIDGET_H
#define __DIRLISTWIDGET_H

/*! \file dirlistwidget.h */

#include <qhgroupbox.h>

class KURLRequester;
class KListBox;
class KPushButton;
class QListBoxItem;
class QStringList;

class DirListWidget: public QHGroupBox
{
	Q_OBJECT
		
	protected:
		KURLRequester *path;
		KListBox *list;
		KPushButton *b_new;
		KPushButton *b_rem;

	protected slots:
		void newClicked();
		void removeClicked();
		void updateSelectedItem(const QString &txt);
		void pathSelected(QListBoxItem *item);

	public:
		DirListWidget(const QString &title, QWidget *parent);
		~DirListWidget();

		void insertStringList(const QStringList &strlist, int index=-1);
		QStringList getAllPaths();
};

#endif

