/*
 * This file is a part of KleanSweep.
 *
 * Copyright (C) 2005 Pawel Stolowski <pawel.stolowski@wp.pl>
 *
 * KleanSweep is free software; you can redestribute it and/or modify it
 * under terms of GNU General Public License by Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY. See GPL for more details.
 */

#ifndef __SWEEPFILEINFO_H
#define __SWEEPFILEINFO_H

#include <kfileitem.h>

class SweepFileInfo: public KFileItem
{
        protected:
		bool remove;
		char scre;
		QString target;
                                
        public:
                SweepFileInfo(const KURL &path, char score=9);
                ~SweepFileInfo();

		void markForRemoval(bool f);
		bool isMarkedForRemoval() const;
		void setTarget(const QString &path);
		int getScore() const;
		QString getTarget() const;
};

#endif
