#ifndef CKLEARAPPTXTDECODER_H
#define CKLEARAPPTXTDECODER_H

#include <iostream>
#include <qobject.h>
#include <qmutex.h>

#include "../CKlearAppDecodingHelper.h"
#include "../CKlearAppConfig.h"

/**
Gets the read buffer and decodes the pat table
@author Omar El-Dakhloul <omar@klear.org> with many code from dvbsnoop
*/
class CKlearAppTXTDecoder : public QObject
{
  Q_OBJECT
  // CppDoc fehlt !
  public:
    CKlearAppTXTDecoder( CKlearAppConfig *config, QObject *const parent = 0 );
    ~CKlearAppTXTDecoder();

    char secound;
    int doubleHeight;

    QString pageNumber;
    QString number;

    //Diese Reihenfolge so lassen. Wichtig fr die locks! [FHa]
    QMutex headerMutex;
        int TXTHeaderData[ 32 ];

    QMutex bodyMutex;
        int TXTBodyData[ 24 ][ 40 ];

    int decodeSectionPAT( u_char *buf );
    int decodeSectionPMT( u_char *buf );
    void decodePESTXT( u_char *buf, int len );

  signals:
    void changedHeaderInfo();
    void changedBodyInfo();

  private:
    int row;

    int decodeTXTDataField( u_char *buf, int len );
    int decodeTXTPacketData( u_char *buf, int len );
    void decodePrivateData( u_char *buf, int len );
    void decodeEBUData( u_char *buf, int len );
    void unParityTeletextData( u_char *buf, int len );
    void searchPage( u_char *buf, int len );

    void setTXTHeaderData( u_char *buf, int len );
    void setTXTBodyData( u_char *buf, int len );

    void printasciiline_buf( u_char *buf, int len );
    void printhexline_buf( u_char *buf, int len );

    CKlearAppConfig *KlearConfig;
};

#endif
