/*		Name:		chump.c
		Version:	0.0.12
		Date:		29/8/2002
		(Assembly and) Dissassembly functions 
*/

/* This code is property of Charles Brej  and is used in this project 
									with his permission */
#include "exp.h"
#include "chump.h"
#include "dotparse.h"
#include "lint.h"
#include "symboltable.h"
#include <glib.h>
#include <string.h>
#include <ctype.h>

char* dis_error_string="ERROR";
const AsmStatus asm_default_status = {NULL, 0, 0, 30};
          // Symbol* symbol_table, long address, int flags;




DefinitionStack *asm_parser (GList * list)          // Pass the parsed list to tis function with the name as the first element
{                                                   // isa     "ARM32"  (define "reg" ....
	if (!SCAN_IS_STRING (SCAN_LIST_FIRST (list))){   //      ^ start
        g_print ("line:%d position:%d  Expected string to define the disassembly\n",
            SCAN_LIST_FIRST (list)->line, SCAN_LIST_FIRST (list)->position);
        return NULL;
    	}
	return asm_define (list->next, NULL, SCAN_STRING (SCAN_NODE (list->data)));
}


DefinitionStack *asm_define (GList * parselist, DefinitionStack * deflist, char *name)
{               //          the list of defines,  a stack of prevous defines,  name of current define
    DefinitionStack *definitionelement = g_new (DefinitionStack, 1);  // create our new define
    DefinitionStack *definitionstack = definitionelement;             // this is the stack with our new element on top
    DefinitionStack *deflisttemp;
    GList *sublist;

    definitionelement->next = deflist;
    definitionelement->rules = g_list_append(NULL, NULL); //make a dummy list
    definitionelement->string = name;
    
    while (parselist)                                               // walk through the input list
	{


		if (SCAN_IS_LIST ((PtrSCANNode) parselist->data))           // form (define "X" (...
		{
			sublist = ((PtrSCANNode) parselist->data)->body.list;   // take a look at the sublist
			if (!sublist)
			{
				g_print ("line:%d position:%d  Empty list when defining '%s'\n",    // sublist is empty!!! panic!!!
					((PtrSCANNode) parselist->data)->line, ((PtrSCANNode) parselist->data)->position, name);
				return definitionelement;
			}

			if (!sublist->next)                                          // sublist has only one element!!! panic!!!
			{
				g_print ("line:%d position:%d  List of only 1 element when defining '%s'\n",
					((PtrSCANNode) parselist->data)->line, ((PtrSCANNode) parselist->data)->position, name);
				return definitionelement;
			}

			if (SCAN_IS_SYMBOL ((PtrSCANNode) sublist->data) &&     // form (define "X" (define ...
				SCAN_IS_STRING ((PtrSCANNode) sublist->next->data) &&
				!g_strcasecmp (((PtrSCANNode) sublist->data)->body.string, DEFINITIONSTRING))
				        definitionstack = asm_define (sublist->next->next, definitionstack,     // stick the define on the stack 
					        ((PtrSCANNode) sublist->next->data)->body.string);                  // recursively
			else if (SCAN_IS_SYMBOL ((PtrSCANNode) sublist->data) &&     // form (define "X" (enum ...
				      SCAN_IS_NUMBER ((PtrSCANNode) sublist->next->data) &&
				      !g_strcasecmp (((PtrSCANNode) sublist->data)->body.string, ENUMERATESTRING)) {
                int size, number, temp;
                GList* aliaslist=NULL;
                char* newstring;
                Rule *rule;
                RuleElement *element;
                number=0;
                sublist = sublist->next;
                size = SCAN_NUMBER(SCAN_LIST_FIRST(sublist));
                sublist = sublist->next;
                while (sublist){
                    if (SCAN_IS_LIST(SCAN_LIST_FIRST(sublist)) && !aliaslist)
                        aliaslist = SCAN_LIST(SCAN_LIST_FIRST(sublist));
                    if (!SCAN_IS_STRING(SCAN_LIST_FIRST(sublist)) && !SCAN_IS_LIST(SCAN_LIST_FIRST(sublist))){
                        g_print ("line:%d position:%d  Enum lists should be created using only \"strings\" \n",
					                    ((PtrSCANNode) sublist->data)->line, ((PtrSCANNode) sublist->data)->position);
                        break;
                        }
                    if (aliaslist)  {
                        newstring = SCAN_STRING(SCAN_LIST_FIRST(aliaslist));
                        }

                    else {
                        newstring = SCAN_STRING(SCAN_LIST_FIRST(sublist));
                        }
                        
                    
                    rule = g_new(Rule,1);
                    rule->type = TRANRULE;
                    element = g_new(RuleElement,1);
                    element->string = newstring;
                    element->type = TERM;
                    element->twin=0;
                    element->twinsplit=0;
                    element->split=NULL;
                    element->rules=NULL;
                    rule->asci = g_list_append(NULL,element);
                    element = g_new(RuleElement,1);
                    element->string = g_new(char, size+1);
                    temp=size;
                    element->string[size]='\0';
                    while (temp--){
                        if (number & 1<<temp)   element->string[size-temp-1]='I';
                        else                    element->string[size-temp-1]='O';
                        }
                    element->type = TERM;
                    element->twin=0;
                    element->twinsplit=0;
                    element->split=NULL;
                    element->rules=NULL;
                    rule->bit = g_list_append(NULL,element);
                    if (definitionelement->rules->data)
        				    definitionelement->rules = g_list_append (definitionelement->rules, rule);      // add it to the rules
                    else    definitionelement->rules->data = rule;                                          // replace dummy list

                    if (aliaslist) 
                        aliaslist = aliaslist->next;
                    if (!aliaslist) {
                        sublist = sublist->next;
                        number++;
                        }
                    }
                }
                        
            else                                                    // form (define "X" (( Y ...
                if (definitionelement->rules->data)
                        definitionelement->rules = g_list_append (definitionelement->rules, asm_rule (sublist, definitionstack));      // add it to the rules
                else    definitionelement->rules->data = asm_rule (sublist, definitionstack);                                          // replace dummy list
		}


		if (SCAN_IS_SYMBOL ((PtrSCANNode) parselist->data))         // form (define "X" Y)
		{
			deflisttemp = definitionstack;
			while (g_strcasecmp (((PtrSCANNode) parselist->data)->body.string, deflisttemp->string))    // fook for the name of the stack
			{
				deflisttemp = deflisttemp->next;
				if (!deflisttemp)                       // we go to the end of the list and still didnt find it! panic!!!
				{
					g_print ("line:%d position:%d  '%s' has not been defined\n",
						((PtrSCANNode) parselist->data)->line,
						((PtrSCANNode) parselist->data)->position, ((PtrSCANNode) parselist->data)->body.string);
					return definitionelement;
				}
			}
            if (definitionelement->rules->data)
                    definitionelement->rules = g_list_concat (definitionelement->rules, g_list_copy (deflisttemp->rules));      // add them the rules
            else    {
                    definitionelement->rules->data = deflisttemp->rules->data;                                                  // replace dummy list
                    definitionelement->rules = g_list_concat (definitionelement->rules, g_list_copy (deflisttemp->rules->next));      // add them the rules
                    }
		}                                           // copy the rules from the original to the current rules
		parselist = parselist->next;                // NEXT!
	}

	                    //should free all elements above the definition stack
	deflisttemp = definitionstack;
	while (definitionstack != definitionelement)
	{
		deflisttemp = definitionstack;
		definitionstack = definitionstack->next;        // do it proper!! losing a bit or mem during definition time. fixme
		g_free (deflisttemp);
	}

	return definitionelement;
}

Rule *asm_rule (GList * parselist, DefinitionStack * deflist)
//              parsed list      , definition stack 
{   //      form ((ascii)(binary))  or  ( int 7 + 4 )

	Rule *rule = g_new (Rule, 1);   //make new rule
	RuleElement *belement, *telement;
	GList *text;
	GList *binary;
	DefinitionStack *deflisttemp;
	GList *binarytemp;
	char *legaltest;
    SplitElement *split;

	rule->asci = NULL;      // initialise new rule
	rule->bit = NULL;
	rule->type = TRANRULE;
    
	if (SCAN_IS_SYMBOL ((PtrSCANNode) parselist->data))     // form ( int ...
	{
		if (!g_strcasecmp (((PtrSCANNode) parselist->data)->body.string, INTIGERSTRING))    // test for int, relative ...
			rule->type = INTRULE;
		if (!g_strcasecmp (((PtrSCANNode) parselist->data)->body.string, RELATIVESTRING))
			rule->type = RELATIVERULE;
		if (!g_strcasecmp (((PtrSCANNode) parselist->data)->body.string, UINTIGERSTRING))
			rule->type = UINTRULE;
		if (!g_strcasecmp (((PtrSCANNode) parselist->data)->body.string, URELATIVESTRING))
			rule->type = URELATIVERULE;
		if (!g_strcasecmp (((PtrSCANNode) parselist->data)->body.string, LABELSTRING)){
			rule->type = LABELRULE;
            return rule;                                                                    // Its a label definition but there are other fields to use
            }
		if (!g_strcasecmp (((PtrSCANNode) parselist->data)->body.string, COMMENTSTRING)){
			rule->type = COMMENTRULE;
            return rule;                                                                    // Its a comment definition but there are other fields to use
            }
		if (!g_strcasecmp (((PtrSCANNode) parselist->data)->body.string, ALIGNSTRING)){
			rule->type = ALIGNRULE;
            parselist = parselist->next;
            rule->size = 0;
            if (!SCAN_IS_NUMBER ((PtrSCANNode) parselist->data)) {
			    g_print ("line:%d position:%d  ALIGN rules take a number as a paramiter\n",
				    ((PtrSCANNode) parselist->data)->line, ((PtrSCANNode) parselist->data)->position);
                return rule;
                }
            rule->size = ((PtrSCANNode) parselist->data)->body.number;
            return rule;                                                                    // Its a align definition but there are other fields to use
            }
		if (!g_strcasecmp (((PtrSCANNode) parselist->data)->body.string, ASCIISTRING)){
			rule->type = ASCIIRULE;
            while ((parselist = parselist->next)){
		        if (!SCAN_IS_STRING ((PtrSCANNode) parselist->data)) {
			        g_print ("line:%d position:%d  ASCII rules take a list of strings as paramiters\n",
				        ((PtrSCANNode) parselist->data)->line, ((PtrSCANNode) parselist->data)->position);
                    return rule;
                    }
		        rule->asci = g_list_append (rule->asci, ((PtrSCANNode) parselist->data)->body.string);
                }
            
            return rule;
            }
            
		if (TRANRULE == rule->type)             // didnt match any of them!!! panic!!!
		{
			g_print ("line:%d position:%d  Only 'int' and 'relative' are valid rules \n",
				((PtrSCANNode) parselist->data)->line, ((PtrSCANNode) parselist->data)->position);
			return rule;
		}
        
		parselist = parselist->next;           // start working through operands

		if (!SCAN_IS_NUMBER ((PtrSCANNode) parselist->data)) // no size specified!!! panic!!!
		{
			g_print ("line:%d position:%d  Int and float rules need a size as the first operand \n",
				((PtrSCANNode) parselist->data)->line, ((PtrSCANNode) parselist->data)->position);
			return rule;
		}

		rule->bit = g_list_append (rule->bit, GINT_TO_POINTER (((PtrSCANNode) parselist->data)->body.number));
		parselist = parselist->next;            // stick size as the first element of bitlist
		while (parselist)                       // walk through rest
		{
			if (!parselist->next)               // if each operand needs a number!!! panic!!!
			{
				g_print
					("line:%d position:%d  Int and float rules need mathematical operations in sepperated pairs eg: + 4 * 8\n",
					((PtrSCANNode) parselist->data)->line, ((PtrSCANNode) parselist->data)->position);
				return rule;
			}

			if (!SCAN_IS_SYMBOL ((PtrSCANNode) parselist->data) ||
				!SCAN_IS_NUMBER ((PtrSCANNode) parselist->next->data))      // ensure its an operator followed by a number
			{
				g_print                                                     // else panic!!!
					("line:%d position:%d  Int and float rules need mathematical operations in sepperated pairs eg: + 4 * 8\n",
					((PtrSCANNode) parselist->data)->line, ((PtrSCANNode) parselist->data)->position);
				return rule;
			}

			rule->asci = g_list_append (rule->asci, ((PtrSCANNode) parselist->data)->body.string);  // stick the symbol and number on the lists
			rule->bit = g_list_append (rule->bit, GINT_TO_POINTER (((PtrSCANNode) parselist->next->data)->body.number));
			parselist = parselist->next->next;      // move two forward
		}
		return rule;
	}

                                // form ((asm)(bin))
	rule->type = TRANRULE;
	if (parselist->next->next ||
		!SCAN_IS_LIST ((PtrSCANNode) parselist->data) || !SCAN_IS_LIST ((PtrSCANNode) parselist->next->data))
	{
		g_print ("line:%d position:%d  A rule must have two LISTS! \n",
			((PtrSCANNode) parselist->data)->line, ((PtrSCANNode) parselist->data)->position);
		return rule;
	}                       // ensure two lists exist else panic!!!
    
	text = SCAN_NODE (parselist->data)->body.list;
	binary = SCAN_NODE (parselist->next->data)->body.list;
	while (binary)          // walk throug binary list
	{
	    belement = g_new (RuleElement, 1);      //create an element
	    if (!SCAN_IS_SYMBOL (SCAN_NODE (binary->data)) && !SCAN_IS_STRING (SCAN_NODE (binary->data)))     // binary sections have to be made from symbols or strings
		{                                                   // if the're not then panic!!!
			g_print
				("line:%d position:%d  A rule binary field must be made from characters IOXZ or a number starting with '#'\n",
				((PtrSCANNode) binary->data)->line, ((PtrSCANNode) binary->data)->position);
			return rule;
		}
		belement->type = TERM;                                      // make it into a term for now
		belement->string = SCAN_NODE (binary->data)->body.string;
		rule->bit = g_list_append (rule->bit, (gpointer) belement); // add it to the list
		binary = binary->next;
	}

	while (text)                    // now walk through the text
	{
		telement = g_new (RuleElement, 1);          // add a new element
		rule->asci = g_list_append (rule->asci, (gpointer) telement);       // add it to the list

		switch (((PtrSCANNode) text->data)->type)       // what type of element is it?
		{
        
		case SCANString:                                // its a terminal eg "add"
			telement->string = SCAN_NODE (text->data)->body.string;
			telement->type = TERM;                      // just add the string then 
			break;

		case SCANList:                                  // its an inline definition
            telement->type = SPLITNONTERM;
            telement->split = NULL;
			if (!SCAN_LIST(SCAN_LIST_FIRST(text)))
			{
				g_print ("line:%d position:%d  Rule must have a body \n",        // ensure the list has a body, else panic!!!
					((PtrSCANNode) text->data)->line, ((PtrSCANNode) text->data)->position);
				return rule;
			}
			if (SCAN_IS_SYMBOL (SCAN_LIST_FIRST(SCAN_LIST(SCAN_LIST_FIRST(text)))))   // ensure the definition is in quotes, else panic!!!
			{
				g_print ("line:%d position:%d  '%s' should be a in quotes\n",
					((PtrSCANNode) text->data)->line,
					((PtrSCANNode) text->data)->position,
					(SCAN_NODE (SCAN_NODE (text->data)->body.list->data))->body.string);
				return rule;
			}
            
 			if (SCAN_IS_NUMBER (SCAN_LIST_FIRST(SCAN_LIST(SCAN_LIST_FIRST(text)))))   // ensure the definition is in quotes, else panic!!!
			{
				g_print ("line:%d position:%d  A rule should start with a string and not a number\n",
					((PtrSCANNode) text->data)->line,
					((PtrSCANNode) text->data)->position);
				return rule;
			}
           
            

			if (SCAN_IS_LIST (SCAN_LIST_FIRST(SCAN_LIST(SCAN_LIST_FIRST(text)))))  
			{
                binary = SCAN_LIST(SCAN_LIST_FIRST(SCAN_LIST(SCAN_LIST_FIRST(text))));
                if (!binary) {
        				g_print ("line:%d position:%d  The rule entry seems to be an empty list! I have no idea what to do with this!\n",
        					SCAN_LIST_FIRST(text)->line,
		        			SCAN_LIST_FIRST(text)->position);
				        return rule;
            			}
                
                telement->string = "";              // define the string as null as its a split
    			deflisttemp = asm_define (SCAN_LIST_REST(SCAN_LIST(SCAN_LIST_FIRST(text))), deflist, "");  // work out its defenition 
			    telement->rules = deflisttemp->rules;
                g_free(deflisttemp);


                while (binary) {                // walk through the split list
                        if (!SCAN_IS_LIST (SCAN_LIST_FIRST(binary))) {
            				g_print ("line:%d position:%d  The rule split sub list seems to have non list entrys\n",
            					((PtrSCANNode) binary->data)->line,
		            			((PtrSCANNode) binary->data)->position);
				            return rule;
            			    }
                            
                        if (!SCAN_IS_STRING(SCAN_LIST_FIRST(SCAN_LIST(SCAN_LIST_FIRST(binary))))) {
            				g_print ("line:%d position:%d  The split rule parts should be in form: name string followed by size number\n",
            					((PtrSCANNode) binary->data)->line,
		            			((PtrSCANNode) binary->data)->position);
				            return rule;
            			    }
                            
                        if (!SCAN_IS_NUMBER(SCAN_LIST_SECOND(SCAN_LIST(SCAN_LIST_FIRST(binary))))) {
            				g_print ("line:%d position:%d  The split rule parts should be in form: name string followed by size number\n",
            					((PtrSCANNode) binary->data)->line,
		            			((PtrSCANNode) binary->data)->position);
				            return rule;
            			    }
                            
                        
                        split = g_new(SplitElement,1);
                        telement->split= g_list_append (telement->split, split);

                        split->string = SCAN_STRING(SCAN_LIST_FIRST (SCAN_LIST(SCAN_LIST_FIRST(binary))));
                        split->size =   SCAN_NUMBER(SCAN_LIST_SECOND(SCAN_LIST(SCAN_LIST_FIRST(binary))));
                        split->type =   SPLIT;

        	    		binarytemp = rule->bit;
        		    	while (g_strcasecmp (split->string, ((RuleElement *) binarytemp->data)->string)) {   // find its twin in the binary section
		        		    
                            if (!binarytemp->next)  {                               // we havent found it! panic!!!
	                            g_print ("line:%d position:%d  '%s' needs to be in the binary section too\n",
		    		                ((PtrSCANNode) text->data)->line, ((PtrSCANNode) text->data)->position, telement->string);
			    	            return rule;
        				        }
                            
            				binarytemp = binarytemp->next;          //next!
	            		    }

                       
  		    	        split->twin = g_list_position (rule->bit, binarytemp);

                        ((RuleElement *) binarytemp->data)->twin = g_list_index (rule->asci, telement);     //connect the twins 
                        ((RuleElement *) binarytemp->data)->twinsplit = g_list_index (telement->split, split);
                        ((RuleElement *) binarytemp->data)->type = NONTERM;
                        ((RuleElement *) binarytemp->data)->rules = telement->rules;
                        
                        binary=binary->next;
                        }
                break;
			}


			if (SCAN_IS_STRING (SCAN_LIST_FIRST(SCAN_LIST(SCAN_LIST_FIRST(text))))) {
                telement->string = SCAN_NODE (SCAN_NODE (text->data)->body.list->data)->body.string;            // define the string 
    			deflisttemp = asm_define (SCAN_LIST_REST(SCAN_LIST(SCAN_LIST_FIRST(text))), deflist, telement->string);  // work out its defenition 

	    		binarytemp = rule->bit;
		    	while (g_strcasecmp (telement->string, ((RuleElement *) binarytemp->data)->string)) {   // find its twin in the binary section
				    if (!binarytemp->next) {                                // we havent found it! panic!!!
	                    g_print ("line:%d position:%d  '%s' needs to be in the binary section too\n",
		    		        ((PtrSCANNode) text->data)->line, ((PtrSCANNode) text->data)->position, telement->string);
			    	    return rule;
    				    }
    				binarytemp = binarytemp->next;          //next!
    	    		}
                    
		    	((RuleElement *) binarytemp->data)->type = NONTERM;     // correct the binary definition as its a 'nonterm'
			    telement->type = NONTERM;                               // as is our current element
    			telement->split = NULL;
	    		((RuleElement *) binarytemp->data)->split = NULL;
		    	((RuleElement *) binarytemp->data)->rules = deflisttemp->rules; //deflisttemp->rules are our rules for this nonterm
			    telement->rules = deflisttemp->rules;                           // on both sides
    			((RuleElement *) binarytemp->data)->twin = g_list_index (rule->asci, telement);     //connect the twins
                ((RuleElement *) binarytemp->data)->twinsplit = 0;
		    	telement->twin = g_list_position (rule->bit, binarytemp);                           // together
			    g_free (deflisttemp);                                       // this desnt really cut it. fixme
    			break;
                }

		case SCANSymbol:                                                // its a symbol 
			telement->string = SCAN_NODE (text->data)->body.string;
			deflisttemp = deflist;
			while (g_strcasecmp (telement->string, deflisttemp->string))    // find its definition on the stack
			{
				deflisttemp = deflisttemp->next;
				if (!deflisttemp)
				{
					g_print ("line:%d position:%d  '%s' has not been defined\n",        // no definition found. panic!!!
						((PtrSCANNode) text->data)->line, ((PtrSCANNode) text->data)->position, telement->string);
					return rule;
				}
			}

			binarytemp = rule->bit;
			while (g_strcasecmp (telement->string, ((RuleElement *) binarytemp->data)->string))
			{
				binarytemp = binarytemp->next;                          // find its twin
				if (!binarytemp)
				{
					g_print ("line:%d position:%d  '%s' needs to be in the binary section too\n",   // no twin found
						((PtrSCANNode) text->data)->line, ((PtrSCANNode) text->data)->position, telement->string);
					return rule;
				}
			}
			((RuleElement *) binarytemp->data)->type = NONTERM;     // correct the binary definition as its a 'nonterm'
			telement->type = NONTERM;                               // as is our current element
			((RuleElement *) binarytemp->data)->rules = deflisttemp->rules; //deflisttemp->rules are our rules for this nonterm
			telement->rules = deflisttemp->rules;                           // on both sides
			((RuleElement *) binarytemp->data)->twin = g_list_index (rule->asci, telement);     //connect the twins
			telement->twin = g_list_position (rule->bit, binarytemp);                           // together
            
			break;
		default:
			g_print ("line:%d position:%d  unexpected thing!\n",            // well its not a list string or symbol so panic!!!
				((PtrSCANNode) parselist->data)->line, ((PtrSCANNode) parselist->data)->position);
			return rule;
		}
		text = text->next;      // next text!
	}
    
    
	binary = rule->bit;
	while (binary)              // walk through the binary (again sortof)
	{
		if (TERM == ((RuleElement *) binary->data)->type)       //if its a term then ensure its a good one
		{
			legaltest = ((RuleElement *) binary->data)->string; 
			if ('#' == *legaltest)
			{
				legaltest++;
				((RuleElement *) binary->data)->string = legaltest; // if its starts with a # then advance by 1
			}
			while (*legaltest)          // convert 1s to Is and 0s to Os
			{
				if ('1' == *legaltest)
					*legaltest = 'I';
				if ('0' == *legaltest)
					*legaltest = 'O';
				legaltest++;
			}
			legaltest = ((RuleElement *) binary->data)->string;     // test if all characters are legal
			while (*legaltest)
			{
				if ('I' != *legaltest && 'O' != *legaltest && 'Z' != *legaltest && 'X' != *legaltest)  // if not valid then panic!!!
				{
					g_print
						("line:%d position:%d  This rule's binary field contains '%s' which is not a valid binary value nor is it in the text field\n",
						((PtrSCANNode) parselist->data)->line, ((PtrSCANNode) parselist->data)->position,
						((RuleElement *) binary->data)->string);
					break;
				}
				legaltest++;
			}
		}
		binary = binary->next; // next!
	}
	return rule;        //when done return rule
}




Disasm asm_disassemble_number (char* bitfield, GList * rules, AsmStatus stat)
//                  list of binary, list of rules, status
{
 Disasm ret;
 Disasm error;
 char* binary;
 char *c;
 int bitcount;
 int flag = 0;
 RuleElement *newelement;
 Lint numbera;
 Lint size;
 Symbol* tempsymbol;
    
 error.distext = &dis_error;         // error dissasembly
 error.bitfield = dis_error_string;
 ret.bitfield = bitfield;
 
 bitcount = (int)((Rule *) rules->data)->bit->data;
 if (bitcount > strlen(bitfield)) return error;                         // if its longer than the numbera
 binary =  &ret.bitfield[bitcount - 1];                                 // of bits fetched then error out
                                                                        // walk through the binary backwards
 if (asm_isset(*binary)){                                               // if its signed then the first bit means the sign
    if (    UINTRULE      == ((Rule *) rules->data)->type
         || URELATIVERULE == ((Rule *) rules->data)->type)  numbera = lint_new( 1);
    else                                                    numbera = lint_new(-1); // numbera is the accumulator
    }
 else                                                       numbera = lint_new( 0);
    
 while (binary != ret.bitfield) {                                           // walk backwards
    binary--;
    numbera = lint_operate(numbera, lint_new(1), LINT_SL);
    if (asm_isset(*binary)) numbera = lint_operate(numbera, lint_new(1), LINT_OR);    // keep orring and shifting
	}                                                                               // create a lint number from a binary string

 {
    GList *number = g_list_last (((Rule *) rules->data)->bit);          // apply operations from end 
    GList *opp    = g_list_last (((Rule *) rules->data)->asci);
    Lint imm;
    while(opp){                                         // all opertions
        imm = lint_new(GPOINTER_TO_INT(number->data));  // imm is the operand
        c = (char*)opp->data;                           // c points to the operator
        switch (*c){							        // if not inverted then just do normal inverse operations
            case '+':
                numbera = lint_operate(numbera, imm, LINT_SUB);
                break;
                    
            case '~':
                numbera = lint_operate(imm, numbera, LINT_SUB);
                break;

            case '-':
                numbera = lint_operate(numbera, imm, LINT_ADD);
                break;
            
            case '*':
                numbera = lint_operate(numbera, imm, LINT_DIV);
                break;
                    
            case '/':
                numbera = lint_operate(numbera, imm, LINT_MUL);
                break;
            
            case '>':
                numbera = lint_operate(numbera, imm, LINT_SL);
                break;

            case '<':
                numbera = lint_operate(numbera, imm, LINT_SR);
                break;
                                
            case '@':
                c++;
                size = lint_from_string(c,&c);
                if (lint_compare(numbera,lint_operate (lint_new(1),  size,   LINT_SL)) >= 0) {flag = 1;break;}          // FIXME rotating negative numbers?
                numbera = lint_operate (lint_operate (numbera, imm, LINT_SR), lint_operate (numbera, lint_operate(size, imm, LINT_SUB), LINT_SL), LINT_OR);
                numbera = lint_operate (numbera, lint_operate (lint_operate (lint_new(1), size, LINT_SL), lint_new(1), LINT_SUB), LINT_AND);
                break;

            default:
                break;
            }
        if (flag) break;
        opp=opp->prev;              // next operation!
        number=number->prev;
        }
 }


 if (    (RELATIVERULE == ((Rule *) rules->data)->type)     // if its a relative rule then add the address
     || (URELATIVERULE == ((Rule *) rules->data)->type)) numbera = lint_operate(numbera, lint_new(stat.address), LINT_ADD);

 ret.bitfield = &ret.bitfield[bitcount];                    // advance bitfield forward
 
 newelement = g_new (RuleElement, 1);
 
 tempsymbol = symbol_findaddress (stat.symbol_table, numbera);
 if (tempsymbol) c = tempsymbol->name;
 else            c = NULL;
 if (c && (    (RELATIVERULE == ((Rule *) rules->data)->type)
           || (URELATIVERULE == ((Rule *) rules->data)->type)))
        newelement->string = g_strdup(c);
 else   newelement->string = g_strdup_printf ("0x%lX", lint_to_longlong(numbera));    // make a new element which will be freed later
 
 newelement->type = TERM2FREE;                           // and sick our number into it
 ret.distext = g_list_append (NULL, newelement);         // add it to the return text text
 return ret;                                             // and return
}



Disasm asm_disassemble_label (char* bitfield, GList * rules, AsmStatus stat)
//                  list of binary, list of rules, status
{
 Disasm ret;
 RuleElement *newelement;
 ret.bitfield = bitfield;
 Symbol* symbol;
 
 
 symbol = symbol_findaddress (stat.symbol_table, lint_new(stat.address));
 if  (!symbol) return (Disasm) {&dis_error,dis_error_string};
 newelement = g_new (RuleElement, 1); 
 newelement->string = g_strdup (symbol->name);   // make a new element which will be freed later
 newelement->type = TERM2FREE;                           // and sick our number into it
 ret.distext = g_list_append (NULL, newelement);         // add it to the return text text
 return ret;                                             // and return
}



Disasm asm_disassemble_ascii (char* bitfield, GList * rules, AsmStatus stat)
//                  list of binary, list of rules, status
{
 Disasm ret;
 RuleElement *newelement;
 unsigned char c=0;
 int x;
 char string[] = {0,0,0,0,0,0};
 
 ret.bitfield = bitfield;
 for (x = 0; x < 8; x++){
    if (!(*(ret.bitfield))) return (Disasm) {&dis_error,dis_error_string};
    if (asm_isset(*ret.bitfield))   c = c | 1<<x;
    ret.bitfield++;
    }
 switch (c){
    case '\b':
        string[0]='\\';
        string[1]='b';
        break;
    case '\f':
        string[0]='\\';
        string[1]='f';
        break;
    case '\n':
        string[0]='\\';
        string[1]='n';
        break;
    case '\r':
        string[0]='\\';
        string[1]='r';
        break;
    case '\t':
        string[0]='\\';
        string[1]='t';
        break;
    case '\\':
        string[0]='\\';
        string[1]='\\';
        break;
    case '\"':
        string[0]='\\';
        string[1]='\"';
        break;
    case '\0':
        string[0]='\\';
        string[1]='0';
        break;
    default:
        if (c<0x20 || c>0x7F) {
            string[0]='\\';
            string[1]= ((c>>6)&7)+'0';
            string[2]= ((c>>3)&7)+'0';
            string[3]=  (c    &7)+'0';
            }
        else string[0]=c;
    }
 
 newelement = g_new (RuleElement, 1); 
 newelement->string = g_strdup(string);
 newelement->type = TERM2FREE;                           
 ret.distext = g_list_append (NULL, newelement);         // add it to the return text
 return ret;                                             // and return
}





Disasm asm_disassemble (char* bitfield, GList* rules, AsmStatus stat)
//                  list of binary, list of rules, status
{
	Disasm ret;
	Disasm rep;
	Disasm error;
	GList *binary;
	char *c;
	RuleElement *newelement;
	unsigned int flag;
    unsigned int size;
    
	error.distext = &dis_error;         // error dissasembly
	error.bitfield = dis_error_string;

    if (!stat.limit) return error;
    stat.limit--;
    
	while (rules) {                     // walk through rules given
     switch (((Rule *) rules->data)->type) {
       case INTRULE:
       case RELATIVERULE:
       case UINTRULE:
       case URELATIVERULE:
        rep = asm_disassemble_number (bitfield, rules, stat);
  	    if (dis_error_string != rep.bitfield)      // if replay was OK then return
       	    return rep;
        break;
        
       case TRANRULE :
		ret.bitfield = bitfield;
		binary = g_list_last (((Rule *) rules->data)->bit);         // these are translation rules
		ret.distext = g_list_copy (((Rule *) rules->data)->asci);   // ret.distext is now a copy of the contents of the translation

		while (1){
			flag = 0;
			if (!binary) return ret;                                    // if no binary then we are done
			if (NONTERM == ((RuleElement *) binary->data)->type) {      // its a non-terminal
                if (SPLITNONTERM == ((RuleElement *)g_list_nth_data (ret.distext, ((RuleElement *) binary->data)->twin))->type){
					newelement = g_new (RuleElement, 1);            // make a new rule
					newelement->rules = NULL; 
//                    g_print("%x %x %x\n",newelement->rules->data, newelement->rules->next, newelement->rules->prev);
					newelement->type = SPLITNONTERM2FREE;                // stick it into the reply
                    newelement->split = g_list_copy(((RuleElement *)g_list_nth_data (ret.distext, ((RuleElement *) binary->data)->twin))->split);
					(g_list_nth (ret.distext, ((RuleElement *) binary->data)->twin))->data = (gpointer) newelement;
//                    g_print("1\n");
                    }

                if (SPLITNONTERM2FREE == ((RuleElement *)(g_list_nth_data (ret.distext, ((RuleElement *) binary->data)->twin)))->type){
                    SplitElement* newsplit = g_new(SplitElement,1);
                    RuleElement* rule = (RuleElement*) g_list_nth_data (ret.distext, ((RuleElement *) binary->data)->twin);
                    GList* splitlist;
                    char *splitbitfield, *oldsplitbitfield;
                    newsplit->type = SPLIT2FREE;
                    newsplit->size = ((SplitElement*)  g_list_nth_data (rule->split, ((RuleElement *) binary->data)->twinsplit))->size;
                    newsplit->string = ((SplitElement*)  g_list_nth_data (rule->split, ((RuleElement *) binary->data)->twinsplit))->string;
                    newsplit->bitfield = NULL;
                    g_list_nth (rule->split, ((RuleElement *) binary->data)->twinsplit)->data = newsplit;
                    newsplit->bitfield =  g_strnfill(newsplit->size, '?');
                    for(size=0; size < newsplit->size; size++){
                        if (!*ret.bitfield) {flag=1; break;}
                        newsplit->bitfield[size] = *ret.bitfield;
        	            ret.bitfield++;
                        }
                    if (flag) break;
                    splitlist=rule->split;
                    while (splitlist && SPLIT2FREE == ((SplitElement*)splitlist->data)->type) {
                        splitlist=splitlist->next;
                        }
                    if (!splitlist) {
                        splitlist=rule->split;
                        splitbitfield=g_strdup("");
                        while (splitlist) {
                            oldsplitbitfield = splitbitfield; 
                            splitbitfield = g_strconcat(((SplitElement*)splitlist->data)->bitfield, splitbitfield, NULL);
                            g_free(oldsplitbitfield);
                            splitlist=splitlist->next;
                            }
                        rep = asm_disassemble (splitbitfield, ((RuleElement *) binary->data)->rules, stat);   // in that case disassable it
                        g_free(splitbitfield);
    	    		    if (dis_error_string != rep.bitfield && !*rep.bitfield)    // if replay was OK then
		        	               rule->rules = rep.distext;                      // make a nonterm which will be freed
                        
                        else { flag = 1;}                                    // if replay was an error then flag for try next rule
                        }
                    }
                else {
                 
    				rep = asm_disassemble (ret.bitfield, ((RuleElement *) binary->data)->rules, stat);   // in that case disassable it
	    			if (dis_error_string != rep.bitfield) {                   // if replay was OK then
    					ret.bitfield = rep.bitfield;                    // advance bitfield
	    				newelement = g_new (RuleElement, 1);            // make a new rule
		    			newelement->rules = rep.distext;                // make a nonterm which will be freed
			    		newelement->type = NONTERM2FREE;                // stick it into the reply
				    	(g_list_nth (ret.distext, ((RuleElement *) binary->data)->twin))->data = (gpointer) newelement;
        				}
                    else  flag = 1;                                       // if replay was an error then flag for try next rule
                    }
			}
            else {
				c = (char *) ((RuleElement *) binary->data)->string;    // if it was a terminal
				while (*c)                                              // goto end of the binary term
					c++;
                if (*ret.bitfield)                                       // 
				 while (((RuleElement *) binary->data)->string != c)    // ensure it matches
				 {
					c--;
					if (*ret.bitfield){
                     if ('I' == *c && !asm_isset(*ret.bitfield))    // if doesnt match then flag=1
						 flag = 1;
					 if ('O' == *c && asm_isset(*ret.bitfield))
						 flag = 1;
					 ret.bitfield++;
                     }
                    else flag = 1;          // if ret.bitfield runs out then try another
				 }
                else flag = 1;
                 
		        }
		    if (flag) break;                    // if flag is up then break free and try next rule
		    binary = binary->prev;              // else keep going through current
            }
        asm_freestringlist (ret.distext);
        break;
       
       case LABELRULE:
        rep = asm_disassemble_label (bitfield, rules, stat);
  	    if (dis_error_string != rep.bitfield)      // if replay was OK then return
       	        return rep;
        break;
        
       case COMMENTRULE:
 		ret.bitfield = bitfield;       
		ret.distext = NULL;
       	return ret;
        break;
        
       case ALIGNRULE:
        if (stat.address & (((Rule *) rules->data)->size - 1)) break;
 		ret.bitfield = bitfield;       
		ret.distext = NULL;
       	return ret;
        break;
        
       case ASCIIRULE:
        rep = asm_disassemble_ascii (bitfield, rules, stat);
  	    if (dis_error_string != rep.bitfield)      // if replay was OK then return
       	        return rep;
        break;
        
       default:
        g_print("ERROR: well its not a rule that I know of but its appeared when disassembling\n");
        break;
       }
        
	rules = rules->next;
	}
  return error;                       // if no rules matched then error
}




Asm* asm_assemble_number (char* text, GList* rules, AsmStatus stat, int last)
//               input text, rule list, addess, is ths the last rule?
{
 Asm *ret = g_new(Asm,1);
 RuleElement *newelement;
 int flag;
 Lint size;
 unsigned int bitcount;
 Lint value;
// int index;
 char* start;
 char* c;

 ret->text = text;
 flag=0;


 bitcount = (unsigned int) ((Rule *) rules->data)->bit->data;

 if (stat.flags & ASMFLAG_IGNORESYMBOLS)
    value = exp_exp(ret->text, &(ret->text), 0, symbol_extract_fake, stat.symbol_table);
 else
    value = exp_exp(ret->text, &(ret->text), 0, symbol_extract,      stat.symbol_table);
 if (!ret->text) {g_free(ret); return NULL;}


 if (    (RELATIVERULE == ((Rule *) rules->data)->type)
     || (URELATIVERULE == ((Rule *) rules->data)->type)) value = lint_operate (value, lint_new(stat.address), LINT_SUB); // if relative subtract address

 {
    GList *number = ((Rule *) rules->data)->bit->next;  // walk through the operations
    GList *opp = ((Rule *) rules->data)->asci;
    Lint imm;
    while(opp){
        imm=lint_new(GPOINTER_TO_INT (number->data));
        c = (char*)opp->data;
        switch (*c){
            case '~':
                value = lint_operate (imm, value, LINT_SUB);
                break;

            case '+':
                value = lint_operate (value, imm, LINT_ADD);
                break;
    
            case '-':
                value = lint_operate (value, imm, LINT_SUB);
                break;
            
            case '*':
                value = lint_operate (value, imm, LINT_MUL);
                break;
    
            case '/':
                if (lint_compare(lint_operate(value, imm, LINT_MOD), lint_new(0))) {flag = 1;break;};
                value = lint_operate (value, imm, LINT_DIV);
                break;
            
            case '>':
                if (lint_test(value, lint_operate(lint_operate(lint_new(1), imm, LINT_SL),lint_new(1), LINT_SUB))){flag = 1;break;}
                if (lint_compare(lint_operate(value,lint_operate (lint_new(1),  imm,   LINT_SL), LINT_OR), lint_new(0)))
                value = lint_operate (value, imm, LINT_SR);
                break;
                
            case '<':
                value = lint_operate (value, imm, LINT_SL);
                break;
                
            case '@':
                c++;
                size = lint_from_string(c,&c);
                if (lint_compare(value,lint_operate (lint_new(1),  size,   LINT_SL)) >= 0) {flag = 1;break;}
                value = lint_operate (lint_operate (value, imm, LINT_SL), lint_operate (value, lint_operate(size, imm, LINT_SUB), LINT_SR), LINT_OR);
                value = lint_operate (value, lint_operate (lint_operate (lint_new(1), size, LINT_SL), lint_new(1), LINT_SUB), LINT_AND);
                break;
                
            default:
                break;
            }
        if (flag) break;
        opp=opp->next;
        number=number->next;
        }
 }

 if ((RELATIVERULE == ((Rule *) rules->data)->type) ||
          (INTRULE == ((Rule *) rules->data)->type))
      { if (lint_compare(value,lint_operate (lint_new(1),  lint_new(bitcount-1), LINT_SL)) >= 0) flag = 1;  //TESTME ensure the ranges are correct   
        if (lint_compare(value,lint_operate (lint_new(-1), lint_new(bitcount-1), LINT_SL)) <  0) flag = 1;}
 else { if (lint_compare(value,lint_operate (lint_new(1),  lint_new(bitcount),   LINT_SL)) >= 0) flag = 1;
        if (lint_compare(value,lint_new(0))                                                <  0) flag = 1;}

 
 if (!flag) {											                // flag is set if something went wrong
        start = g_new(char,bitcount + 1);//make a new string
        c = start + bitcount;		     //terminate it with a \0
        *c = '\0';
        while(start != c--){                                            // write the string
            if (lint_test(value, lint_new(1))) *c = 'I';
            else                               *c = 'O';
            value = lint_operate(value, lint_new(1), LINT_SR);
            }
        newelement = g_new (RuleElement, 1);							// make a new rule
        newelement->string = start;
        newelement->type = TERM2FREE;									// make sure its freed afterwards
        ret->binary = g_list_append (NULL, newelement); 				// return the result in a list in ret->binary
        if (last) while (isblank(*ret->text)) ret->text++;				// if its last then walk through the rest of the spaces
        if (!last
            ||        !(*(ret->text)) 
            || '\n' == (*(ret->text)) ) {                               // unless its last and there is still chars to process then
            return ret;                                                 // return it
            }
        }
  g_free(ret);        
  return NULL;
}








Asm* asm_assemble_label (char* text, GList* rules, AsmStatus stat, int last)
//               input text, rule list, addess, is ths the last rule?
{
 Asm *ret = g_new(Asm,1);
 RuleElement *newelement;
 int size;

 ret->text = text;
 while (isblank(*ret->text)) ret->text++;         // skip spaces

 size = asm_getsymbol_length(ret->text);
 if (!size) {
    g_free(ret);
    return NULL;
    }

 newelement = g_new (RuleElement, 1);                           // make a new rule
 newelement->string = g_strndup(ret->text, size);
 ret->text +=size;
 
 newelement->type = LABEL2FREE;                                // make sure its freed afterwards
 ret->binary = g_list_append (NULL, newelement);                // return the result in a list in ret->binary
 if (last) while (isblank(*ret->text)) ret->text++;              // if its last then walk through the rest of the spaces
 if (!last
     ||        !(*(ret->text))
     || '\n' == (*(ret->text)) ) {                              // unless its last and there is still chars to process then
                return ret;                                     // return it
                }
  g_free(ret);
  return NULL;
}

Asm* asm_assemble_ascii (char* text, GList* rules, AsmStatus stat, int last)
//               input text, rule list, addess, is ths the last rule?
{
 Asm *ret;
 RuleElement *newelement;
 char c;
 char string[9]={0,0,0,0, 0,0,0,0, 0};
 int index;
 GList *strings    = ((Rule *) rules->data)->asci;

 while (strings){
    index=0;
    while (text[index] && ((char*)strings->data)[index] == text[index]){
        index++;
        if (!((char*)strings->data)[index]) return NULL;
        }
    strings=strings->next;
    }
 
 
 if (!*text || '\n' == *text) return NULL; 
 
 c = asm_getchar(text, &text);
 index=8;
 while (index--){
    if (c&1) string[index]='I';
    else     string[index]='O';
    c=c >> 1;
    }
 
 
 newelement = g_new (RuleElement, 1);                           // make a new rule
 newelement->type = TERM2FREE;
 newelement->string = g_strdup(string);
 
 ret = g_new(Asm,1);
 ret->text = text;
 ret->binary = g_list_append (NULL, newelement);                // return the result in a list in ret->binary
 return ret;

}




GList* asm_assemble (char* text, GList* rules, AsmStatus stat, int last)
//               input text, rule list, addess, is ths the last rule?
{
 Asm *ret = g_new(Asm,1);
 Asm *todo;
 GList *todolist=NULL;
 GList *retlist=NULL;
 GList *rep;
 RuleElement *newelement;
 RuleElement *newelement2;
 int flag;
 char* start;
 char* c;

 if (!stat.limit) return NULL;
 stat.limit--;
    
 while (rules){             // try out all rules
    flag=1;
    ret->text = text;




     switch (((Rule *) rules->data)->type) {
       case INTRULE:
       case RELATIVERULE:
       case UINTRULE:
       case URELATIVERULE:
          {
          Asm* numberasm= asm_assemble_number (text, rules, stat, last);
          if (numberasm) retlist = g_list_append(retlist,numberasm);						// add it to the list
          break;
          }
       case TRANRULE :                                                                      // its a translation rule
          ret->text = text;
          ret->ruletext=((Rule *) rules->data)->asci;					// keep a bit of state as to which rule we are looking at
          ret->binary = g_list_copy (((Rule *) rules->data)->bit);		// binary section is just a copy of the rule's binarys
        
		  while (1){
            flag = 0;
            start = ret->text;
            while (isblank(*(start))) start++;       					// move past the white spaces
            if (!ret->ruletext) {										// if we run out of rules
                      if (last && *(start) &&  (*(start) != '\n')) 						    // if its last and there is still text 
                            {asm_freestringlist (ret->binary);break;}	// then try another
                      else {retlist = g_list_append(retlist,ret); ret = g_new(Asm,1);break;} // else stick it on the retlist and try another
                      }
            
            
		    if (NONTERM == ((RuleElement *) ret->ruletext->data)->type){	// its a nonterm
//                while (isblank(*(ret->text))) ret->text++;					// skip spaces 
				rep = asm_assemble(ret->text, ((RuleElement *) ret->ruletext->data)->rules, stat, last && !ret->ruletext->next);
				// call recursively. text, rules , address, is it last?
				
 				if (rep){
                    ret->text = ((Asm*)rep->data)->text;	// did we get a reply?
 					newelement = g_new (RuleElement, 1);	// make a new element
 					newelement->rules = ((Asm*)rep->data)->binary; // point to the binary part of the reply
 					newelement->type = NONTERM2FREE;		// ensure its freed
                    
                    rep = rep->next;
                    while (rep) {							// is there more than one reply?
     					newelement2 = g_new (RuleElement, 1);	// make another element 
 	    				newelement2->rules = ((Asm*)rep->data)->binary;
 		    			newelement2->type = NONTERM2FREE;
                        todo=rep->data; 						// todo element
                        todo->ruletext=ret->ruletext;			// now points to the one from the one from the reply
						todo->binary=asm_copystringlist(ret->binary); // binary part of the reply is a copy of the current progress
 					    (g_list_nth (todo->binary, ((RuleElement *) todo->ruletext->data)->twin))->data = (gpointer) newelement2;
										// replace the twin of what we found with the nonterm
                        todolist=g_list_append(todolist,todo); // add it to the todo list
                        rep=rep->next;					// next!
                        }
 					(g_list_nth (ret->binary, ((RuleElement *) ret->ruletext->data)->twin))->data = (gpointer) newelement;
									// replace the twin with the our nonterm
				    }
                else  flag = 1; // if no reply then flag for quit
			    }

		    else if (SPLITNONTERM == ((RuleElement *) ret->ruletext->data)->type){	// its a splitnonterm
				rep = asm_assemble(ret->text, ((RuleElement *) ret->ruletext->data)->rules, stat, last && !ret->ruletext->next);
				// call recursively. text, rules , address, is it last?

 				if (rep){
                    GList* split;
                    GList* rep_first = rep;
                    ret->text = ((Asm*)rep->data)->text;
                    rep = rep->next;
                    while (rep) {							// is there more than one reply?
                        split = ((RuleElement *) ret->ruletext->data)->split;
                        start = c = asm_sprint (((Asm*)rep->data)->binary, g_strdup(""));
                        todo=rep->data; 						// todo element
                        todo->ruletext=ret->ruletext;			// now points to the one from the one from the reply
						todo->binary=asm_copystringlist(ret->binary); // binary part of the reply is a copy of the current progress
                        todolist=g_list_append(todolist,todo); // add it to the todo list
                        while (split){
                            int size = ((SplitElement *)split->data)->size;
                            newelement2 = g_new (RuleElement, 1);
 	    	    			newelement2->type = TERM2FREE;
                            newelement2->string = g_new (char, size + 1);
                            newelement2->string[size] = '\0';
                            while (size--)  newelement2->string[size] = c[size];
                            c += size;
     					    (g_list_nth (todo->binary, ((SplitElement *)split->data)->twin))->data = (gpointer) newelement2;
                            split=split->next;
                            }
                        rep=rep->next;					// next!
                        }
                    split = ((RuleElement *) ret->ruletext->data)->split;
                    start = c = asm_sprint (((Asm*)rep_first->data)->binary, g_strdup(""));
                    while (split){
                            int size = ((SplitElement *)split->data)->size;
                            newelement2 = g_new (RuleElement, 1);
 	    	    			newelement2->type = TERM2FREE;
                            newelement2->string = g_new (char, size + 1);
                            newelement2->string[size] = '\0';
                            while (size--)  newelement2->string[size] = c[size];
                            c += ((SplitElement *)split->data)->size;
     					    (g_list_nth (ret->binary, ((SplitElement *)split->data)->twin))->data = (gpointer) newelement2;
                            split=split->next;
                            }
				    }
                else  flag = 1; // if no reply then flag for quit
			    }


            else if (TERM == ((RuleElement *) ret->ruletext->data)->type) {              // its a term
				c = (char *) ((RuleElement *) ret->ruletext->data)->string;
                if ('\t' != *c)                 // non tabbed string
                  while (!flag){                // untill error
                    while (isblank(*c)) c++;     // skip spaces
                    if (!*c) break;             // end of rule!
                    while (isblank(*ret->text)) ret->text++;
                    if (*(ret->text) != *c){    // the letters are not thesame!
                        if ( (*c        > 0x40) &&      // second chance
                             (*ret->text > 0x40) &&
                             ((*c        & 0x1f) < 0x1b) &&
                             ((*ret->text & 0x1f) < 0x1b) &&
                             (*c & 0x1f) == (*ret->text & 0x1f)  ){     // case insensitive compare
                                c++;
                                ret->text++;    // advance
                                }
                        else flag=1;            // else error
                        }
                    else { c++; ret->text++; }  // advance
                    }
                else {
                    if ('f'==*(c+1))        // tabbing string with force space check
                        if (!isblank(*ret->text))  // if no space then error
                           flag=1;
                    }
                }
                
                                            // finished all rules
			if (flag) {                     // errors occurred
                if (todolist) {             // stuff to do?
                    g_free(ret);
                    ret = todolist->data;   // get next state
                    todolist=g_list_remove(todolist, todolist->data);   // remove from list
                    }
                else break;
                }
			ret->ruletext = ret->ruletext ->next;   // next rule piece
                
            }
          break;
       case LABELRULE:
          {
          Asm* numberasm= asm_assemble_label (text, rules, stat, last);
          if (numberasm) retlist = g_list_append(retlist,numberasm);                    // add it to the list
          break;
          }
          
       case COMMENTRULE:
          {
          Asm* numberasm = g_new(Asm,1);
          numberasm->text = text;
          numberasm->binary = NULL;
          while (            (*(numberasm->text))
                  && '\n' != (*(numberasm->text)) ) numberasm->text++;                           // unless its last and there is still chars to process then
          retlist = g_list_append(retlist,numberasm);                    // add it to the list
          }
          break;

       case ALIGNRULE:
          {
          Asm* numberasm = g_new(Asm,1);
          numberasm->text = text;
          numberasm->binary = NULL;
          retlist = g_list_append(retlist,numberasm);                    // add it to the list
          }
          break;

       case ASCIIRULE:
          {
          Asm* numberasm= asm_assemble_ascii (text, rules, stat, last);
          if (numberasm) retlist = g_list_append(retlist,numberasm);                    // add it to the list
          }
          break;
          
       default:
          g_print("ERROR: well its not a rule that I know of but its appeared when assembling\n");
          break;
       }

    rules=rules->next;                          // next rule
    }
 g_free(ret);
 return retlist;
}


GList* asm_copystringlist (GList* list)         // copy an asm list
{
 GList *scan, *split;
 SplitElement *splitelement;
 RuleElement* newrule;
 list = g_list_copy(list);                      // copy the list
 scan = list;
 while (scan && &dis_error != scan){             // walk list
	switch (((RuleElement *) scan->data)->type){
    
	    case NONTERM2FREE:                                      // if the nonterm needs to be freed then make an exact copy
            newrule = g_new(RuleElement, 1);                    // make a new nonterm2free list
            newrule->type = NONTERM2FREE;
            newrule->string = ((RuleElement *) scan->data)->string;    
            newrule->rules = asm_copystringlist (((RuleElement *) scan->data)->rules);  // just copy the old one
            scan->data = newrule;
            break;
        
		case TERM2FREE:                                         // if its a term that needs to be freed then 
            newrule = g_new(RuleElement, 1);                    // make a copy
            newrule->type = TERM2FREE;
            newrule->string =  g_strdup(((RuleElement *) scan->data)->string); // duplicate the string
            newrule->rules = NULL;
            scan->data = newrule;
            break;

		case SPLITNONTERM2FREE:                                 // if its a split non term that needs to be freed then 
            newrule = g_new(RuleElement, 1);                    // make a new splitnonterm2free list
            newrule->type = NONTERM2FREE;
            newrule->string = ((RuleElement *) scan->data)->string;    
            newrule->rules = asm_copystringlist (((RuleElement *) scan->data)->rules);  // just copy the old one
            newrule->split = g_list_copy(((RuleElement *) scan->data)->split);
            split=newrule->split;
            while (split){
                if (SPLIT2FREE == ((SplitElement *)split->data)->type){
                    splitelement = g_new(SplitElement,1);
                    splitelement->string=g_strdup(((SplitElement *)split->data)->string); //FIXME what is this? it doesn't work!
                    splitelement->type=SPLIT2FREE;
                    }
                }
            scan->data = newrule;
            break;
            
		case LABEL2FREE:                                         // if its a term that needs to be freed then 
            newrule = g_new(RuleElement, 1);                     // make a copy
            newrule->type = LABEL2FREE;
            newrule->string =  g_strdup(((RuleElement *) scan->data)->string); // duplicate the string
            newrule->rules = NULL;
            scan->data = newrule;
            break;

        default:
            break;
        }
        
	scan = scan->next;      // next
	}
 return list;                // return the copy
}

void asm_freestringlist (GList* list)   // free a asm list
{
	GList *scan = list;
    GList * split;

	while (scan && &dis_error != scan) {      // walk the list
        switch (((RuleElement *) scan->data)->type){
          case SPLITNONTERM2FREE:                                       // on splitnonterm2frees
			asm_freestringlist (((RuleElement *) scan->data)->rules);   // free their rules
            split = ((RuleElement *) scan->data)->split;
            while (split) {
                if (SPLIT2FREE == ((SplitElement *)split->data)->type) {    // free all split2frees
                    g_free (((SplitElement *)split->data)->bitfield);         // free the binary part
                    g_free (split->data);
                    }
                split=split->next;
                }
		    g_list_free(((RuleElement *) scan->data)->split);
			g_free (scan->data);                                        // and the element
            break;
            
          case NONTERM2FREE:                                            // on nonterm2frees
			asm_freestringlist (((RuleElement *) scan->data)->rules);   // free their contents
			g_free (scan->data);                                        // and element (remember not the string!!!)
    		break;
            
		  case TERM2FREE:                                           // on term2free
			g_free (((RuleElement *) scan->data)->string);          // free the string
			g_free (scan->data);                                    // and element
		    break;
		  case LABEL2FREE:                                           // on term2free
			g_free (((RuleElement *) scan->data)->string);          // free the string
			g_free (scan->data);                                    // and element
		    break;
          
		  case TERM:
		  case NONTERM:
          case SPLITNONTERM:                                        //ignore everything else
		  case LABEL:          
          break;
		  default:
            g_print("ERROR:I dont know what I'm freeing!\n");
            break;
          }
		scan = scan->next;      // next
	}

	g_list_free (list);         // free the list
}


GList *uchararr2glist (int size, uchar * vals)      // turn a uchararr into a glist of 0 or 1 gpointers
//                  number of chars, the chararr
{
	GList *ret = NULL;
	uchar c;
	int count;

	while (size--)
	{
		c = *vals;
		vals++;
		for (count = 8; count; count--)     // 8 bits per char
		{			ret = g_list_append (ret, GINT_TO_POINTER (c & 1));
			c >>= 1;                        // keep sticking them on
		}
	}
	return ret;
}


char *uchararr2str (int size, uchar * vals)      // turn a uchararr into a glist of 0 or 1 gpointers
//                  number of chars, the chararr
{
	char *ret;
	uchar c;
	int count, index;
    
    ret = g_strnfill(size*8, '?');
    index=0;
	while (size--)
	{
		c = *vals;
		vals++;
		for (count = 8; count; count--)     // 8 bits per char
		{
            if (c&1) ret[index]='I';
            else     ret[index]='O';
            index++;
			c >>= 1;                        // keep sticking them on
		}
	}
	return ret;
}



void asm_print (GList* list)                // print the asmlist
{
	if (&dis_error == list)                 // if error then undefined
		g_print ("Undefined");
	else
		while (list)                        // walk list
		{
			switch (((RuleElement *) list->data)->type){             // print terms
                case TERM:
                case TERM2FREE:
				    g_print ("%s", ((RuleElement *) list->data)->string);
                    break;
			    case NONTERM:
			    case NONTERM2FREE:
    				asm_print (((RuleElement *) list->data)->rules);    // recurse into nonterms
                    break;
			    case LABEL:
			    case LABEL2FREE:
                    break;
                default:
                    g_print ("ERROR:I can't print this, I don't know what this element is\n");
                    break;
                }
			list = list->next;
		} 

}

GList* asm_print_symbols (GList* list, GList* replylist)
            // asm list, mallocked string
{
 while (list) {                       // walk list
    switch (((RuleElement *) list->data)->type){             // print terms
        case TERM:
        case TERM2FREE:
            break;
        case NONTERM:
        case NONTERM2FREE:
            replylist = asm_print_symbols (((RuleElement *) list->data)->rules, replylist); //recurse
            break;
        case SPLITNONTERM:
        case SPLITNONTERM2FREE:
            g_print ("ERROR:I'm trying to search for symbols in a SPLITNONTERM. I don't know how to it.\n");
            break;
        case LABEL:
        case LABEL2FREE:
            replylist = g_list_append(replylist, g_strdup(((RuleElement *)list->data)->string));
            break;
        default:
            g_print ("ERROR:I can't print this, I don't know what this element is\n");
        }
    list = list->next;
    }
 return replylist;
}

char* asm_sprint (GList* list, char* replystring)
            // asm list, mallocked string
{
 char* oldreplystring;
		while (list) {                       // walk list
			switch (((RuleElement *) list->data)->type){             // print terms
                case TERM:
                case TERM2FREE:
                    oldreplystring = replystring;
                    replystring = asm_sprint_tabstring(((RuleElement *)list->data)->string, replystring);
                                            // call sprint_tabstring
                    g_free(oldreplystring);     // free the old string
                    break;
			    case NONTERM:
			    case NONTERM2FREE:
                    replystring = asm_sprint (((RuleElement *) list->data)->rules, replystring); //else recurse
                    break;
			    case SPLITNONTERM:
			    case SPLITNONTERM2FREE:
                    replystring = asm_sprint (((RuleElement *) list->data)->rules, replystring);
                    break;
			    case LABEL:
			    case LABEL2FREE:
                    break;
                default:
                    g_print ("ERROR:I can't print this, I don't know what this element is\n");
                }
			list = list->next;
		    }

 return replystring;
}

char* asm_sprint_tabstring (char* tabstring, char* replystring)
//                          string to append, original string
{
 int value;
 int value2=0;
 char* temp;
 if ('\t' != *tabstring)  return g_strconcat(replystring, tabstring, NULL);     // if its a tab string
 if ('f' == *(tabstring+1)) {if (*(tabstring+2)) value2 = g_strtod (tabstring+2, &temp);}
 else                       {                    value2 = g_strtod (tabstring+1, &temp);}
            // get the tab offset into value2
            
 value = strlen(replystring);
 value = value2 - value ; // tab to offset
 if (value<=0) value=1;
 temp = g_strnfill(value, ' ');                               // else stick spaces on
 replystring = g_strconcat(replystring, temp, NULL);
 g_free (temp);
 return replystring;
}


int asm_sbprint (GList* list, uchar** data)        // get binaryasm list into a chararr
                // asmlist, chararr ptr ptr
{
    char* text = asm_sprint (list, g_new0(char,1));     // print list into a string
    int size = strlen(text);                            // get length
    char* c = text + size;                              // work from the end
    if (size%8) size = (size>>3) + 1;                   // if overflow then round up
    else        size =  size>>3;
    *data = g_new0(char, size);                         // allocate with 0s
    size = 0;
    while (c-->text){                                   // walk string and stick 1s at points
        if ('X'==*c  || 'I'==*c) ((*data)[size>>3]) |= 1 << (size&7);
        size++;
        }
    g_free(text);
    return (size>>3);                                   // return rounded down
}


int asm_getsymbol_length (char* c)
{
 int ret=0;
 while (('_' == *c) ||
         isalpha(*c) ||
        (isdigit(*c) && ret) ) {ret++; c++;}
 return ret;
}

char asm_getchar(char* start, char** endptr)
{
 unsigned char c = 0;
 int index;
 char* ptr;
  if ('\\' == *start) {
    ptr = start+1;
    index=0;
    while ('8' > ptr[index] && '0' <= ptr[index] && 3 > index){
        c = c << 3 | (ptr[index++] - '0');
        }
    if (index) {
            *endptr = &ptr[index];
            return c;
            }

    c=*ptr;
    *endptr = ptr+1;
    switch (c){
        case 'b':
            return '\b';
        case 'f':
            return '\f';
        case 'n':
            return '\n';
        case 'r':
            return '\r';
        case 't':
            return '\t';
        case '0':
            return '\0';
        default:
            return c;
        }
    }
 *endptr = start+1;
 return *start;
}


int asm_isset(char c)
{
 switch (c){
  case 'i':
      return 1;
  case 'I':
      return 1;
  case '1':
      return 1;
  case 'X':
      return 1;
  case 'o':
      return 0;
  case 'O':
      return 0;
  case '0':
      return 0;
  case 'Z':
      return 0;
  default:
      return 1;         // panic?
  }




}

