#include "emulcore.h"
#include "emulmips.h"


void afterinstruction(uchar c)
{
 setreg(R0,0);
 setreg(PC,getreg(PC)&~3);
}


uchar* getwotrustring(void)
{
static uchar ret[]={15,13,0, 2,0,0, 0, 1, 0,0,0,0, 1,0,0,0};
return ret;
}
void boardreset(void)
{
 setreg(PC,0);
 setreg(NEXTPC,4);
}


uchar execute_instruction(void)
{
 unsigned int pc = getreg(PC);
 unsigned int nextpc = getreg(NEXTPC);
 unsigned int nextnextpc = nextpc + 4;
 unsigned int instruction = getmem32(pc);
 unsigned int temp=0, temp2=0;
 int stemp=0, stemp2=0;
 unsigned int unsignedimm = instruction&((1<<16)-1);
 int signedimm = unsignedimm | (((instruction&(1<<15))<<17)-(instruction&(1<<15)));
 switch (instruction>>26){
    case 0:                  //special
        switch((instruction>>3)&7){
            case 0:                 //shift
                if (instruction & 4) temp = getreg(get5(instruction,RS));
                else temp = get5(instruction,SA);
                switch (instruction&3){
                    case 0:
                        setreg(get5(instruction,RD),getreg(get5(instruction,RT))<<temp);
                        break;
                    case 1:
                        break;
                    case 2:
                        temp2 = getreg(get5(instruction,RT))>>temp;
                        setreg(get5(instruction,RD),temp2);
                        break;
                    case 3:
                        stemp2 = getreg(get5(instruction,RT))>>temp;
                        setreg(get5(instruction,RD),stemp2);
                        break;
                    }
                    
                break;
            case 1:                 //JR / syscall
                if (instruction&1) setreg(get5(instruction,RS),nextnextpc);
                nextnextpc = getreg(get5(instruction,RS));
                break;
            case 2:                 //MT/F HI/LO
                switch (instruction&3){
                    case 0:
                        setreg(get5(instruction,RD),getreg(HI));
                        break;
                    case 1:
                        setreg(HI,getreg(get5(instruction,RS)));
                        break;
                    case 2:
                        setreg(get5(instruction,RD),getreg(LO));
                        break;
                    case 3:
                        setreg(LO,getreg(get5(instruction,RS)));
                        break;
                    }
                break;
            case 3:                 //mult/div
                switch (instruction&3){
                    case 0:
                        setreg(LO,getreg(get5(instruction,RS))*getreg(get5(instruction,RT)));
                        break;
                    case 1:
                        setreg(LO,getreg(get5(instruction,RS))*getreg(get5(instruction,RT)));
                        break;
                    case 2:
                        setreg(LO,getreg(get5(instruction,RS))/getreg(get5(instruction,RT)));
                        setreg(HI,getreg(get5(instruction,RS))%getreg(get5(instruction,RT)));
                        break;
                    case 3:
                        setreg(LO,getreg(get5(instruction,RS))/getreg(get5(instruction,RT)));
                        setreg(HI,getreg(get5(instruction,RS))%getreg(get5(instruction,RT)));
                        break;
                    }
                break;
            case 4:                 //opp
                switch (instruction&7){
                    case 0:
                        setreg(get5(instruction,RD),getreg(get5(instruction,RS))+getreg(get5(instruction,RT)));
                        break;
                    case 1:
                        setreg(get5(instruction,RD),getreg(get5(instruction,RS))+getreg(get5(instruction,RT)));
                        break;
                    case 2:
                        setreg(get5(instruction,RD),getreg(get5(instruction,RS))-getreg(get5(instruction,RT)));
                        break;
                    case 3:
                        setreg(get5(instruction,RD),getreg(get5(instruction,RS))-getreg(get5(instruction,RT)));
                        break;
                    case 4:
                        setreg(get5(instruction,RD),getreg(get5(instruction,RS))&getreg(get5(instruction,RT)));
                        break;
                    case 5:
                        setreg(get5(instruction,RD),getreg(get5(instruction,RS))|getreg(get5(instruction,RT)));
                        break;
                    case 6:
                        setreg(get5(instruction,RD),getreg(get5(instruction,RS))^getreg(get5(instruction,RT)));
                        break;
                    case 7:
                        setreg(get5(instruction,RD),~getreg(get5(instruction,RS))&~getreg(get5(instruction,RT)));
                        break;
                    }
                break;
            case 5:                 //slt
                if (getreg(get5(instruction,RS))<getreg(get5(instruction,RT)))
                        setreg(get5(instruction,RD),1);
                else    setreg(get5(instruction,RD),0);
                break;
            case 6:                 //mt
                break;
            case 7:                 //mt
                break;
            }
        break;
    case 1:                  //BGEZ
        if (instruction&(1<<20)) setreg(RA,nextnextpc);
        stemp=getreg(get5(instruction,RS));
        if ((stemp>=0 &&  (instruction&(1<<16))) ||
            (stemp<0  && !(instruction&(1<<16)))) {
                nextnextpc = getreg(PC) + (signedimm<<2)-16;
                }
        break;
    case 3:                  //Jtype
        setreg(RA,nextnextpc);
    case 2:                  //Jtype
        nextnextpc &= ~((1<<28)-1);
        nextnextpc |= (((1<<26)-1) & instruction)<<2;
        break;
    case 4:                  //BEQ
        if (getreg(get5(instruction,RS))==getreg(get5(instruction,RT))){
                nextnextpc = getreg(PC) + (signedimm<<2)-16;
                }
        break;
    case 5:                  //BNE
        if (getreg(get5(instruction,RS))!=getreg(get5(instruction,RT))){
                nextnextpc = getreg(PC) + (signedimm<<2)-16;
                }
        break;
    case 6:                  //BLEZ
        stemp=getreg(get5(instruction,RS));        
        if (stemp<=0){
                nextnextpc = getreg(PC) + (signedimm<<2)-16;
                }
        break;
    case 7:                  //BGTZ
        stemp=getreg(get5(instruction,RS));        
        if (stemp>0){
                nextnextpc = getreg(PC) + (signedimm<<2)-16;
                }
        break;
    case 8:                  //ADD
    case 9:                  //ADDU
        setreg(get5(instruction,RT),getreg(get5(instruction,RS))+signedimm);
        break;
    case 11:                  //SLT
        if(instruction&(1<<15)) stemp= -1<<17;
    case 10:                  //SLTU
        stemp += instruction & ((1<<16)-1);
        if (0>(getreg(get5(instruction,RS))-stemp)) setreg(get5(instruction,RT),1);
        else setreg(get5(instruction,RT),0);
        break;
    case 12:                  //ANDI
        setreg(get5(instruction,RT),getreg(get5(instruction,RS))&(instruction & ((1<<16)-1)));
        break;
    case 13:                  //ORI
        setreg(get5(instruction,RT),getreg(get5(instruction,RS))|(instruction & ((1<<16)-1)));
        break;
    case 14:                  //XORI
        setreg(get5(instruction,RT),getreg(get5(instruction,RS))^(instruction & ((1<<16)-1)));
        break;
    case 15:                  //LUI
        setreg(get5(instruction,RT),(instruction & ((1<<16)-1))<<16);
        break;
    case 0x20:                //LBS
        stemp = (getreg(get5(instruction,RS))+signedimm)&(RAMSIZE-1);;
        stemp = memory[stemp];
        if(stemp&(1<<7)) stemp -= 1<<8;
        setreg(get5(instruction,RT),stemp);
        break;
    case 0x21:                //LHS
        stemp = (getreg(get5(instruction,RS))+signedimm)&(RAMSIZE-1);;
        stemp = memory[stemp]+(memory[stemp]<<8);
        if(stemp&(1<<15)) stemp -= 1<<16;
        setreg(get5(instruction,RT),stemp);
        break;
    case 0x22:                //LWL
        break;
    case 0x23:                //LW
        stemp = (getreg(get5(instruction,RS))+signedimm)&(RAMSIZE-1);;
        stemp = (memory[stemp])|(memory[stemp+1]<<8)|(memory[stemp+2]<<16)|(memory[stemp+3]<<24);
        setreg(get5(instruction,RT),stemp);
        break;
    case 0x24:                //LBU
        stemp = (getreg(get5(instruction,RS))+signedimm)&(RAMSIZE-1);;
        stemp = memory[stemp];
        setreg(get5(instruction,RT),stemp);
        break;
    case 0x25:                //LHU
        stemp = (getreg(get5(instruction,RS))+signedimm)&(RAMSIZE-1);;
        stemp = memory[stemp]+ (memory[stemp]<<8);
        setreg(get5(instruction,RT),stemp);
        break;
    case 0x26:                //LWL
        break;
        
    case 0x28:                //SB
        stemp = (getreg(get5(instruction,RS))+signedimm)&(RAMSIZE-1);;
        stemp2 = getreg(get5(instruction,RT));
        memory[stemp]=stemp2;
        break;
    case 0x29:                //SH
        stemp = (getreg(get5(instruction,RS))+signedimm)&(RAMSIZE-1);;
        stemp2 = getreg(get5(instruction,RT));
        memory[stemp]=stemp2;
        memory[stemp+1]=stemp2>>8;
        break;
    case 0x2A:                //SWL
        break;
    case 0x2B:                //SW&(RAMSIZE-1);
        stemp = (getreg(get5(instruction,RS))+signedimm)&(RAMSIZE-1);;
        stemp2 = getreg(get5(instruction,RT));
        memory[stemp]=stemp2;
        memory[stemp+1]=stemp2>>8;
        memory[stemp+2]=stemp2>>16;
        memory[stemp+3]=stemp2>>24;
        break;
    case 0x2E:                //SWL
        break;
        
    case 0x30:                //LCW
        stemp = (getreg(get5(instruction,RS))+signedimm)&(RAMSIZE-1);;
        stemp2 = getreg(get5(instruction,RT));
        stemp += getreg(get5(instruction,RS));
        stemp = memory[stemp]+(memory[stemp+1]<<8)+(memory[stemp+2]<<16)+(memory[stemp+3]<<24);
        setreg(get5(instruction,RT)+32,stemp);      // fixme!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
        break;
    case 0x38:                //SCW
        stemp = (getreg(get5(instruction,RS))+signedimm)&(RAMSIZE-1);;
        stemp2 = getreg(get5(instruction,RT));
        stemp += getreg(get5(instruction,RS));
        stemp2 = getreg(32+get5(instruction,RT));
        memory[stemp]=stemp2;
        memory[stemp+1]=stemp2>>8;
        memory[stemp+2]=stemp2>>16;
        memory[stemp+3]=stemp2>>24;
        break;
    }
    
 setreg(PC,nextpc);
 setreg(NEXTPC,nextnextpc);
 return 0x80;
}





unsigned int getreg(int number)
{
 return (registers[(number<<2)] |
        registers[(number<<2)+1]<<8 |
        registers[(number<<2)+2]<<16 |
        registers[(number<<2)+3]<<24);
}

void setreg(int number,unsigned int reg)
{
 registers[(number<<2)+0] = (reg>>0)&0xff;
 registers[(number<<2)+1] = (reg>>8)&0xff;
 registers[(number<<2)+2] = (reg>>16)&0xff;
 registers[(number<<2)+3] = (reg>>24)&0xff;
}

unsigned int getmem32(int number)
{
 number=number%RAMSIZE;
 return  memory[number] |
        (memory[number+1]<<8) |
        (memory[number+2]<<16) |
        (memory[number+3]<<24);
}


void setmem32(int number,unsigned int reg)
{
 number=number&(RAMSIZE-1);
 memory[number+0] = (reg>>0)&0xff;
 memory[number+1] = (reg>>8)&0xff;
 memory[number+2] = (reg>>16)&0xff;
 memory[number+3] = (reg>>24)&0xff;
}
