/* JDG Trying to scratch out all "global" definitions                         */
/* Last modified 17/1/2003                                                    */

#define MAX_NO_OF_TRAPS   32                               /* In any category */

#define uchar unsigned char

#define FALSE 0
#define TRUE !FALSE

/* Display columns */
#define ADDRESS_ENTRY        0
#define MIN_HEX_ENTRY        1
#define MAX_HEX_ENTRY       32
#define ASCII_ENTRY         33
#define DIS_ENTRY           34
#define TOTAL_ENTRY         35  /* Maximum number of columns in memory window */

#define CPSR 16                    /* defining CPSR and SPSR register numbers */
#define SPSR 17

#define MASK(size) ((size >= 32) ? 0xFFFFFFFF : (1 << size) - 1 )



#define MAX_SERIAL_WORD 4
            /* currently the maximum size of a word sent to emulator or board */

/* Return error states */
#define eval_okay            0
#define eval_no_operand      1
#define eval_no_operator     2
#define eval_not_closebr     3
#define eval_not_openbr      4
#define eval_no_identifier   5
#define eval_mathstack_limit 6



/* the following define possible states of the board */

#define CLIENT_STATE_CLASS_MASK     0XC0
#define CLIENT_STATE_CLASS_RESET    0X00
#define CLIENT_STATE_CLASS_STOPPED  0X40
#define CLIENT_STATE_CLASS_RUNNING  0X80
#define CLIENT_STATE_CLASS_ERROR    0XC0
#define CLIENT_STATE_RESET          0X00
#define CLIENT_STATE_BUSY           0X01
#define CLIENT_STATE_STOPPED        0X40
#define CLIENT_STATE_BREAKPOINT     0X41
#define CLIENT_STATE_WATCHPOINT     0X42
#define CLIENT_STATE_MEMFAULT       0X43
#define CLIENT_STATE_BYPROG         0X44
#define CLIENT_STATE_RUNNING        0X80
#define CLIENT_STATE_RUNNING_BL     0x81    //  @@@ NEEDS UPDATE
#define CLIENT_STATE_RUNNING_SWI    0x81
#define CLIENT_STATE_STEPPING       0X82

#define CLIENT_STATE_BROKEN         0x30


typedef struct CharListName{
 char c;
 struct CharListName* next;
 } CharList;





typedef enum
{                                         /* Board instructions unsigned char */
  BR_NOP      = 0x00,                                          /* need work on */
  BR_PING     = 0x01,
  BR_WOT_R_U  = 0x02,
  BR_RESET    = 0x04,
  BR_COMM_W   = 0x06,
  BR_COMM_R   = 0x07,

  BR_FR_GET   = 0x10,
  BR_FR_SET   = 0x11,
  BR_FR_WRITE = 0x12,
  BR_FR_READ  = 0x13,
  BR_FR_FILE  = 0x14,
  BR_FR_SEND  = 0x15,

  BR_WOT_U_DO = 0x20,
  BR_STOP     = 0x21,
  BR_PAUSE    = 0x22,
  BR_CONTINUE = 0x23,

  BR_RTF_SET  = 0x24,
  BR_RTF_GET  = 0x25,

  BR_BP_WRITE = 0x30,
  BR_BP_READ  = 0x31,
  BR_BP_SET   = 0x32,
  BR_BP_GET   = 0x33,

  BR_GET_REG  = 0x5A,                /*not general case! */
  BR_GET_MEM  = 0x48,
  BR_SET_REG  = 0x52,                /*not general case! */
  BR_SET_MEM  = 0x40,

  BR_WP_WRITE = 0x34,
  BR_WP_READ  = 0x35,
  BR_WP_SET   = 0x36,
  BR_WP_GET   = 0x37,


  BR_START = 0x80
}
BR_Instruction;


