/*		Name:		symboltable.c
		Version:	0.9.17
		Date:		29/8/2002
		(Assembly and) Dissassembly functions 
*/

#include "symboltable.h"
#include "misc.h"
#include "lint.h"
#include <glib.h>
#include <ctype.h>



Lint symbol_extract(char* ptr, char** endptr, void* data)
{
 char* string;
 Symbol* symbol;
 while (isblank(*ptr)) ptr++;
 string = ptr;
 while (('_' == *ptr) ||
        isalpha(*ptr) ||
       (isdigit(*ptr) && (string != ptr))) ptr++;
 
 string = g_strndup(string, ptr-string);
 symbol = symbol_findstring(data, string);
 g_free(string);
 if (!symbol){
    *endptr = NULL;
    return lint_new(0);
    }
 *endptr = ptr;
 return symbol->value;
}

Lint symbol_extract_fake(char* ptr, char** endptr, void* data)
{
 char* origptr;
 while (isblank(*ptr)) ptr++;
 origptr = ptr;
 while (('_' == *ptr) ||
        isalpha(*ptr) ||
       (isdigit(*ptr) && (origptr != ptr))) ptr++;
 *endptr = ptr;
 return lint_new(0);
}


Symbol* symbol_findstring(SymbolTable* symbol_table, char* string)
{
  char* mystr = g_strdup(string);  /*find string in an array of strings and return position*/
  int temp1=0 ,temp2=0;
  while (mystr[temp1]) if (' ' == mystr[temp1]) temp1++;
                       else mystr[temp2++] = mystr[temp1++];
  mystr[temp2]='\0';
  while (symbol_table){
	if (!g_strcasecmp(((Symbol*)symbol_table->data)->name, mystr)) {
            g_free(mystr); 
            return (Symbol*)symbol_table->data;
            }
    symbol_table = symbol_table->next;
    }
  g_free(mystr);
  return NULL;
}


Symbol* symbol_findaddress (SymbolTable* symbol_table, Lint address)
{
 while (symbol_table){
    if (!lint_compare(((Symbol*)symbol_table->data)->value,address))
        return (Symbol*)symbol_table->data;
    symbol_table = symbol_table->next;
    }
 return NULL;
}


void symbol_free_table (SymbolTable* symbol_table)
{
 SymbolTable* symbol_table_copy = symbol_table;
 while(symbol_table_copy) {
    g_free(((Symbol*)(symbol_table_copy->data))->name);
    symbol_table_copy = symbol_table_copy->next;
    }
 g_list_free_contents(symbol_table);
 g_list_free(symbol_table);
}
