/***************************************************************************
                          chatwindowinterface.cpp  -  description
                             -------------------
    begin                : Tue Apr 23 2002
    copyright            : (C) 2002 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "chatwindowinterface.h"

#ifdef HAVE_CONFIG_H
 #include "config.h"
#endif

#include <qkeysequence.h>

#include <qiconset.h>

#include <kaction.h>
#include <kapp.h>
#include <kconfig.h>
#include <kdebug.h>
#include <khelpmenu.h>
#include <klocale.h>
#include <kmenubar.h>
#include <kpopupmenu.h>
#include <kstatusbar.h>
#include <kstdaction.h>
#include <ktoolbar.h>
#include <ktoolbarbutton.h>

#include <stdio.h>

// The constructor
ChatWindowInterface::ChatWindowInterface(QWidget *parent, const char *name )
 : KDockMainWindow(parent,name)
{
  // Create the menus
  initMenus();
}



// The destructor
ChatWindowInterface::~ChatWindowInterface()
{
}



// Show the "about KDE" message.
void ChatWindowInterface::aboutKDE()
{
  helpMenu_->aboutKDE();
}



// Show the "about KMess" message.
void ChatWindowInterface::aboutKMess()
{
  helpMenu_->aboutApplication();
}



// put the marked text/object into the clipboard and remove
//  it from the document
void ChatWindowInterface::editCut()
{
  kdDebug() << "ChatWindowInterface::editCut not implemented" << endl;
}



// put the marked text/object into the clipboard
void ChatWindowInterface::editCopy()
{
  kdDebug() << "ChatWindowInterface::editCopy not implemented" << endl;
}



// Bring up a dialog to change the message font.
void ChatWindowInterface::editFont()
{
  kdDebug() << "ChatWindowInterface::editFont not implemented" << endl;
}



// Bring up a dialog to change the message font color.
void ChatWindowInterface::editFontColor()
{
  kdDebug() << "ChatWindowInterface::editFontColor implemented" << endl;
}



// paste the clipboard into the document
void ChatWindowInterface::editPaste()
{
  kdDebug() << "ChatWindowInterface::editFontParse implemented" << endl;
}



// The emoticon button was pressed.
void ChatWindowInterface::emoticonButtonPressed()
{
  kdDebug() << "ChatWindowInterface::emoticonButtonPressed implemented" << endl;
}



// Close the chat window
void ChatWindowInterface::fileClose()
{
  close();
}




// Show the user manual for KMess.
void ChatWindowInterface::helpContents()
{
  kapp->invokeHelp("kmess/index");
}




// Create the chat menu
void ChatWindowInterface::initChatMenu()
{
  KAction     *close, *save, *send, *meeting;
#ifdef HAS_KPHONE
  KAction     *conversation;
#endif
  KPopupMenu  *chatMenu;

  // Create the menu
  chatMenu = new KPopupMenu( this, "chatmenu" );

  // Create the "chat" menus
  inviteMenu_ = new KPopupMenu( this, "connect");
  send    = new KAction( i18n("Send a &File"),        "folder_open",      KShortcut(), this, SLOT( transferFile() ), actionCollection(), "sendfile");
  meeting = new KAction( i18n("Start a &Meeting"),    "gnomemeeting",     KShortcut(), this, SLOT( startMeeting() ), actionCollection(), "startmeeting");
#ifdef HAS_KPHONE  //If KPhone is not enable than don't support voice conversation
  conversation = new KAction( i18n("Start or Stop a &Conversation"),    "kphone",     KShortcut(), this, SLOT( startConversation() ), actionCollection(), "startconversation");
#endif



  save = KStdAction::save( this, SLOT( saveChat() ), actionCollection() );
  close = KStdAction::close( this, SLOT( fileClose() ), actionCollection() );

  // Plug the items into "chat"
  chatMenu->insertItem( i18n("&Invite"), inviteMenu_ );
  chatMenu->insertSeparator();
  send->    plug( chatMenu );
  meeting-> plug( chatMenu );
#ifdef HAS_KPHONE  //If KPhone is not enable than don't support voice conversation
  conversation->plug( chatMenu );
#endif  
  chatMenu->insertSeparator();
  save->    plug( chatMenu );
  close->   plug( chatMenu );
  close->   plug( toolBar("mainToolBar") );
  send->    plug( toolBar("mainToolBar") );

  // Plug the menu into the menubar
  menuBar()->insertItem( i18n("&Chat"), chatMenu );
}



// Create the edit menu
void ChatWindowInterface::initEditMenu()
{
  KAction         *changeFont, *changeFontColor;
  KAction         *cut, *copy, *paste;
  KPopupMenu      *editMenu;

  // Create the menu
  editMenu = new KPopupMenu( this, "editmenu" );

  // Create the "edit" menus
  changeFont = new KAction( i18n("Change &Font"), "fonts", KShortcut(), this, SLOT( editFont() ), actionCollection(), "font");
  changeFontColor = new KAction( i18n("Change Font &Color"), "colors", KShortcut(), this, SLOT( editFontColor() ), actionCollection(), "fontcolor");
  cut = KStdAction::cut( this, SLOT( editCut() ), actionCollection() );
  copy = KStdAction::copy( this, SLOT( editCopy() ), actionCollection() );
  paste = KStdAction::paste( this, SLOT( editPaste() ), actionCollection() );

  // Plug the items into "edit"
  cut->            plug( editMenu );
  copy->           plug( editMenu );
  paste->          plug( editMenu );
  changeFont->     plug( editMenu );
  changeFontColor->plug( editMenu );
  cut->            plug( toolBar("mainToolBar") );
  copy->           plug( toolBar("mainToolBar") );
  paste->          plug( toolBar("mainToolBar") );
  changeFont->     plug( toolBar("mainToolBar") );
  changeFontColor->plug( toolBar("mainToolBar") );

  // Plug the menu into the menubar
  menuBar()->insertItem( i18n("&Edit"), editMenu );
}



// Create the help menu
void ChatWindowInterface::initHelpMenu()
{
  KAction       *aboutKDE, *aboutKMess, *helpContents;
  KPopupMenu    *helpMenu;

  // Create the menu
  helpMenu     = new KPopupMenu( this, "helpmenu" );

  // Create the help menu.
  helpMenu_ = new KHelpMenu(this, KGlobal::instance()->aboutData());

  // Create the help menu items
  helpContents = KStdAction::helpContents(this, SLOT( helpContents() ), actionCollection() );
  aboutKMess = KStdAction::aboutApp(this, SLOT( aboutKMess() ), actionCollection() );
  aboutKDE = KStdAction::aboutKDE(this, SLOT( aboutKDE() ), actionCollection() );

  // Plug the items into "help"
  helpContents->plug( helpMenu );
  helpMenu->insertSeparator();
  aboutKMess  ->plug( helpMenu );
  aboutKDE    ->plug( helpMenu );

  // Plug the menu into the menubar
  menuBar()->insertItem( i18n("&Help"), helpMenu );
}



// Create the menus.
void ChatWindowInterface::initMenus()
{
  // Initialize the menus with their separate functions
  initChatMenu();
  initEditMenu();
  initSettingsMenu();
  initHelpMenu();
  // Create the emoticons button
  emoticonButton_ = new KToolBarButton( "emoticons", 0, toolBar("mainToolBar"), "emoticonchooser");
  // Connect the button
  connect( emoticonButton_, SIGNAL( pressed() ),
           this, SLOT( emoticonButtonPressed() ) );

  emoticonButton_->setText( i18n("Insert an emoticon") );
  // Plug the sidebar button in after the emoticon button.
  sidebarAction_-> plug( toolBar("mainToolBar") );
}



// Create the settings menu
void ChatWindowInterface::initSettingsMenu()
{
  KPopupMenu  *settingsMenu;

  // Create the menu
  settingsMenu = new KPopupMenu( this, "settingsmenu" );

  // Create the "settings" menus
  emoticonAction_ = new KToggleAction( i18n("Show &Emoticons"),            "services", KShortcut(), this, "emoticons" );
  sidebarAction_  = new KAction      ( i18n("Show/Hide &Contact Sidebar"), "fonts",    KShortcut( QKeySequence( "Ctrl+T" ) ), this, "sidebar"   );
  showToolBar_    = KStdAction::showToolbar  ( this, SLOT( showToolBar() ),   actionCollection() );
  showStatusBar_  = KStdAction::showStatusbar( this, SLOT( showStatusBar() ), actionCollection() );

  connect ( emoticonAction_, SIGNAL(         toggled(bool) ),
            this,            SLOT  ( toggleEmoticons(bool) ) );
  connect ( sidebarAction_,  SIGNAL(       activated()     ),
            this,            SLOT  (   toggleSidebar()     ) );

  // Give the sidebar action a tool tip like the standard actions
  sidebarAction_ ->setToolTip( i18n("Show or hide the contact sidebar") );

  sidebarAction_->setIcon( "view_right" );

  // Plug the items into "settings"
  emoticonAction_->plug( settingsMenu );
  showToolBar_->   plug( settingsMenu );
  showStatusBar_-> plug( settingsMenu );
  sidebarAction_-> plug( settingsMenu );

  // Plug the menu into the menubar
  menuBar()->insertItem( i18n("&Settings"), settingsMenu );
}



// Restore the window properties (called by KMainWindow)
void ChatWindowInterface::readProperties(KConfig *config)
{
  // Pull in the window size and position
  config->setGroup("Chat Window");

  QSize size = config->readSizeEntry("Size");
  if(! size.isEmpty())
  {
    resize(size);
  }

  QPoint pos = config->readPointEntry("Position");
  if(! pos.isNull())
  {
    move(pos);
  }

  // bar status settings
  showToolBar_   -> setChecked( config->readBoolEntry("Show Toolbar",   true)  );
  showStatusBar_ -> setChecked( config->readBoolEntry("Show Statusbar", true) );

  showToolBar();
  showStatusBar();

  // bar position settings
  int toolBarPos = config->readNumEntry("ToolBarPos", KToolBar::Top);
  toolBar("mainToolBar")->setBarPos(  (KToolBar::BarPosition) toolBarPos );
}



// Save the chat according to the user's request
void ChatWindowInterface::saveChat()
{
  kdDebug() << "ChatWindowInterface::saveChat not implemented" << endl;
}



// Save the window properties (called by KMainWindow)
void ChatWindowInterface::saveProperties(KConfig *config)
{
  // Save the window geometry
  config->setGroup("Chat Window");
  config->writeEntry("Size",           size()                           );
  config->writeEntry("Position",       pos()                            );
  config->writeEntry("Show Toolbar",   showToolBar_->isChecked()        );
  config->writeEntry("Show Statusbar", showStatusBar_->isChecked()      );
  config->writeEntry("ToolBarPos",     toolBar("mainToolBar")->barPos() );
}



// "Show status bar" was toggled.
void ChatWindowInterface::showStatusBar()
{
  kdDebug() << "ChatWindowInterface::showStatusBar not implemented" << endl;
}



// "Show toolbar" was toggled.
void ChatWindowInterface::showToolBar()
{
  if(!showToolBar_->isChecked())
  {
    toolBar("mainToolBar")->hide();
  }
  else
  {
    toolBar("mainToolBar")->show();
  }
}



// Start GnomeMeeting with a contact.
void ChatWindowInterface::startMeeting()
{
  kdDebug() << "ChatWindowInterface::startMeeting not implemented" << endl;
}



void ChatWindowInterface::startConversation()
{
  kdDebug() << "ChatWindowInterface::startConversation not implemented" << endl;
}



// Change the status bar message.
void ChatWindowInterface::statusMessage(QString /*message*/)
{
  kdDebug() << "ChatWindowInterface::statusMessage not implemented" << endl;
}



// Called when the "use emoticons" action is called.
void ChatWindowInterface::toggleEmoticons(bool /*useEmoticons*/)
{
  kdDebug() << "ChatWindowInterface::toggleEmoticons not implemented" << endl;
}



// Called when the "show sidebar" action is called.
void ChatWindowInterface::toggleSidebar()
{
  kdDebug() << "ChatWindowInterface::toggleSidebar not implemented" << endl;
}



// Send a file to a contact.
void ChatWindowInterface::transferFile()
{
  kdDebug() << "ChatWindowInterface::transferFile not implemented" << endl;
}



#include "chatwindowinterface.moc"
