/***************************************************************************
                          emoticon.h  -  description
                             -------------------
    begin                : Mon Apr 15 2002
    copyright            : (C) 2002 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef EMOTICON_H
#define EMOTICON_H

#include <qobject.h>
#include <qstringlist.h>

/**A class that stores an emoticon's representative text and the picture file.
  *@author Mike K. Bennett
  */


class Emoticon : public QObject
{
   Q_OBJECT

  public:
  	                         Emoticon(QString text, QString file);
  	                        ~Emoticon();
    // Add another text element into QStringList text_
    void                     addText( QString text );
    // Read property of QString file_.
    const QString&           getFile() const;
    // Read property of QString  html_.
    QString                  getHtml( bool small ) const;
    // Get a pattern which will match any of the variants of the emoticon
    QString                  getPattern() const;
    // Read property of QString  text_.
    QString                  getText() const;
    // Read property of QString  tooltip_.
    QString                  getTooltip() const;
    // Does the emoticon have a tooltip?
    bool                     hasTooltip() const;
    // Is the emoticon valid - ie, can we find an icon for it?
    bool                     isValid() const;
    // Write property of QString file_.
    void                     setFile( const QString & _newVal);
    // Write property of QString  text_.
    void                     setText( const QString & _newVal);
    // Write property of QString tooltip_.
    void                     setTooltip( const QString & _newVal);

  private: // Private attributes
    // The filename giving the emoticon picture's location.
    QString                  file_;
    // Does the emoticon have a tooltip?
    bool                     hasTooltip_;
    // The html img tag that represents the emoticon
    QString                  html_;
    // The text that represents the emoticon, eg :-)
    QStringList              text_;
    // Some help text for the emoticon
    QString                  tooltip_;
    // Can the icon be found
    bool                     valid_;
};

#endif
