/***************************************************************************
                          balloon.h  -  Nice Balloon
                             -------------------
    begin                : vie mar 29 2002
    copyright            : (C) 2002 by Duncan Mac-Vicar Prett
                           (C) 2001 by Malte Starostik <malte@kde.org>
    email                : duncan@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef BALLOON_H
#define BALLOON_H

#include <qcolor.h>
#include <qlabel.h>
#include <qmovie.h>
#include <qpixmap.h>
#include <qpushbutton.h>
#include <qtimer.h>
#include <qtooltip.h>
#include <qpoint.h>

#include "balloonbase.h"

/**
  *@author duncan
  */

class Balloon : public BalloonBase
{
  Q_OBJECT

  public:
    // The constructor
  	             Balloon();
    // The destructor
  	            ~Balloon();

    QString      getText() const;
    void         setColor( const QString& colorName );
  	void         setPixmap(const QPixmap &pixmap);
  	void         setText( const QString& text );
  	void         setAnchor(const QPoint& anchor);
	void         show();
  	void         callEnded();

  	virtual bool eventFilter(QObject *, QEvent *);

  protected: // Protected methods
  	virtual void updateMask();

  private slots: // Private slots
    void         closeClicked();
    void         labelClicked();

  private: // Private attributes
  	QString      m_displayName;
  	QPoint       m_anchor;

  signals:
  	void         signalBalloonClicked();
    void         signalCloseClicked();
    void         signalLabelClicked();

};

#endif
