//KMformat
//by Mickael Minarie
//this program is under GNU/GPL licence

/*! \file CDrive.h
  \brief The class to communicate with the hardware
    
  The Class to make a full or quick format
*/

#ifndef _USB_drv
#define _USB_drv
#include <QObject>
#include <QString>

using namespace std;



class CDrive: public QObject{   
  Q_OBJECT

    private:
  QString MountPoint;

 public:
  //! The constructor
  CDrive();

  //! The destructor
  virtual ~CDrive();

  //! A member to make a quick format
  /*!
    \sa QuickFormat()
    \param fs the filesystem
    \param label the label of the drive, optional
    \param check if you want to check the integrity of the drive
  */
  void QuickFormat(QString fs, QString label, bool check);
  //! A member to make a Full format
  /*!
    \sa FullFormat()
    \param size the size of the floppy
  */
  void FullFormat(int size);
  //! A member to get the current mountpoint 
  const QString getMountPoint();
  //! A member to set the current mountpoint 
  void setMountPoint(QString mp);

  private slots:
  void run(QString strm, QString arg); //a member which using by FullFormat() and QuickFormat()
 signals:
  //! a member to send a signal
  /*!
    if the signal is 0, formatting is finished without error
    if the signal is 1, the filesystem do not support the label
    if the signal is -1, there is an error while calling system() 
  */
  void SigState(int n); 
};
#endif
