/***************************************************************************
 *   Copyright (C) 2004 by Spiros Georgaras                                *
 *   sngeorgaras@otenet.gr                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef WAR_H
#define WAR_H

#include <klocale.h>
#include <kmimetype.h>
#include <kfilterdev.h>
#include <kfilterbase.h>
#include <kmimetype.h>
#include <kmdcodec.h>
#include <krfcdate.h>
#include <ktar.h>
#include <qfile.h>
#include <qfileinfo.h>
#include <qdatetime.h>
#include <qregexp.h>
#include <qcstring.h>
#include <qobject.h>

class WAR : public QObject{
Q_OBJECT
public:
	WAR();
	int setName(QString filName, QString outPath,bool BeSilent=TRUE, bool DoUseGui=TRUE);
	int numberOfFiles(){return numOfFiles;};
	//	1	cannot open
	//	2	contains folder
	//	3	error reading files
	//	4	error opening output file
	//	5	error extracting files
	virtual ~WAR();
signals:
	void archiveOpened();
	void archiveCreated(QString);
	void errorAppeared(int errorNumber);
	void fileExtraced(QString extractedFileName);
	void foundFilesInArchive(int numOfFiles);
private:
	int numOfFiles;
	struct files{
		QString inputName;
		QString outputName;
		QString mime;
		int encoding;
		//	0	quoted printable
		//	1	base64
		//2	uuencode
		//3	7-bit
		QCString outString;
		// Only for text/html
		QString type; // e.g. iso-8859-7
		bool written;
	}*fileInMHT;
	QString title;
	int allocatedFiles;
	QString archiveName;
	QString outArchiveName;
	int readWarDirectory( const KTarDirectory * dir );
	void writeHeader(int id, QTextStream * str);
	QCString toDOS(QCString orig);
	QString toDOS(QString orig);
	QString readDate(QString str);
	bool beSilent;
	bool doUseGui;
};
#endif
