/***************************************************************************
 *   Copyright (C) 2004 by Marco Gulino                                    *
 *   marco.gulino@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "gsm.h"
#include <kabc/addressee.h>
#include <kabc/phonenumber.h> 
#include <kabc/stdaddressbook.h>
#include <kmessagebox.h>
#include <qptrlist.h> 
#include <klocale.h>
#include <kabc/resource.h> 
#include <kabc/resourcefile.h> 
#include <kstandarddirs.h> 
#include <math.h>
#include <kaboutdata.h>
#include <qdir.h>
#include <kdebug.h>
#include <kabc/phonenumber.h> 
#include <unistd.h> 

#include "d_pickphonebook.h"
#include "threadedgsm.h"
extern threadedGSM gsmThread;

#include <iostream>
using namespace std;

GSM::GSM(QString device, QObject *parent, const char *name)
 : QObject(parent, name)
{
	i_signal=0;
	i_charge=0;
	i_chargeType=0;
	b_calling=false;

	addressbook=new KABC::AddressBook() ;
	QString abcPath=KGlobal::dirs()->resourceDirs("data").first();
	abcPath+=KGlobal::instance()->aboutData()->appName() + QString( QChar(QDir::separator() ) ) ;
	if( !QDir(abcPath).exists() ) QDir::home().mkdir( abcPath, true );
	abcPath+=KGlobal::instance()->aboutData()->appName() + QString(".vcf");
	KABC::Resource* resource=new KABC::ResourceFile( abcPath );
	resource->setReadOnly (false);

	addressbook->addResource( resource );
	addressbook->load();

	GSM::device=NULL;
	if(device!=NULL) initDevice(device);
	addressbookIsInited=false;
	smsList=new c_SMSList();
}


GSM::~GSM()
{
	Config->writeConfig();
	gsmThread.setShutdown();
	gsmThread.wait();
	delete device;
}

#include "gsm.moc"

bool GSM::initDevice(QString devpath)
{
	isMotorola=false;
	canDoMM=false;
	isSiemens=false;
	delete device;
	device=new Device( devpath.latin1() );
	if (! device->isInitialized() ) KMessageBox::error( NULL, 
				i18n("An error occurred while initializing mobile phone device.\nCheck your configuration and try again."),
				i18n("Device Error") );
// #define KMT_USE_PDU
	else
	{
		device->sendCommand("AT+CGMI;+CGMM;+CGMR;+CGSN\r", 200);
		if( QString(device->getBuffer()).contains("motorola",false) ) isMotorola=true; else isMotorola=false;
		if( isMotorola && !(device->sendCommand("AT+MMGL=?\r") ) ) canDoMM=true; else canDoMM=false;
		if( QString(device->getBuffer()).contains("siemens",false) ) isSiemens=true; else isSiemens=false;
	}
	pdu=device->isPDU();
	kdDebug() << "PDU mode: " << pdu << endl;
	kdDebug() << "IsMotorola:" << isMotorola << "; canDoMM*:" << canDoMM << endl;
	return device->isInitialized();
}

void GSM::getPhoneStatus()
{
	device->sendCommand("AT+CSQ\r",20);
	QString str_status(device->getBuffer());
 device->sendCommand("AT+CBC\r",20);
 str_status+=device->getBuffer();
	if( str_status.contains("+CBC",true)>0 )
	{
		QString s_charge=str_status.right( str_status.length() - str_status.find("+CBC:") - 5 );
		s_charge=s_charge.left( s_charge.find("\r") );
		s_charge=s_charge.stripWhiteSpace();
		
		i_charge=s_charge.section(",",1,1).toInt();
		i_chargeType=s_charge.section(",",0,0).toInt();
	} else { i_charge=-1; i_chargeType=-1; }
	
	
	if( str_status.contains("+CSQ",true)>0 )
	{
		QString s_charge=str_status.right( str_status.length() - str_status.find("+CSQ:") - 5 );
		s_charge=s_charge.left( s_charge.find('\r') );
		s_charge=s_charge.stripWhiteSpace();
		i_signal=s_charge.section(",",0,0).toInt();
		i_signal=i_signal*100/31;
	} else i_signal=-1;
	
	
	if( str_status.contains("RING", true) >0)
		b_calling=true; else b_calling=false;

	if ( ! Config->getMotoBattery() ) return;

	if(i_chargeType==0)
	{
		if( log(i_charge/1.4)/log(1.038) > 30 ) 
			i_charge=(int) (log((double) i_charge/1.4)/log(1.038));
	}
	if(i_chargeType==1)
	{
		i_charge= (int) ((int) pow( (double) (i_charge-6), (4.0/6.0) ) * 5.2) +2;
	}
}

void GSM::initPhoneBookSiemensVCF()
{
	QString buffer;
	device->sendCommand( ( "AT^SDBR=?\r"), 200 );

	if( QString( device->getBuffer() ).contains("OK")>0 )
	{
		buffer=device->getBuffer();
		if( buffer.contains("^SDBR:")>0 )
		{
			QString tempBuffer=buffer.right( buffer.length() - buffer.find("^SDBR:") - 6 );
			tempBuffer=tempBuffer.left( tempBuffer.find('\r') );
	// 			tempBuffer="(1-300) 40,1";
			if(tempBuffer.contains('(')>0)
			{
				tempBuffer=tempBuffer.remove('(');
				tempBuffer=tempBuffer.remove(')');
			}
			tempBuffer=tempBuffer.stripWhiteSpace ();
			tempBuffer=tempBuffer.replace(' ',',');
			tempBuffer=tempBuffer.replace('-',',');
			
			int i_startIndex=tempBuffer.section(',',0,0).toInt();
			int i_stopIndex=tempBuffer.section(',',1,1).toInt();
			phonebookBuffer+="VCF";
			buffer = QString("");
			for ( int i=i_startIndex; i<=i_stopIndex; i++ )
			{
				device->sendCommand( 
				(QString( "AT^SDBR="  + QString::number(i) + '\r' )).latin1(),
				1024*1024 );
				buffer += QString( "^SDBR="  + QString::number(i) + '\n' );
				buffer += device->getBuffer();
			};
			if(buffer.length()<=0) return;
			phonebookBuffer+=buffer;
			return;
		}
	}
}

void GSM::initPhoneBook( QString p_type )
{
	addressbookIsInited=false;
	if (p_type.length()<=0) return;
	if ( isSiemens && p_type=="VCF" )
	{
		initPhoneBookSiemensVCF();
		return;
	}
	QString buffer;
	device->sendCommand( (QString( "AT+CPBS=\"%1\"\r").arg(p_type).latin1() ), 20 );

	if( QString( device->getBuffer() ).contains("OK")>0 )
	{
		device->sendCommand("AT+CPBR=?\r", 20);
		buffer=device->getBuffer();
		if( buffer.contains("+CPBR:")>0 )
		{
			QString tempBuffer=buffer.right( buffer.length() - buffer.find("+CPBR:") - 6 );
			tempBuffer=tempBuffer.left( tempBuffer.find('\r') );
	// 			tempBuffer="(1-300) 40,1";
			if(tempBuffer.contains('(')>0)
			{
				tempBuffer=tempBuffer.remove('(');
				tempBuffer=tempBuffer.remove(')');
			}
			tempBuffer=tempBuffer.stripWhiteSpace ();
			tempBuffer=tempBuffer.replace(' ',',');
			tempBuffer=tempBuffer.replace('-',',');
			
			int i_startIndex=tempBuffer.section(',',0,0).toInt();
			int i_stopIndex=tempBuffer.section(',',1,1).toInt();
			device->sendCommand( 
				(QString( "AT+CPBR="  + QString::number(i_startIndex) + ',' + QString::number(i_stopIndex) + '\r' )).latin1(),
				1024*1024 );
			buffer=device->getBuffer();
			if(buffer.length()<=0) return;
			phonebookBuffer+=p_type;
			phonebookBuffer+=buffer;
			return;
		}
	}
}

void GSM::parsePhoneBookSiemensVCF( QString buffer )
{
	QString tempBuffer;
	while( buffer.contains("^SDBR=") ) {
		tempBuffer=buffer.left( buffer.find('\n') );
		tempBuffer=tempBuffer.right( tempBuffer.length() - 6).stripWhiteSpace();
		int uid = tempBuffer.toInt();
		
		if( buffer.contains("^SDBR") >1 )
		buffer= buffer.right( buffer.length() - buffer.find("^SDBR", 5) ).stripWhiteSpace();
		else buffer=buffer.right( buffer.length() - buffer.find('\n', 5) ).stripWhiteSpace();
		
		KABC::Addressee addressee;
		addressee.setUid( QString("KMobileTools-VCF") + "-%1" );
		addressee.setUid( addressee.uid().arg( uid, 3 ) );
		if ( Config->getPbOverwrite()==0  && !(addressbook->findByUid( addressee.uid() ).isEmpty() ) ) break;
			
		while ( buffer.left(6)=="^SDBR:" )
		{
			tempBuffer=buffer.left( buffer.find('\n') );
			tempBuffer=tempBuffer.right( tempBuffer.length() - 6).stripWhiteSpace();
		
			if( buffer.contains("^SDBR") >1 )
			buffer= buffer.right( buffer.length() - buffer.find("^SDBR", 5) ).stripWhiteSpace();
			else buffer=buffer.right( buffer.length() - buffer.find('\n', 5) ).stripWhiteSpace();

			while ( tempBuffer.contains(",,") >0 ) tempBuffer=tempBuffer.replace(",,",","); // fix for Ericsson models
			
			QString temp2=tempBuffer.section(',',3,3).stripWhiteSpace();
			
			if( temp2.find('\"')==0 ) temp2=temp2.right( temp2.length() -1);
			if( (unsigned int) temp2.findRev('\"')==temp2.length() -1 ) temp2=temp2.left( temp2.length() -1);
			
			switch( Config->getPbImportFormat() ){
				case 2:
					addressee.setGivenName( GSM::decodeText( temp2 ) ); break;
				case 1:
					addressee.setNickName( GSM::decodeText( temp2 ) ); break;
				default:
					addressee.setNameFromString( GSM::decodeText( temp2 ) ); break;
			}
			
			temp2=tempBuffer.section(',',1,1).stripWhiteSpace();
			if( temp2.find('\"')==0 ) temp2=temp2.right( temp2.length() -1);
			if( (unsigned int) temp2.findRev('\"')==temp2.length() -1 ) temp2=temp2.left( temp2.length() -1);
			
			switch ( tempBuffer.section(',',0,0).toInt() )
			{
				case 0: addressee.insertPhoneNumber( KABC::PhoneNumber( temp2 , KABC::PhoneNumber::Home ) ); break;
				case 1: addressee.insertPhoneNumber( KABC::PhoneNumber( temp2 , KABC::PhoneNumber::Work ) ); break;
				case 3: addressee.insertPhoneNumber( KABC::PhoneNumber( temp2 , KABC::PhoneNumber::Fax ) ); break;
				default: addressee.insertPhoneNumber( KABC::PhoneNumber( temp2 , KABC::PhoneNumber::Cell ) ); break;
			}
		}

		if( !addressee.isEmpty() ) addressbook->insertAddressee ( addressee );
		addressbook->save( addressbook->requestSaveTicket() );
		addressbookIsInited=true;
	}
}

void GSM::parsePhoneBook()
{
	QString buffer; QString tempBuffer; QString p_type;
	for(QStringList::Iterator it=phonebookBuffer.begin(); it !=phonebookBuffer.end(); ++it)
	{
		p_type=*it;
		++it;
		buffer=*it;
		buffer=buffer.replace('\r','\n');
		while(buffer.contains("\n\n")>0) buffer=buffer.replace("\n\n","\n");
		buffer=buffer.stripWhiteSpace();
		if ( isSiemens && p_type=="VCF" )
			parsePhoneBookSiemensVCF( buffer );
		else while( buffer.contains("+CPBR:") ) {
			tempBuffer=buffer.left( buffer.find('\n') );
			tempBuffer=tempBuffer.right( tempBuffer.length() - 6).stripWhiteSpace();
			if( buffer.contains("+CPBR:") >1 )
			buffer= buffer.right( buffer.length() - buffer.find("+CPBR:", 5) ).stripWhiteSpace();
			else buffer=buffer.right( buffer.length() - buffer.find('\n', 5) ).stripWhiteSpace();
			KABC::Addressee addressee;
			
			while ( tempBuffer.contains(",,") >0 ) tempBuffer=tempBuffer.replace(",,",","); // fix for Ericsson models
			
			addressee.setUid( QString("KMobileTools-") + p_type + "-%1" );
			addressee.setUid( addressee.uid().arg( tempBuffer.section(',',0,0).stripWhiteSpace().toInt(), 3 ) );
			
			if ( Config->getPbOverwrite()==0 && !(addressbook->findByUid( addressee.uid() ).isEmpty() ) ) break;
			QString temp2=tempBuffer.section(',',3,3).stripWhiteSpace();
			
			if( temp2.find('\"')==0 ) temp2=temp2.right( temp2.length() -1);
			if( (unsigned int) temp2.findRev('\"')==temp2.length() -1 ) temp2=temp2.left( temp2.length() -1);
			
			switch( Config->getPbImportFormat() ){
				case 2:
					addressee.setGivenName( GSM::decodeText( temp2 ) ); break;
				case 1:
					addressee.setNickName( GSM::decodeText( temp2 ) ); break;
				default:
					addressee.setNameFromString( GSM::decodeText( temp2 ) ); break;
			}
			
			temp2=tempBuffer.section(',',1,1).stripWhiteSpace();
			if( temp2.find('\"')==0 ) temp2=temp2.right( temp2.length() -1);
			if( (unsigned int) temp2.findRev('\"')==temp2.length() -1 ) temp2=temp2.left( temp2.length() -1);
			addressee.insertPhoneNumber( KABC::PhoneNumber( temp2 , KABC::PhoneNumber::Cell ) );
			if( !addressee.isEmpty() ) addressbook->insertAddressee ( addressee );
			addressbook->save( addressbook->requestSaveTicket() );
			addressbookIsInited=true;
		}
	}
}


void GSM::dial(QString number)
{
	if (number.length() <= 0 ) return;
	
	if( Config->getDalOpts() == c_config::CKPD_DIAL)
	{
		if( number.at(0)=='+' )
		{
			number=number.right( number.length() -1 ).prepend("AT+CKPD=\"0\",20;+CKPD=\"").append("s\"\r" );
		}
		else	number=number.prepend( "AT+CKPD=\"" ).append( "s\"\r" );
	}
	if( Config->getDalOpts() == c_config::AT_DIAL )
	{
		number=number.prepend( "ATD" ).append( ";\r" );
	}

	device->sendCommand( number, 20 );
}


/*!
    \fn GSM::hangup()
 */
void GSM::hangup()
{
	if( Config->getDalOpts() == c_config::CKPD_DIAL)
		device->sendCommand( "AT+CKPD=\"e\"\r", 20 );
	if( Config->getDalOpts() == c_config::AT_DIAL )
	{
		device->sendCommand( "ATH", 20 );
		device->sendCommand( "AT+CHUP", 20 );
	}
}


/*!
    \fn GSM::initSMSList()
 */
void GSM::initSMSList( QStringList memsource )
{
	QStringList idList;
	bool inited=false;
	c_SMS* sms;
	c_SMS* tmpsms;
	if(memsource.begin() == memsource.end() ) smsList->clear();
    for ( QStringList::Iterator it = memsource.begin(); it != memsource.end(); ++it ) {
		if( !changeSMSMemSlot(*it) ) break;
// 		pdu=false;
		if( canDoMM ) {
			if(pdu) device->sendCommand("AT+MMGL=5\r");
				else device->sendCommand("AT+MMGL=\"HEADER ONLY\"\r");
		} else {
			if(pdu) device->sendCommand("AT+CMGL=4\r");
				else device->sendCommand("AT+CMGL=\"ALL\"\r");
		} // We've an ID list here
		QString smsBuffer=device->getBuffer();
		if( smsBuffer.contains("+MMGL:")>0 || smsBuffer.contains("+CMGL:")>0 ) 
		{
			if(smsBuffer.contains("+MMGL")>0)
				idList=c_SMSList::parseSMSListID( QString(device->getBuffer() ), *it, "+MMGL:" );
			else idList=c_SMSList::parseSMSListID( QString(device->getBuffer() ), *it, "+CMGL:" );
			QStringList::Iterator id_it;
			for ( id_it = idList.begin(); id_it != idList.end(); ++id_it )
			{
				tmpsms=smsList->find( *id_it );
				if( tmpsms==NULL || (tmpsms->memSource()!= *it && tmpsms->id() ==  *id_it))
				{
					smsBuffer=getSMSBuffer( *id_it );
					
					if(smsBuffer.contains("+MMGR:") >0 )
						sms=new c_SMS(smsBuffer.section("+MMGR:",1,1).stripWhiteSpace().
								prepend( (*id_it).section("-",1,1).stripWhiteSpace() +','), *it, true, pdu );
					else
						sms=new c_SMS( smsBuffer.section("+CMGR:",1,1).stripWhiteSpace().
						prepend( (*id_it).section("-",1,1).stripWhiteSpace() +','), *it, true, pdu );
// 					sms->setMemSRC( *it );
					if ( smsList->find( sms->Numbers() ,sms->TextList() ) == NULL ) 
					{
						smsList->append(sms);
					}
				}
			}
			if( ! (smsList->isEmpty() ) ) inited=true;
		}
		QPtrListIterator<c_SMS> s_it( *smsList );
		smsList->setNewSMS();
		while ( (sms=s_it.current() ) !=0 )
		{
			if(idList.find(sms->id() ) == idList.end() && *it== sms->memSource() ) smsList->remove(sms);
			else 
			{
				if(sms->Type()==c_SMS::REC_UNREAD)
				{
					smsList->setNewSMS( smsList->getNewSMS()+1 );
					if(!sms->isNotified())
					{
						smsList->addNotifySMS( sms->id() );
						sms->notify();
					}
				}
				++s_it;
			}
		}
    }
}
void GSM::removeSMS( QString ID )
{
	kdDebug() << "Changing memory slot to " << ID.section("-",0,0) << endl;
	if(!changeSMSMemSlot( ID.section("-", 0, 0) ) ) return;
	device->sendCommand( QString( "AT+CMGD=") + ID.section("-",1,1).stripWhiteSpace() , 20 );
	device->sendCommand( "AT\r" , 200);
}

QString GSM::storeSMS( c_SMS* sms)
{
	if (sms==NULL) return "ERROR";
	QString buffer;
	gsmThread.togglePaused(true);
	while( ! gsmThread.getPaused() ) usleep(200);
	if( isPDU() )
	{
		buffer="AT+CMGW=%1\r";
		buffer=buffer.arg ( (sms->getPDUStream().length() / 2) -1 );
		if( device->sendCommand( buffer.latin1(), 20 )==2 ) 
		{
			gsmThread.togglePaused(false);
			return "ERROR";
		}
		buffer="%1\x1A";
		buffer=buffer.arg ( sms->getPDUStream() );
		device->sendCommand( buffer.latin1(), 900 );
	}
	else 
	{
		buffer="AT+CMGW=\"%1\"\r";
		buffer=buffer.arg ( sms->Numbers().join(" ") );
		if( device->sendCommand( buffer.latin1(), 20 )==2 ) 
		{
			gsmThread.togglePaused(false);
			return "ERROR";
		}
		buffer="%1\x1A";
		buffer=buffer.arg ( GSM::recodeText( sms->TextList().join(" ") ) );
		device->sendCommand( buffer.latin1(), 900 );
	}
	buffer= device->getBuffer();
	if( buffer.contains ("ERROR") >0 ) return "ERROR";
	if( /*buffer.contains ("+CMGW:") >0*/ false )
	{
/// @TODO reimplement new sms id detection
// return buffer.section("+CMGW:",1,1).section('\r',0,0).stripWhiteSpace().toInt();
	} else // if the phone doesn't return the new SMS number, we need to take it manually :-(
	{
// 		sleep(1);
		for(int i=0; i<4; i++) // Just try 4 times to find our SMS, otherwise we return Not Found
		{
			kdDebug() << "Reinitializing SMS list" << endl;
			initSMSList( Config->getSMSMemUsed() );
			kdDebug() << "SMS Reinitialization completed" << endl;
			gsmThread.togglePaused(false);
	//		sleep(10); ///@TODO fix getsms handling
			c_SMS* sms2; /*sms=new c_SMS();*/
			QPtrListIterator<c_SMS> it( *smsList );
			while ( (sms2=it.current() ) !=0 )
			{
// 				if( (*sms).TextList().join(" ") == (*sms2).TextList().join(" ") ) return sms2->id();
				if( *sms == *sms2 ) return sms2->id();
				++it;
			}
		}
		return "NF";
	}
	return "ERROR";
}

QStringList GSM::getUsedSMSSlots() /// @TODO implement Used SMS Slots reading
{
	QStringList retval;
	if(device->sendCommand("AT+CPMS?\r", 50) ) return retval;
	QString buffer=device->getBuffer();
	return retval;
}
bool GSM::sendSMS( c_SMS* sms)
{
	if (sms==NULL) return false;
	QString buffer;
	gsmThread.togglePaused(true);
	while( ! gsmThread.getPaused() ) usleep(200);
	if( isPDU() )
	{
		buffer="AT+CMGS=%1\r";
		buffer=buffer.arg ( (sms->getPDUStream().length() / 2) -1 );
		if( device->sendCommand( buffer.latin1(), 20 )==2 )
		{
			gsmThread.togglePaused(false);
			return false;
		}
		buffer="%1\x1A";
		buffer=buffer.arg ( sms->getPDUStream() );
		device->sendCommand( buffer.latin1(), 900 );
	}
	else 
	{
		buffer="AT+CMGS=\"%1\"\r";
		buffer=buffer.arg ( sms->Numbers().join(" ") );
		if( device->sendCommand( buffer.latin1(), 20 )==2 )
		{
			gsmThread.togglePaused(false);
			return false;
		}
		buffer="%1\x1A";
		buffer=buffer.arg ( GSM::recodeText( sms->TextList().join(" ") ) );
		device->sendCommand( buffer.latin1(), 900 );
	}
	buffer= device->getBuffer();
	gsmThread.togglePaused(false);
	if( buffer.contains ("OK") >0 ) return true;
	return false;
}

bool GSM::sendSMS( QString sms) /// FIXME reimplement for memory slot selection
{
	if (sms.length() <= 0 ) return false;
	changeSMSMemSlot( sms.section("-",0,0) );
	QString buffer ( "AT+CMSS=%1\r" );
	buffer=buffer.arg  ( sms.section("-",1,1).stripWhiteSpace() );
	device->sendCommand ( buffer.latin1(), 100 );
	buffer= device->getBuffer();
// 	buffer="\r\nOK\r\n";

	if( buffer.contains ("OK") >0 ) return true;
	return false;
}

void GSM::answer()
{
	if( Config->getDalOpts() == c_config::CKPD_DIAL)
		device->sendCommand( "AT+CKPD=\"s\"\r", 20 );
	if( Config->getDalOpts() == c_config::AT_DIAL )
		device->sendCommand( "ATA", 20 );
}

int GSM::motoMode()
{
	if( !isMotorola ) return -1;
	if( device->sendCommand("AT+MODE?\r",20) ) return -1;
	if( QString( device->getBuffer() ).contains("+MODE:") >0)
		return QString( device->getBuffer() ).section("+MODE:",1,1).section('\r',0,0).stripWhiteSpace().toInt();
	return -2;
}

bool GSM::changeSMSMemSlot(QString slot)
{
	QString sndCommand;
	if( Config->getSMSSaveSlot().length() ) 
		sndCommand=QString("AT+CPMS=\"%1\",\"%2\"\r").arg(slot).arg( Config->getSMSSaveSlot() ); 
	else sndCommand=QString("AT+CPMS=\"%1\"\r").arg(slot);
	if(device->sendCommand( sndCommand.upper(), 50) )
	{
		if( Config->getSMSSaveSlot().length() ) 
			sndCommand=QString("AT+CPMS=%1,%2\r").arg(slot).arg( Config->getSMSSaveSlot() ); 
		else sndCommand=QString("AT+CPMS=%1\r").arg(slot);
		if(device->sendCommand(sndCommand.upper(), 50) ) 
			return false;
	}
	return true;
}
	
QString GSM::getSMSBuffer(QString id)
{
	QString buffer;
	if( canDoMM )
		device->sendCommand( (QString("AT+MMGR=")+ id.section("-",1,1) + '\r').latin1() );
	else
		device->sendCommand( (QString("AT+CMGR=")+ id.section("-",1,1) + '\r').latin1() );
	buffer=device->getBuffer();
	buffer=buffer.replace("\nOK\r","").replace("\nERROR\r","").stripWhiteSpace();
	if(buffer.contains("+MMGR:")<=0 && buffer.contains("+CMGR:")<=0 ) return "";
	return buffer;
}

QString GSM::getNameFromNumber(QString number)
{
	for( KABC::AddressBook::Iterator ait=addressbook->begin(); ait!=addressbook->end(); ++ait) {
		QValueList<KABC::PhoneNumber> phonenums =  ait->phoneNumbers();
		for(QValueListIterator<KABC::PhoneNumber> phone_it= phonenums.begin(); phone_it!=phonenums.end(); ++phone_it)
		{
			if( parseNumber((*phone_it).number() ) == parseNumber(number) )
			{
				if( (*ait).assembledName().length()>0) return (*ait).assembledName();
				return (*ait).nickName();
			}
		}
	}
	for( KABC::AddressBook::Iterator ait=KABC::StdAddressBook::self()->begin(); ait!=KABC::StdAddressBook::self()->end(); ++ait) {
		QValueList<KABC::PhoneNumber> phonenums =  ait->phoneNumbers();
		for(QValueListIterator<KABC::PhoneNumber> phone_it= phonenums.begin(); phone_it!=phonenums.end(); ++phone_it)
		{
			if( parseNumber((*phone_it).number() ) == parseNumber(number) )
			{
				if( (*ait).assembledName().length()>0) return (*ait).assembledName();
				return (*ait).nickName();
			}
		}
	}
	return number;
}


/*!
    \fn GSM::getSMSMemSlots()
 */
QStringList GSM::getSMSMemSlots()
{
	QStringList out;
	if (device->sendCommand("AT+CPMS=?\r",200) ) return out;
	QString buffer=device->getBuffer();
	buffer=buffer.section("+CPMS:",1,1).section('(',1,1).section(')',0,0).replace(", ",",").stripWhiteSpace();
	out=QStringList::split(',',buffer);
	return out;
}


/*!
    \fn GSM::getPbMemSlots()
 */
QStringList GSM::getPbMemSlots()
{
	QStringList out;
	if (device->sendCommand("AT+CPBS=?\r",200) ) return out;
	QString buffer=device->getBuffer();
	buffer=buffer.section("+CPBS:",1,1).section('\r',0,0).replace("\"","").replace(", ",",").remove("(").remove(")").stripWhiteSpace();
	out=QStringList::split(',',buffer);
	if ( isSiemens && !device->sendCommand("AT^SDBR=?\r",200) ) out.append( "VCF" );
	return out;
}

const QStringList GSM::getMemDesc(int type, QString memstr)
{
QStringList retval;
// SMS Types
	if(memstr=="MT" && type==TYPE_SMS) retval+= i18n("Main memory slot");
	if(memstr=="BM" && type==TYPE_SMS) retval+= i18n("Volatile memory");
	if(memstr=="ME" && type==TYPE_SMS) retval+= i18n("Phone SMS memory");
	if(memstr=="SM" && type==TYPE_SMS) retval+= i18n("SIM SMS memory");
	if(type==TYPE_SMS && retval.isEmpty() ) retval+=i18n("Unknown SMS memory slot");
// Phonebook types
	if(memstr=="MT" && type==TYPE_PB) retval+= i18n("Composite phonebook");
	if(memstr=="EN" && type==TYPE_PB) retval+= i18n("Emergency number");
	if(memstr=="FD" && type==TYPE_PB) retval+= i18n("SIM fixed dialing number phonebook");
	if(memstr=="MC" && type==TYPE_PB) retval+= i18n("Missed calls list");
	if(memstr=="DC" && type==TYPE_PB) retval+= i18n("Dialed numbers list");
	if(memstr=="ME" && type==TYPE_PB) retval+= i18n("Phone numbers list");
	if(memstr=="ON" && type==TYPE_PB) retval+= i18n("Own numbers");
	if(memstr=="OW" && type==TYPE_PB) retval+= i18n("Own numbers");
	if(memstr=="RC" && type==TYPE_PB) retval+= i18n("Received calls list");
	if(memstr=="SM" && type==TYPE_PB) retval+= i18n("SIM phonebook");
	if(memstr=="TA" && type==TYPE_PB) retval+= i18n("Data card phonebook");
	if(memstr=="MD" && type==TYPE_PB) retval+= i18n("Last number redial");
	if(memstr=="LD" && type==TYPE_PB) retval+= i18n("SIM last-dialing phonebook");
	if(memstr=="MV" && type==TYPE_PB) retval+= i18n("Voice activated phonebook");
	if(memstr=="HP" && type==TYPE_PB) retval+= i18n("Hierarchical phonebook");
	if(memstr=="BC" && type==TYPE_PB) retval+= i18n("Own business card");
	if(memstr=="QD" && type==TYPE_PB) retval+= i18n("Quick dial numbers list");
// Siemens types
	if(memstr=="VCF" && type==TYPE_PB) retval+= i18n("Addressbook");

	if(type==TYPE_PB && retval.isEmpty() ) retval+=i18n("Unknown Phonebook memory slot");
	retval+=memstr;
	return retval;
}

const QString GSM::decodeText(const QString text)
{
	QString out;
	if(Config->getEncoding() == "UCS2")
	{
		for(unsigned int i=0; i<text.length() ; i+=4)
			out+=QChar( (int) text.mid(i,4).toInt(NULL,16)/* , text.mid(i+2,2).toInt(NULL,16)*/ );
		return out;
	}
	if(Config->getEncoding() == "GSM")
		return c_SMS::fromGSMAlphabet(text);
	return text;

}
const QString GSM::recodeText(const QString text)
{
	QString out;
	kdDebug() << text << endl;
	if(Config->getEncoding() == "UCS2")
	{
		for(unsigned int i=0; i<strlen(text); i++)
			out+=QString("%1").arg( text.at(i).unicode(), 4, 16 ).replace(" ", "0");
		return out;
	}
	return text;

}

const QString GSM::parseNumber(const QString number)
    {
		if( number.startsWith("+") ) {
			if(number.length() >4) return(number.right( number.length()-3) );
			else return number.right( number.length()-1);
		}
		return number;
    }
