/***************************************************************************
 *   Copyright (C) 2004 by Marco Gulino                                    *
 *   marco.gulino@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "kmobiletools.h"

#include <qlabel.h>

#include <kmainwindow.h>
#include <klocale.h>
#include <ksystemtray.h>
#include <kmenubar.h> 
#include <kpopupmenu.h> 
#include <kaction.h> 
#include <kconfigdialog.h> 
#include <kconfigdialogmanager.h> 
#include <kprogress.h> 
#include <kiconloader.h>
#include <qlayout.h>
#include <qiconset.h> 
#include <kpushbutton.h> 
#include <iostream>
#include <qtimer.h>
#include <kled.h>
#include <qtooltip.h>
#include <qbuttongroup.h>
#include <kcombobox.h> 
#include <qradiobutton.h> 
#include <qcheckbox.h>
#include <kmessagebox.h>
#include <kcmdlineargs.h>
#include <knotifyclient.h> 
#include <knotifydialog.h> 
#include <kapplication.h>
#include <dcopclient.h>
#include <dcopobject.h>
#include <kprocess.h> 
#include <kaboutdata.h>

#include "d_settingsui.h"
#include "d_pickphonebook.h"
#include "d_smslist.h"
#include "d_newsms.h"
#include "threadedgsm.h"
#ifndef KMT_USE_SEYON
#include "d_terminal.h"
#endif

#define STR_VERSION KGlobal::instance()->aboutData()->version()
threadedGSM gsmThread;

#include "c_config.h"

#include <iostream>
using namespace std;

c_config* Config;
GSM* d_gsm=NULL;

kmobiletools::kmobiletools()
    : DCOPObject("KMobileToolsInterface"), KMainWindow( 0, "KMobileToolsWin", 0 )
{
	::Config=new c_config;
	Config=::Config;
	Config->readConfig();
	Config->upgradeOlds();
	if(Config->getFirstTime() )
	{
		Config->setFirstTime(false);
		KMessageBox::information(this, i18n("<qt><center><b>Welcome to KMobileTools</b></center>\n\n\
Before you can use this program you have to configure it to your needs.\n\
You can use it with every possible connection (serial,usb,bluetooth).<br>\n\
These are KMobileTools configuration options:\n<ul>\
<li><u><b>Device</b></u></li><br>\n\
Here you can <b>set your device</b> that will be used for connection with your mobile, for instance /dev/rfcomm0 (Bluetooth), /dev/ttyACM0 or /dev/ttyUSB0 (USB devices) or /dev/ttyS0 (serial port).<br>\n\
<li><u><b>Mobile Phone</b></u></li><br>\n\
Here you have to choose the dialing options for your phone.\n\
<li><u><b>Phonebook</b></u></li><br>\n\
Press the refresh button and <b>choose the slots</b> you want to be shown in your phonebook.\n\
<li><u><b>SMS</b></u></li><br>\n\
Press the refresh button and <b>choose the slots</b> to read the SMS from the phone.<br>\n</ul>\
In the main window you will see the indicators for battery, signal level, and charger. If you can see the level you are connected with your mobile device.<br><br>\n\
You can then use the mobile functions, such as dialing, browse SMS, write new SMS, and synchronize/look at your phonebook.</qt>"), i18n("KMobileTools first time message")  );
		
	}
	d_gsm=new GSM( Config->getDevice() );
	gsmThread.start();
	mainWidget_ui=new mainWidget(this);
	setCentralWidget(mainWidget_ui);

	mainWidget_ui->lp_signal->setPixmap( KGlobal::iconLoader()->loadIcon( "kppp", KIcon::FirstGroup, KIcon::SizeMedium ) );
	mainWidget_ui->lp_battery->setPixmap( KGlobal::iconLoader()->loadIcon( "energy", KIcon::FirstGroup, KIcon::SizeMedium ) );
	mainWidget_ui->lp_sms->setPixmap( KGlobal::iconLoader()->loadIcon( "mail_generic", KIcon::FirstGroup, KIcon::SizeMedium ) );
	mainWidget_ui->b_pick->setIconSet( QIconSet ( KGlobal::iconLoader()->loadIcon( "korganizer", KIcon::FirstGroup, KIcon::SizeSmall ) ) );
	mainWidget_ui->b_dial->setIconSet( QIconSet ( KGlobal::iconLoader()->loadIcon( "button_ok", KIcon::FirstGroup, KIcon::SizeSmall ) ) );
	mainWidget_ui->b_sms->setIconSet( QIconSet ( KGlobal::iconLoader()->loadIcon( "mail_generic", KIcon::FirstGroup, KIcon::SizeSmall ) ) );
	mainWidget_ui->b_hangup->setIconSet( QIconSet ( KGlobal::iconLoader()->loadIcon( "button_cancel", KIcon::FirstGroup, KIcon::SizeSmall ) ) );
	mainWidget_ui->b_answer->setIconSet( QIconSet ( KGlobal::iconLoader()->loadIcon( "connect_established", KIcon::FirstGroup, KIcon::SizeSmall ) ) );
	mainWidget_ui->b_newSMS->setIconSet( QIconSet ( KGlobal::iconLoader()->loadIcon( "mail_new", KIcon::FirstGroup, KIcon::SizeSmall ) ) );
	mainWidget_ui->show();
    // set the shell's ui resource file
//     setXMLFile("kmobiletoolsui.rc");

/// here there was init gsm
	// Setting System tray icon
	w_systray=new KSystemTray(this);
	w_systray->setTextFormat(Qt::RichText);
	w_systray->setPixmap(w_systray->loadIcon(APP_NAME_L));
	QToolTip::add( w_systray, QString("KMobileTools ") + STR_VERSION );
	w_systray->show();
	
	//Now menu bar and menu item
	w_appmenu=new KMenuBar(this,"menubar");
	
	// Calls menu group setup
	w_calls=new KPopupMenu( this );
	
	a_call=new KAction      ( i18n("Dial"), "button_ok" , 0, this, SLOT( dial_Clicked() ), this, "a_call" );	
	a_close=new KAction     ( i18n("Hangup"), "button_cancel", 0, this, SLOT( close_Clicked() ), this, "a_close"  );
	a_phonebook=new KAction ( i18n("Pick number from phonebook"), "korganizer", 0, this, SLOT( phoneBook() ), this, "a_phonebook" );
	a_exit=new KAction ( i18n("Exit"), "exit", 0, this,  SLOT( exit() ), this, "a_exit" );
	
// 	a_ldials=new KAction( this, "last_dials" );
// 	a_ldials->setText( i18n("Dialed numbers") );
// 	a_lrecvd=new KAction( this, "last_received" );
// 	a_lrecvd->setText( i18n("Last received calls") );
// 	a_lunans=new KAction( this, "last_unanswered" );
// 	a_lunans->setText( i18n("Last unanswered calls") );

	// Now add this items to call menu
	a_call->plug( w_calls );
	a_close->plug( w_calls );
	w_calls->insertSeparator();
	a_phonebook->plug( w_calls );
	w_calls->insertSeparator();
	a_exit->plug( w_calls );

// 	a_ldials->plug( w_calls );
// 	a_lrecvd->plug( w_calls );
// 	a_lunans->plug( w_calls );
	
	w_appmenu->insertItem ( i18n("&Calls"), w_calls );
	
	// SMS menu group setup
	w_sms=new KPopupMenu( this );
	a_newSMS=new KAction( i18n("Write new SMS"), "mail_new", 0, this, SLOT( newSMSWin() ), this, "newSMS" );
	a_rSMS=new KAction ( i18n("Read received SMS"), "mail_get", 0, this, SLOT( smsList() ), this, "recSMS" );
	a_sSMS=new KAction ( i18n("Read stored SMS"), "mail_forward", 0, this, SLOT( smsList() ), this, "outSMS" );
	
	a_newSMS->plug( w_sms );
	a_rSMS->plug( w_sms );
	a_sSMS->plug( w_sms );
	
	w_appmenu->insertItem ( i18n("&SMS"), w_sms );
	
	// Settings menu group setup
	w_settings=new KPopupMenu ( this );
	a_settings=new KAction( i18n("Main settings"), "configure", 0, this, SLOT(showSettingsWin() ), this, "configureMenu" );
	a_notify=new KAction( i18n("Configure &Notifications"), "knotify", 0, this, SLOT(showNotifyConfig() ), this, "notify" );
	a_gsmReinit=new KAction( i18n("Reinitialize GSM device"), "reload", 0, this, SLOT( initDeviceSlot() ), this, "reinitGSM" );
	a_terminal=new KAction( i18n("Serial terminal"), "konsole", 0, this, SLOT(openTerminal() ), this, "serialTerminal" );
	
	a_settings->plug (w_settings);
	a_notify->plug (w_settings);
	a_gsmReinit->plug (w_settings);
	a_terminal->plug (w_settings);
	
	w_appmenu->insertItem ( i18n("Se&ttings"), w_settings);

	w_help= helpMenu( /*"KMobileTools"*/ );
	w_appmenu->insertItem ( i18n ("&Help"), w_help );
	w_systray->contextMenu()->insertItem( i18n ("&Help"), w_help, 0,1 );
	w_systray->contextMenu()->insertItem( i18n ("Main settings"), w_settings, 0,1 );
	w_systray->contextMenu()->insertItem( i18n ("&SMS"), w_sms, 0,1 );
	w_systray->contextMenu()->insertItem( i18n ("&Calls"), w_calls, 0,1 );
// 	w_systray->contextMenu()->insertSeparator( 2 );

	// Now we need to connect slots
// 	connect( a_settings, SIGNAL( activated() ), this, SLOT( showSettingsWin() ) );
// 	connect( a_gsmReinit, SIGNAL( activated() ), this, SLOT( saveSettings() ) );
// 	connect( a_phonebook, SIGNAL( activated() ), this, SLOT( phoneBook() ) );
// 	connect( a_close, SIGNAL( activated() ), this, SLOT( close_Clicked() ) );
// 	connect( a_call, SIGNAL( activated() ), this, SLOT( dial_Clicked() ) );
// 	connect( a_gsmReinit, SIGNAL( activated() ), d_gsm, SLOT( initDevice() ) );
// 	connect( a_rSMS, SIGNAL( activated() ), this, SLOT( smsList() ) );
// 	connect( a_sSMS, SIGNAL( activated() ), this, SLOT( smsList()  ) );

	// Setting window size	
	resize(  QSize(200,290) );
	setAutoSaveSettings();
	cntCall=0;
	cntCharge=-20;
	
	connect( mainWidget_ui->b_pick, SIGNAL( clicked() ), this, SLOT( phoneBook() ) );
	connect( mainWidget_ui->b_dial, SIGNAL( clicked() ), this, SLOT( dial_Clicked() ) );
	connect( mainWidget_ui->b_hangup, SIGNAL( clicked() ), this, SLOT(close_Clicked() ) );
	connect( mainWidget_ui->b_answer, SIGNAL( clicked() ), this, SLOT(answer_clicked() ) );
	connect( mainWidget_ui->b_sms, SIGNAL( clicked() ), this, SLOT(smsList() ) );
	connect( mainWidget_ui->b_newSMS, SIGNAL( clicked() ), this, SLOT(newSMSWin() ) );
	connect( mainWidget_ui->h_number, SIGNAL(returnPressed() ), this, SLOT(dial_Clicked() ) );
	QTimer *status_timer=new QTimer(this);
	connect(status_timer,SIGNAL(timeout()),this, SLOT( updateStatus() ) );
	status_timer->start(300);
	
	// now we need to handle cmdLineargs
	KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
	if(args->count()>0) mainWidget_ui->h_number->setCurrentText( args->arg(0) );
	if (!d_gsm->getDevice()->isInitialized() ) showSettingsWin();
	if( !args->isSet("nd") ) dial_Clicked();
	connect(w_systray, SIGNAL(quitSelected() ), this, SLOT(exit() ) );

}

kmobiletools::~kmobiletools()
{
	delete w_systray;
}

#include "kmobiletools.moc"


void kmobiletools::showSettingsWin()
{
	KConfigDialog* w_settings=new d_settingsUI(this, "main_settings", Config); 
// 	w_settings->resize( QSize( 200,400 ));
	KConfigDialogManager* m_General= NULL;
	m_General=new KConfigDialogManager (w_settings,Config);
	w_settings->show();
}


void kmobiletools::phoneBook()
{
// 	if( ! d_gsm->getAbInited() ) d_gsm->initPhoneBook("MT");
	d_PickPhoneBook* pick=new d_PickPhoneBook( this, "phonebook-dial" );
	pick->show();
}

void kmobiletools::updateStatus()
{
// 	if(cntCharge<0) cntCharge++;
	if(d_gsm==NULL || !d_gsm->getDevice()->isInitialized() ) return;
	mainWidget_ui->f_battery->setProgress( d_gsm->getCharge() );
	mainWidget_ui->f_signal->setProgress( d_gsm->getSignal() );
	QString trayToolTip;
	QString Signal, Battery;
	
	if(d_gsm->getSignal()>=0)
	{
		Signal=QString::number(d_gsm->getSignal()) + '%';
		mainWidget_ui->f_signal->setTextEnabled( true );
	} else
	{
		Signal=i18n( "<not avaliable>" ).replace("<", "&lt;").replace(">", "&gt;");
		mainWidget_ui->f_signal->setTextEnabled( false );
		mainWidget_ui->f_signal->setProgress(0);
	}
	if(d_gsm->getCharge()>=0)
	{
		Battery=QString::number(d_gsm->getCharge()) + '%';
		mainWidget_ui->f_battery->setTextEnabled( true );
	} else
	{
		Battery=i18n( "<not avaliable>" ).replace(" ", "&nbsp;").replace("<", "&lt;").replace(">", "&gt;");
		mainWidget_ui->tl_charging->setText( "" );
		mainWidget_ui->f_battery->setTextEnabled( false );
		mainWidget_ui->f_battery->setProgress(0);
	}

	switch( d_gsm->getCharging() ){
		case 0:
			mainWidget_ui->l_charging->show();
			mainWidget_ui->l_charging->setColor( QColor(90,90,90) );
			mainWidget_ui->tl_charging->setText( i18n("No charger attached") );
			QToolTip::add( mainWidget_ui->l_charging, i18n("No charger attached") );
			break;
		case 1:
			mainWidget_ui->l_charging->show();
			if( d_gsm->getCharge() != 100 )
			{
				mainWidget_ui->l_charging->setColor( QColor(255,255,0) );
				mainWidget_ui->tl_charging->setText( i18n("Charger attached") );
				QToolTip::add( mainWidget_ui->l_charging, i18n("Charging battery") );
				trayToolTip+= i18n(" (Charging)").replace(" ", "&nbsp;");;
			} else
			{
				mainWidget_ui->l_charging->setColor( QColor(0,255,0) );
				mainWidget_ui->tl_charging->setText( i18n("Charger attached") );
				QToolTip::add( mainWidget_ui->l_charging, i18n("Battery fully charged") );
				trayToolTip+= i18n(" (Fully charged)").replace(" ", "&nbsp;");
			}
			break;
		case 2:
			mainWidget_ui->l_charging->show();
			mainWidget_ui->l_charging->setColor( QColor(255,0,0) );
			mainWidget_ui->tl_charging->setText( i18n("Battery error") );
			QToolTip::add( mainWidget_ui->l_charging, i18n("Battery error") );
			trayToolTip+= i18n("Battery error").replace(" ", "&nbsp;");;
			break;
		default:
			mainWidget_ui->l_charging->hide();
			break;
	}
	trayToolTip=QString("<DIV align='center'><TABLE border=0 align='center'><TR align='center'>") + 
						QString("<TD><img src='%1' align='right'></TD>") 
						.arg( KGlobal::iconLoader()->iconPath("kmobiletools", -1 * KIcon::SizeMedium) ) + 
						"<TD align='left' valign='center'><b>KMobileTools " +
						STR_VERSION + 
						"</b></TD></TR></TABLE></DIV>" +
						QString("&nbsp;<img src='%1' align='top'>&nbsp;&nbsp;")
						.arg(KGlobal::iconLoader()->iconPath("kppp", -1 * KIcon::SizeSmall) ) +
						i18n("Signal") +
						QString(": %1<BR>").arg( Signal ).replace(" ", "&nbsp;") +
						QString("&nbsp;<img src='%1' align='top'>&nbsp;&nbsp;")
						.arg(KGlobal::iconLoader()->iconPath("energy", -1 * KIcon::SizeSmall) ) +
						i18n("Battery") +
						QString(": %2 ").arg( Battery ).replace(" ", "&nbsp;") +
						trayToolTip +
						QString("<BR>&nbsp;<IMG src='%1'>&nbsp;&nbsp;")
						.arg(KGlobal::iconLoader()->iconPath("mail_generic", -1 * KIcon::SizeSmall) ) +
						i18n("%n new message, %1 in total.", "%n new messages, %1 in total.", d_gsm->getSMSList()->getNewSMS() )
						.arg( d_gsm->getSMSList()->count() );
	I18N_NOOP("_n: %n new message, %1 in total.\n%n new messages, %1 in total.");

	QToolTip::add( w_systray, trayToolTip  );
	mainWidget_ui->smsStatus->setText( i18n("%n new message, %1 in total.", "%n new messages, %1 in total.", d_gsm->getSMSList()->getNewSMS() )
		.arg( d_gsm->getSMSList()->count() ) );
	if( d_gsm->getSMSList()->getNewSMS()>0 )
		mainWidget_ui->lp_sms->setPixmap( KGlobal::iconLoader()->loadIcon( "mail_get", KIcon::FirstGroup, KIcon::SizeMedium ) );
	else
		mainWidget_ui->lp_sms->setPixmap( KGlobal::iconLoader()->loadIcon( "mail_generic", KIcon::FirstGroup, KIcon::SizeMedium ) );
	if(cntCall> 17 ) cntCall=0;
	if(d_gsm->getCalling() && cntCall==0)
	{
		KNotifyClient::event(w_systray->winId(), "kmobiletools_incoming_call", i18n("Incoming call") );
		cntCall++;
		return;
	} else cntCall++;
	
	if( ! (d_gsm->getSMSList()->getSMStoNotify().isEmpty() ) )
	{
		KNotifyClient::event(w_systray->winId(), "kmobiletools_new_sms", i18n("New SMS message from %1")
			.arg( d_gsm->getSMSList()->find( d_gsm->getSMSList()->getSMStoNotify().first() )->getParsedNumList().join(",") )  /*, this, SLOT(smsList() ) */ );
		d_gsm->getSMSList()->delNotifySMS( d_gsm->getSMSList()->getSMStoNotify().first() );
		return;
	}
	#define COUNT_CHARGE_INC 100
	if( cntCharge!=0 && ( d_gsm->getCharge() < 10 || cntCharge<(COUNT_CHARGE_INC*3) ) ) cntCharge++;
	if( d_gsm->getCharge() > 10 && d_gsm->getCharge() < 100 ) cntCharge=0;
	
	if( d_gsm->getCharge() < 10 && d_gsm->getCharging()!=1 && (cntCharge%COUNT_CHARGE_INC)==0 )
	{
		KNotifyClient::event(w_systray->winId(), "kmobiletools_low_batt", i18n("Low Battery Level") );
		cntCharge++;
		return;
	}
	if( d_gsm->getCharge() == 100 && d_gsm->getCharging()==1 && (cntCharge%COUNT_CHARGE_INC)==0 )
	{
		KNotifyClient::event(w_systray->winId(), "kmobiletools_charge_full", i18n("Battery Charging Complete") );
		cntCharge++;
		return;
	}
}



/*!
    \fn kmobiletools::close_Clicked()
 */
void kmobiletools::close_Clicked()
{
	d_gsm->hangup();
}


/*!
    \fn kmobiletools::dial_Clicked()
 */
void kmobiletools::dial_Clicked()
{
	d_gsm->dial( mainWidget_ui->h_number->currentText() );
}

void kmobiletools::smsList()
{
// 	d_gsm->initSMSList();
// 	KDialogBase* smsListDialog=new KDialogBase( this, sender()->name(), true, i18n("SMS list dialog"), 0 );
// 	smsListDialog->setMainWidget ( new d_SMSList(smsListDialog, sender()->name() ) );
// 	smsListDialog->resize(430,350);
// 	smsListDialog->show();
	d_SMSList* smsList=new d_SMSList( this, sender()->name() );
	smsList->show();
}

void kmobiletools::newSMSWin()
{
	d_NewSMS* newSMS=new d_NewSMS(this, "newSMSWin") ;
	newSMS->show();
}

bool kmobiletools::queryClose()
{
	if( sender() ) kdDebug() << sender()->className() << endl;
		else kdDebug() << "No sender\n";
	if( sender() != 0 ) 
	{
		delete d_gsm;
		return true;
	}
	hide();
    // Message modified from kopete...
    KMessageBox::information( this,
      i18n( "<qt>Closing the main window will keep KMobileTools running in the "
      "system tray. Use 'Quit' from the system tray menu to quit the application.</qt>" ),
      i18n( "Docking in System Tray" ), "hideOnCloseInfo");

	return false;
}

void kmobiletools::exit()
{
	delete d_gsm;
	delete this;
}
/*!
    \fn kmobiletools::answer_clicked()
 */
void kmobiletools::answer_clicked()
{
	d_gsm->answer();
}

void kmobiletools::initDeviceSlot()
{
	d_gsm->initDevice();
}

void kmobiletools::callNumber(QString rec_number)
{
	mainWidget_ui->h_number->setCurrentText(rec_number);
}

void kmobiletools::keyPressEvent(QKeyEvent *k)
{
	switch ( (int) k->ascii() )
	{
		case (27):
			close_Clicked();
			break;
		default:
			KMainWindow::keyPressEvent(k);
	}
}

void kmobiletools::showNotifyConfig()
{
	KNotifyDialog::configure( mainWidget_ui );
}

void kmobiletools::openTerminal()
{
#ifdef KMT_USE_SEYON
	KProcess term;
#endif
	d_gsm->getDevice()->sendCommand("ATE1\r",50);
	gsmThread.setShutdown();
	gsmThread.wait();
#ifdef KMT_USE_SEYON
	term << "konsole" << "-e" << "seyon" << "-noemulator" << "-modem" << Config->getDevice();
	term.start();
	KMessageBox::information(this, i18n("Press OK only when terminal emulator is closed."), i18n("Terminal Emulator")  );
	term.kill();
#else
	d_Terminal term( d_gsm->getDevice(), this);
	term.exec();
#endif
	d_gsm->getDevice()->sendCommand("ATE0\r",50);
	gsmThread.start();
}
