/***************************************************************************
 *   Copyright (C) 2004 by Marco Gulino                                    *
 *   marco.gulino@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _KMOBILETOOLS_H_
#define _KMOBILETOOLS_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// KDE Includes
#include <kmainwindow.h>
#include <ksystemtray.h>
#include <kmenubar.h> 
#include <kpopupmenu.h> 
#include <kaction.h> 
#include <kconfigdialogmanager.h> 
#include <kprogress.h> 
#include <qlabel.h>
#include <qframe.h>

#define APP_NAME "KMobileTools"
#define APP_NAME_L "kmobiletools"

#include "c_config.h"
#include "gsm.h"
#include "mainWidget.h"
#include "dcopinterface.h"

/**
 * @short Application Main Window
 * @author Marco Gulino <marcogulino1@virgilio.it>
 * @version 0.2.0
 */
class kmobiletools : public KMainWindow, virtual public DCOPInterface
{
    Q_OBJECT
public:
    kmobiletools();
    virtual ~kmobiletools();
    mainWidget* getMainWidget() { return mainWidget_ui; }
	KSystemTray* getSysTray() { return w_systray; }

private:
	// Widget items
	KMenuBar*	w_appmenu;
	KPopupMenu* w_calls;
	KPopupMenu* w_sms;
	KPopupMenu* w_settings;
	KPopupMenu* w_help;
	
	// Actions
	
	// Calls Menu group
	KAction* a_call;
	KAction* a_close;
	KAction* a_phonebook;
	KAction* a_ldials;
	KAction* a_lrecvd;
	KAction* a_lunans;
	KAction* a_exit;
	
	// SMS Menu group
	KAction* a_newSMS;
	KAction* a_rSMS;
	KAction* a_sSMS;
	
	// Settings Menu group
	KAction* a_settings;
	KAction* a_gsmReinit;
	KAction* a_notify;
	KAction* a_terminal;
	c_config* Config;
	
	int cntCharge;
	int cntCall;
	

protected:
	mainWidget* mainWidget_ui;
	KSystemTray* w_systray;
	
public slots:
    void showSettingsWin();
    void phoneBook();
    void updateStatus();
    void close_Clicked();
    void dial_Clicked();
    void smsList();
    void newSMSWin();
    void answer_clicked();
    void initDeviceSlot();
    virtual void callNumber(QString);
    void keyPressEvent(QKeyEvent *k);
    void showNotifyConfig();
    void openTerminal();
    void exit();
//    void trayClose();

protected:
    bool queryClose();
};

#endif // _KMOBILETOOLS_H_
