//
//
// C++ Interface: $MODULE$
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@gmail.com>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef KMFGENERICDOC_H
#define KMFGENERICDOC_H

#include "kmfdoc.h"

// QT includes
#include <qdom.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qptrlist.h>

// KDE includes
#include <kurl.h>

// Project includes
#include "ipaddress.h"
#include "kmfprotocol.h"

class KMFError;
class KMFNetZone;
class IPAddress;
class KMFCompilerInterface;
/**
@author Christian Hubinger
*/
class KDE_EXPORT KMFGenericDoc : public KMFDoc {
public:
	KMFGenericDoc( QObject*, const char* );

	~KMFGenericDoc();
	/** resets the document to the initial values
	*/
	void clear();

	bool isEmpty();
	
	/** return a QString containing the documents script to 
		setup the firewall configuration */
	const QString& compile();
	
	/** Return DomDocument of this Chain */
	const QDomDocument& getDOMTree();

	void loadXML( const QDomDocument& );

	KMFDoc* parseXMLRuleset( const KURL& );

	QPtrList<KMFProtocol> protocolLibrary() const {
		return m_protocol_library;
	};

	KMFNetZone *incomingZone() const {
		return m_zone_incoming;
	};

	KMFNetZone *outgoingZone() const {
		return m_zone_outgoing;
	};

	KMFNetZone *trustedHostsZone() const {
		return m_zone_trusted;
	};

	KMFNetZone *maliciousHostsZone() const {
		return m_zone_malicious;
	};

	KMFNetZone *badServersHostsZone() const {
		return m_zone_badServers;
	};

	KMFNetZone *badClientsHostsZone() const {
		return m_zone_badClients;
	};
	QPtrList<KMFNetZone>& zones() const;

	bool restrictOutgoingConnections() const {
		return m_restrictOutgoingConnections;
	};
	void setRestrictOutgoingConnections( bool ) ;

	bool allowIncomingConnections()const {
		return m_allowIncomingConnections;
	};
	void setAllowIncomingConnections( bool );

	bool allowPingReply() const {
		return m_allowPingReply;
	};
	void setAllowPingReply( bool );

	bool limitPingReply() const {
		return m_limitPingReply;
	};
	void setLimitPingReply( bool );

	bool useNat() const {
		return m_useNat;
	};
	
	void setUseNat( bool );

	bool useMasquerade() const {
		return m_useMasquerade;
	};
	void setUseMasquerade( bool );

// 	bool restrictNat() const {
// 		return m_restrictNat;
// 	};
// 	void setRestrictNat( bool );


	IPAddress* natAddress() const {
		return m_natAddress;
	};

	void setNatAddress( const QString& );

// 	const QStringList& allowedIncomingInterfaces() const {
// 		return m_allowedIncomingInterfaces;
// 	};
// 	
// 	void addAllowedIncomingInterface( const QString& );
// 	void delAllowedIncomingInterface( const QString& );
// 	void setAllowedIncomingInterfaces( const QString& );
// 	bool isAllowedIncomingInterface( const QString& );

	const QString& outgoingInterface() const {
		return m_outgoingInterface;
	};
	void setOutgoingInterface( const QString& );

	bool logDropped() const {
		return m_logDropped;
	};
	void setLogDropped( bool );

	bool limitLog() const {
		return m_limitLog;
	};
	void setLimitLog( bool );

	const QString& logPrefix() const {
		return m_logPrefix;
	};
	void setLogPrefix( const QString& );



protected:
	void initDoc();
	KMFNetZone* addZone( const QString& name, KMFError* err );
	KMFError* delZone( KMFNetZone* zone );
	KMFNetZone* findZone( const QString& name ) const;

private:
	bool loadProtocolLibrary();
	bool loadCustomProtocolLibrary();
// 	KMFCompilerInterface* compiler();
private: // DATA
	QPtrList<KMFProtocol> m_protocol_library;
	QPtrList<KMFProtocol> m_customProtocolLibrary;
	QPtrList<KMFNetZone> m_zones;
	KMFNetZone* m_zone_incoming;
	KMFNetZone* m_zone_outgoing;
	KMFNetZone* m_zone_trusted;
	KMFNetZone* m_zone_malicious;
	KMFNetZone* m_zone_badClients;
	KMFNetZone* m_zone_badServers;
	bool m_allowPingReply, m_limitPingReply, m_allowIncomingConnections, m_restrictOutgoingConnections;

	bool m_useNat, m_useMasquerade, m_logDropped, m_limitLog;
	IPAddress *m_natAddress;
	QString m_outgoingInterface, m_logPrefix;
// 	QStringList m_allowedIncomingInterfaces;
	
};

#endif
