//
//
// C++ Interface: $MODULE$
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@gmail.com>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef KMFGENERICINTERFACEPROTOCOL_H
#define KMFGENERICINTERFACEPROTOCOL_H

#include <kmyfirewallgenericinterfaceprotocolwidget.h>

// QT includes
class QListViewItem;


#include <qptrlist.h>
#include <qstring.h>
#include <qguardedptr.h>
#include <qpixmap.h>


// KDE includes
class KPopupMenu;

// Project includes
#include "../core/kmfprotocol.h"

class KMFGenericDoc;
class KMFNetZone;
class KMFListViewItem;
class KMFNetHost;
class KMFNetworkWidget;
class QCheckBox;
class QTextEdit;
/*class KMFError;
class KMFErrorHandler;*/

class KMFGenericInterfaceProtocol : public KMyFirewallGenericInterfaceProtocolWidget {
	Q_OBJECT
public:
	KMFGenericInterfaceProtocol( QWidget *parent = 0, const char *name = 0, WFlags f = 0 );

	~KMFGenericInterfaceProtocol();
	void loadDoc( KMFGenericDoc* );

	void setType( int );
	enum { INCOMING, OUTGOING };

public slots:
	void slotUpdateView();

private slots:
	void slotNewProtocolSelected( QListViewItem* );
	void slotNewItemSelected( QListViewItem* );
	void slotEnableProtocolLimit( bool );
	void slotSetProtocolLimitRate( int );
	void slotSetProtocolLimitInterval( const QString& );
	void slotEnableProtocolLogging( bool );
	void slotZoneRBM( QListViewItem*, const QPoint&, int );
	void slotAddZone();
	void slotDelZone();
	void slotAddHost();
	void slotDelHost();
	void slotAddressChanged( const QString& );
	void slotZoneChanged( KMFNetZone* );
	void slotCurrentZoneChanged( const QString& );
	void slotRenameZone();
	void slotRenameHost();
	void slotRenameItem( QListViewItem* item, int, const QString& name );
// 	void slotZoneDeadEnd( bool onoff );
	void slotTimerShot();
	void slotRestrictionChanged();
	void slotHostLimitToggled( bool );
	void slotHostLogToggled( bool );
	void slotHostLimitValueChanged( int );
	void slotHostLimitScaleChanged( int );
private:
	void loadIcons();
	KMFListViewItem* findItem( int obj_id );

private:
	KMFGenericDoc *m_doc;
	KPopupMenu* m_contextMenu;
	QWidget *m_zoneOptions;
//	QCheckBox *m_cb_dead_end;
	QTextEdit *m_zone_desc;
	KMFNetworkWidget *m_network_widget;
	
/*	KMFError m_err;
	KMFErrorHandler *m_errHandler;*/
	QPtrList<KMFProtocol> m_available_protocols;
	QPtrList<KMFNetZone> m_zones;
	QGuardedPtr<KMFProtocol> m_protocol;
	QGuardedPtr<KMFNetZone> m_zone;
	QGuardedPtr<KMFNetHost> m_host;
	QGuardedPtr<KMFNetZone> m_incoming_root_zone;
	QGuardedPtr<KMFNetZone> m_outgoing_root_zone;
	int m_type;
	QPixmap icon_up, icon_down, icon_del, icon_edit, icon_rule, icon_filter, icon_rename,
	icon_chain, icon_log, icon_accept, icon_drop, icon_cmd, icon_reject, icon_return,
	        icon_target, icon_queue, icon_new, icon_copy, icon_move;

};

#endif
