/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
Author: Christian Hubinger <chubinger@gmail.com>, (C) 2001-2004
*/

#ifndef KMFCONFIGDIALOG_H
#define KMFCONFIGDIALOG_H

#include <qwidget.h>
#include <kdialogbase.h>
#include <kconfig.h>
#include <kglobal.h>
#include <kprocess.h>
#include <qstring.h>
#include <qpixmap.h>


#include "interfaces/kmfcompilerinterface.h"

class QFrame;
class QCheckBox;
class QRadioButton;
class QButtonGroup;
class KURLRequester;
class KPushButton;
class KComboBox;
class KListBox;
class KIntSpinBox;
class KMFCheckListOutput;

class KMFConfigDialog : public KDialogBase {
	Q_OBJECT

public:
	KMFConfigDialog( QWidget *parent = 0, const char *name = 0, bool modal = true );
	~KMFConfigDialog();
	void registerCompiler( KMFCompilerInterface* );
	
	
	
public slots:
	void slotReadConfig();
	void slotSaveConfig();
	void slotAutoConf();

private slots:
	void slotEnableGentooMode( bool );
	void slotEnableSlackwareMode( bool );
	void slotEnableGenericInterface( bool );
// 	void slotEnableNonLSBDist( bool );
	void slotDistChanged( int );
	void slotProcessExited( KProcess* );
	void slotReceivedOutput( KProcess*, char*, int );
	void slotReceivedError( KProcess*, char*, int );
	void slotDelInterface();
	void slotAddInterface();
	void slotEnableWarnings();
	void slotApply();
	void accept();
	void slotSetBackend( int );
	void slotSetOS( int );
	
private:  // members
	void setupListView();
	void setupInterfaces();
	void setupPaths();
	void setupGeneral();
	void setupPlatformBackend();
	void setupPlugins();
	void checkPlugins();
	void loadIcons();
	bool isRunning();
	bool checkFirstRun();

private:  // data
	KProcess* childproc;
	KProcess &operator<<( const QString& arg );
	KMFCheckListOutput *m_progView;
	QString m_processName;


	// General
	QCheckBox *m_cb_show_splash;
	QCheckBox *m_cb_show_selInterface;
	QCheckBox *m_cb_generic_interface;
	KIntSpinBox *m_sb_max_undo;

	// Path widget
	QPtrList<QStringList> *m_backends;
	KComboBox *m_cb_dist;
	KComboBox *m_cb_os;
	KComboBox *m_cb_backend;
	QLabel *m_lab_ipt_path;
	QLabel *m_lab_init_path;
	QLabel *m_lab_runlevel_path;
	QLabel *m_lab_modprobe_path;
	KURLRequester *m_url_ipt_path;
	KURLRequester *m_url_init_path;
	KURLRequester *m_url_runlevel_path;
	KURLRequester *m_url_modprobe_path;

	// Interfaces
	KPushButton *m_b_add_interface;
	KPushButton *m_b_del_interface;
	KPushButton *m_b_enable_warnings;
	KComboBox *m_cb_interface_name;
	KListBox *m_lb_interfaces;
	KIntSpinBox *m_sb_interface_number;
	QPixmap icon_paths, icon_interfaces, icon_general, icon_listview;
	QFrame * pageGeneric;
	// ListView
	QCheckBox *m_cb_show_cmds;
	QCheckBox *m_cb_show_desc;
	QCheckBox *m_cb_show_objectID;
	QLabel *m_lvp_text1, *m_lvp_text2, *m_lvp_text3;
	
	// Plugins
	KListView *m_lv_plugins;
signals:
	void sigConfigChanged();
};

#endif
