/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
Author: Christian Hubinger <chubinger@gmail.com>, (C) 2001-2004
*/

#ifndef KMFLISTVIEWITEM_H
#define KMFLISTVIEWITEM_H

#include "kmflistview.h"

// QT includes
#include <qstring.h>
// KDE includes

// Project includes

/**
@author Christian Hubinger
*/
class IPTable;
class IPTChain;
class IPTRule;
class IPTRuleOption;
class NetfilterObject;
class KMFNetZone;
class KMFNetHost;

class KDE_EXPORT KMFListViewItem : public KListViewItem {
public:
	KMFListViewItem( KListView *parent, NetfilterObject* );
	KMFListViewItem( KListViewItem *parent, NetfilterObject* );
	KMFListViewItem( KListView *parent, KListViewItem *after, NetfilterObject* );
	KMFListViewItem( KListViewItem *parent, KListViewItem *after, NetfilterObject* );

	virtual ~KMFListViewItem();

	NetfilterObject* netfilterObject() const;

	IPTable* table()  const {
		return m_table;
	};
	IPTChain* chain() const {
		return m_chain;
	};
	IPTRule* rule() const {
		return m_rule;
	};
	IPTRuleOption* ruleOption() const {
		return m_option;
	};

	KMFNetZone* zone() const {
		return m_zone;
	};

	KMFNetHost* host() const {
		return m_host;
	};

	bool isTopItem() const {
		return m_top;
	};
	int type() const {
		return m_type;
	}

	int objectID() const {
		return m_obj_id;
	}

	void setupZoneView();

	void deleteChildren();
	void setChildrenInUse( bool );
	void setTopItem( bool );
	void setInUse( bool );
	bool inUse();
	enum { TABLE = 0, CHAIN = 1, RULE = 2, RULEOPTION = 3 , NETZONE = 4, NETHOST = 5 };

	void loadNetfilterObject( NetfilterObject* );
	QString key( int column, bool ascending ) const;

private:
	IPTable *m_table;
	IPTChain *m_chain;
	IPTRule *m_rule;
	IPTRuleOption *m_option;
	KMFNetZone* m_zone;
	KMFNetHost* m_host;
	int m_type;
	int m_obj_id;
	bool m_top;
	bool m_inUse;
};

#endif
