/***************************************************************************
 begin                : Wed Aug 21 2002
 copyright            : (C) 2002 by Christian Hubinger
 email                : chubinger@gmail.com.orphi.iki
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMFXMLPARSER_H
#define KMFXMLPARSER_H


/**XML Parser for the kmyfirewall xml rulset
  *@author Christian Hubinger
  */ 
// qt includes
#include <qdom.h>

class KMFIPTDoc;
class KMFError;
class KMFErrorHandler;
class KURL;

class KMFXMLParser {
public:
	KMFXMLParser();
	~KMFXMLParser();

	KMFIPTDoc* parseKMFRS( const QString& filename );
	KMFError* writeKMFRS( KMFIPTDoc* doc, const QString& filename );
	const QString& writeKMFRS( KMFIPTDoc* kmfdoc );
private:
	QDomDocument domTree;
	void parseDocumenmtAbstract( const QDomElement &abstarct );
	KMFError* parseIPTRule( const QDomElement &rule );
	KMFError* parseIPTChain( const QDomElement &rule );
	KMFIPTDoc *kmfdoc;
	KMFError *m_err;
	KMFErrorHandler *m_err_handler;

};

#endif
